/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemData;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public final class SVGPaletteItemDataNode
extends DataNode {
    private static final String IMAGE_ICON_BASE = "org/netbeans/modules/mobility/svgcore/resources/svg.png";

    SVGPaletteItemDataNode(SVGPaletteItemDataObject sVGPaletteItemDataObject, Lookup lookup) {
        super((DataObject)sVGPaletteItemDataObject, Children.LEAF, lookup);
        this.setIconBaseWithExtension(IMAGE_ICON_BASE);
    }

    public String getName() {
        return this.getData().getName();
    }

    public String getShortDescription() {
        return this.getData().getFilePath();
    }

    public Image getIcon(int n) {
        if (n == 2 || n == 4) {
            return this.getData().getIcon32();
        }
        return super.getIcon(n);
    }

    public String getDisplayName() {
        return this.getData().getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    private SVGPaletteItemData getData() {
        return ((SVGPaletteItemDataObject)this.getDataObject()).getData();
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        Lookup lookup = this.getLookup();
        ActiveEditorDrop activeEditorDrop = (ActiveEditorDrop)lookup.lookup(ActiveEditorDrop.class);
        ActiveEditorDropTransferable activeEditorDropTransferable = new ActiveEditorDropTransferable(activeEditorDrop);
        exTransferable.put((ExTransferable.Single)activeEditorDropTransferable);
        return new NoExternalDndTransferable((Transferable)exTransferable);
    }

    private static class NoExternalDndTransferable
    implements Transferable {
        private Transferable t;
        private DataFlavor uriListFlavor;

        public NoExternalDndTransferable(Transferable transferable) {
            this.t = transferable;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.t.getTransferDataFlavors();
            if (this.t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || this.t.isDataFlavorSupported(this.getUriListFlavor())) {
                ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(dataFlavorArray.length);
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!this.isDataFlavorSupported(dataFlavorArray[i])) continue;
                    arrayList.add(dataFlavorArray[i]);
                }
                dataFlavorArray = arrayList.toArray(new DataFlavor[arrayList.size()]);
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavor) || this.getUriListFlavor().equals(dataFlavor)) {
                return false;
            }
            return this.t.isDataFlavorSupported(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.t.getTransferData(dataFlavor);
        }

        private DataFlavor getUriListFlavor() {
            if (null == this.uriListFlavor) {
                try {
                    this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
            return this.uriListFlavor;
        }
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private ActiveEditorDrop drop;

        ActiveEditorDropTransferable(ActiveEditorDrop activeEditorDrop) {
            super(ActiveEditorDrop.FLAVOR);
            this.drop = activeEditorDrop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

