/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.MissingResourceException;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import javax.swing.text.BadLocationException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.export.Quantizer;
import org.netbeans.modules.mobility.svgcore.export.ScreenSizeHelper;
import org.netbeans.modules.mobility.svgcore.export.ShrinkPalette;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGSVGElement;

public class AnimationRasterizer {
    private static final int PATTERN_SIZE = 10;
    private static final Color PATTERN_COLOR1 = new Color(192, 192, 192);
    private static final Color PATTERN_COLOR2 = new Color(220, 220, 220);
    private static final Color BACKGROUND_COLOR = Color.WHITE;

    public static String createFileNameRoot(SVGDataObject sVGDataObject, Params params, ProjectConfiguration projectConfiguration, boolean bl) {
        String string;
        FileObject fileObject = sVGDataObject.getPrimaryFile();
        if (bl) {
            string = fileObject.getPath();
            String string2 = fileObject.getExt();
            if (string2 != null && string2.length() > 0) {
                string = string.substring(0, string.length() - string2.length() - 1);
            }
        } else {
            string = fileObject.getName();
        }
        if (params.isForAllConfigurations()) {
            if (projectConfiguration != null) {
                if (projectConfiguration != params.getProject().getConfigurationHelper().getDefaultConfiguration()) {
                    string = string + "_" + projectConfiguration.getDisplayName();
                }
            } else {
                string = string + "_{configuration-name-here}";
            }
        } else {
            string = string + AnimationRasterizer.getActiveConfigurationName(fileObject);
        }
        if (params.getElementId() != null) {
            string = string + "_" + params.getElementId();
        }
        return string;
    }

    public static String createFileName(String string, Params params, int n, int n2) {
        if (!params.isInSingleImage()) {
            assert (n >= 0);
            assert (n2 >= 0);
            string = string + "_" + n + "_" + n2;
        }
        string = params.getImageType().getFileName(string);
        return string;
    }

    public static void export(SVGDataObject sVGDataObject, Params params) throws MissingResourceException, IOException, BadLocationException {
        FileObject fileObject = sVGDataObject.getPrimaryFile();
        AnimationRasterizer.export(sVGDataObject, params, fileObject.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject export(SVGDataObject sVGDataObject, Params params, FileObject fileObject) throws MissingResourceException, IOException, BadLocationException {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)AnimationRasterizer.getMessage("TITLE_AnimationExportProgress"));
        FileObject fileObject2 = null;
        try {
            if (!params.isForAllConfigurations()) {
                progressHandle.start(1);
                String string = AnimationRasterizer.createFileNameRoot(sVGDataObject, params, null, false);
                fileObject2 = AnimationRasterizer.rasterizeImage(params.getSVGImage(), fileObject, string, params);
                progressHandle.progress(1);
            } else {
                FileObject fileObject3 = sVGDataObject.getPrimaryFile();
                Collection collection = params.getProject().getConfigurationHelper().getConfigurations();
                progressHandle.start(collection.size());
                int n = 0;
                int n2 = params.getImageWidth();
                int n3 = params.getImageHeight();
                for (ProjectConfiguration projectConfiguration : collection) {
                    Dimension dimension = ScreenSizeHelper.getCurrentDeviceScreenSize(fileObject3, null);
                    double d = (double)n2 / dimension.getWidth();
                    double d2 = (double)n3 / dimension.getHeight();
                    assert (projectConfiguration != null);
                    String string = AnimationRasterizer.createFileNameRoot(sVGDataObject, params, projectConfiguration, false);
                    Dimension dimension2 = ScreenSizeHelper.getCurrentDeviceScreenSize(fileObject3, projectConfiguration.getDisplayName());
                    params.setImageWidth((int)(dimension2.getWidth() * d));
                    params.setImageHeight((int)(dimension2.getHeight() * d2));
                    AnimationRasterizer.rasterizeImage(params.getSVGImage(), fileObject, string, params);
                    progressHandle.progress(++n);
                }
            }
            fileObject.refresh(false);
        }
        finally {
            progressHandle.finish();
        }
        return fileObject2;
    }

    private static BufferedImage adjustImage(BufferedImage bufferedImage, Params params) {
        if (params.getImageType().needsColorReduction()) {
            bufferedImage = params.getColorReductionMethod().reduceColors(bufferedImage, params);
        }
        return bufferedImage;
    }

    public static PreviewInfo previewFrame(SVGImage sVGImage, Params params, int n, float f) throws IOException {
        Object object;
        int n2;
        Object object2;
        if (n != -1 && ImageType.PNG8.equals((Object)params.getImageType()) && params.isInSingleImage()) {
            object2 = AnimationRasterizer.rasterizeFramesInSingleImage(sVGImage, params);
            int n3 = params.getImageWidth();
            n2 = params.getImageHeight();
            BufferedImage bufferedImage = AnimationRasterizer.createBuffer(n3, n2, params.isTransparent());
            object = bufferedImage.createGraphics();
            int n4 = n * n3;
            ((Graphics)object).drawImage((Image)object2, 0, 0, n3 - 1, n2 - 1, n4, 0, n4 + n3 - 1, n2 - 1, null);
            ((Graphics)object).dispose();
            object2 = bufferedImage;
        } else {
            object2 = AnimationRasterizer.rasterizeFrame(null, 0, sVGImage, params, f);
            object2 = AnimationRasterizer.adjustImage((BufferedImage)object2, params);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AnimationRasterizer.encodeImage((BufferedImage)object2, byteArrayOutputStream, params);
        if (ImageType.JPEG.equals((Object)params.getImageType())) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            object2 = AnimationRasterizer.decodeImage(byteArrayInputStream, params);
        } else if (params.isTransparent()) {
            n2 = ((BufferedImage)object2).getWidth();
            int n5 = ((BufferedImage)object2).getHeight();
            object = AnimationRasterizer.createBuffer(n2, n5, false);
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            graphics2D.setColor(PATTERN_COLOR1);
            graphics2D.fillRect(0, 0, n2, n5);
            graphics2D.setColor(PATTERN_COLOR2);
            int n6 = 0;
            for (int i = 0; i < n5; i += 10) {
                for (int j = n6; j < n2; j += 20) {
                    graphics2D.fillRect(j, i, 10, 10);
                }
                n6 ^= 0xA;
            }
            graphics2D.drawImage((Image)object2, 0, 0, null);
            graphics2D.dispose();
            object2 = object;
        }
        return new PreviewInfo((BufferedImage)object2, params.getImageType().toString(), byteArrayOutputStream.size());
    }

    private static BufferedImage createBuffer(int n, int n2, boolean bl) throws IIOException {
        try {
            return new BufferedImage(n, n2, bl ? 2 : 1);
        }
        catch (Throwable throwable) {
            System.err.println("Not enough memory");
            throw new IIOException("Not enough memory", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage rasterizeFrame(BufferedImage bufferedImage, int n, SVGImage sVGImage, Params params, float f) throws IIOException {
        int n2 = params.getImageWidth();
        int n3 = params.getImageHeight();
        if (bufferedImage == null) {
            bufferedImage = AnimationRasterizer.createBuffer(n2, n3, params.isTransparent());
            n = 0;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!params.isTransparent()) {
            graphics2D.setColor(BACKGROUND_COLOR);
            graphics2D.fillRect(n, 0, n2, n3);
        }
        SVGImage sVGImage2 = sVGImage;
        synchronized (sVGImage2) {
            float f2 = (float)n2 / (float)sVGImage.getViewportWidth();
            if ((float)sVGImage.getViewportHeight() * f2 > (float)n3) {
                f2 = (float)n3 / (float)sVGImage.getViewportHeight();
            }
            int n4 = Math.round((float)sVGImage.getViewportWidth() * f2);
            int n5 = Math.round((float)sVGImage.getViewportHeight() * f2);
            sVGImage.setViewportWidth(n4);
            sVGImage.setViewportHeight(n5);
            assert (n4 <= n2);
            assert (n5 <= n3);
            ScalableGraphics scalableGraphics = ScalableGraphics.createInstance();
            SVGSVGElement sVGSVGElement = (SVGSVGElement)sVGImage.getDocument().getDocumentElement();
            sVGSVGElement.setCurrentTime(f);
            scalableGraphics.bindTarget((Object)graphics2D);
            scalableGraphics.render(n + (n2 - n4) / 2, (n3 - n5) / 2, (ScalableImage)sVGImage);
            scalableGraphics.releaseTarget();
        }
        return bufferedImage;
    }

    private static BufferedImage rasterizeFramesInSingleImage(SVGImage sVGImage, Params params) throws IIOException {
        int n = params.getNumberFrames();
        int n2 = params.getImageWidth();
        int n3 = params.getImageHeight();
        BufferedImage bufferedImage = AnimationRasterizer.createBuffer(n2 * n, n3, params.isTransparent());
        for (int i = 0; i < n; ++i) {
            AnimationRasterizer.rasterizeFrame(bufferedImage, i * n2, sVGImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
        }
        bufferedImage = AnimationRasterizer.adjustImage(bufferedImage, params);
        return bufferedImage;
    }

    public static FileObject rasterizeImage(SVGImage sVGImage, FileObject fileObject, String string, Params params) throws IOException {
        FileObject fileObject2 = null;
        int n = params.getNumberFrames();
        if (params.isInSingleImage()) {
            BufferedImage bufferedImage = AnimationRasterizer.rasterizeFramesInSingleImage(sVGImage, params);
            String string2 = AnimationRasterizer.createFileName(string, params, -1, -1);
            FileObject fileObject3 = fileObject.getFileObject(string2);
            if (fileObject3 != null) {
                fileObject3.delete();
            }
            fileObject3 = fileObject.createData(string2);
            AnimationRasterizer.writeImageToFile(bufferedImage, fileObject3, params);
            fileObject2 = fileObject3;
        } else {
            for (int i = 0; i < n; ++i) {
                BufferedImage bufferedImage = AnimationRasterizer.rasterizeFrame(null, 0, sVGImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
                bufferedImage = AnimationRasterizer.adjustImage(bufferedImage, params);
                FileObject fileObject4 = fileObject.createData(AnimationRasterizer.createFileName(string, params, i, n));
                AnimationRasterizer.writeImageToFile(bufferedImage, fileObject4, params);
            }
        }
        return fileObject2;
    }

    static final String getMessage(String string) {
        return NbBundle.getMessage(AnimationRasterizer.class, (String)string);
    }

    private static int getEncodedSize(BufferedImage bufferedImage, Params params) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AnimationRasterizer.encodeImage(bufferedImage, byteArrayOutputStream, params);
        return byteArrayOutputStream.size();
    }

    private static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static int calculateAnimationSize(SVGImage sVGImage, Params params, ProgressUpdater progressUpdater) throws IOException, InterruptedException {
        int n;
        int n2 = params.getNumberFrames();
        if (params.isInSingleImage()) {
            int n3 = params.getImageWidth();
            int n4 = params.getImageHeight();
            BufferedImage bufferedImage = AnimationRasterizer.createBuffer(n3 * n2, n4, params.isTransparent());
            for (int i = 0; i < n2; ++i) {
                if (progressUpdater != null) {
                    progressUpdater.updateProgress(NbBundle.getMessage(AnimationRasterizer.class, (String)"LBL_PreviewRasterizing", (Object)String.valueOf(i), (Object)String.valueOf(n2)));
                }
                AnimationRasterizer.rasterizeFrame(bufferedImage, i * n3, sVGImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
            }
            AnimationRasterizer.checkInterrupted();
            if (progressUpdater != null) {
                progressUpdater.updateProgress(AnimationRasterizer.getMessage("LBL_PreviewEncoding"));
            }
            bufferedImage = AnimationRasterizer.adjustImage(bufferedImage, params);
            AnimationRasterizer.checkInterrupted();
            n = AnimationRasterizer.getEncodedSize(bufferedImage, params);
            if (progressUpdater != null) {
                progressUpdater.updateProgress(AnimationRasterizer.getSizeText(n));
            }
        } else {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                BufferedImage bufferedImage = AnimationRasterizer.rasterizeFrame(null, 0, sVGImage, params, params.getStartTime() + (float)i / params.getFramesPerSecond());
                AnimationRasterizer.checkInterrupted();
                bufferedImage = AnimationRasterizer.adjustImage(bufferedImage, params);
                AnimationRasterizer.checkInterrupted();
                n += AnimationRasterizer.getEncodedSize(bufferedImage, params);
                AnimationRasterizer.checkInterrupted();
            }
        }
        return n;
    }

    public static String getSizeText(int n) {
        if (n < 1024) {
            return n + " Bytes";
        }
        if (n < 0x100000) {
            return (double)Math.round((double)n / 102.4) / 10.0 + " KBytes";
        }
        return (double)Math.round((double)n / 104857.6) / 10.0 + " MBytes";
    }

    private static BufferedImage reduceColorsMedianCut(BufferedImage bufferedImage, Params params) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = bufferedImage.getRGB(i, j);
                nArray[n3++] = n4 >>> 24 > 127 ? n4 : nArray[0];
            }
        }
        Quantizer quantizer = new Quantizer(nArray, n, n2);
        return quantizer.toImage();
    }

    private static BufferedImage reduceColorsQuantize(BufferedImage bufferedImage, Params params) {
        int n;
        int n2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int[][] nArray = new int[n3][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                int n5 = bufferedImage.getRGB(n2, i);
                nArray[n2][i] = n5 >>> 24 > 127 ? n5 : nArray[0][0];
            }
        }
        n2 = params.isTransparent() ? 1 : 0;
        int[] nArray2 = ShrinkPalette.quantizeImage(nArray, n2 != 0 ? 255 : 256);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[265];
        byte[] byArray3 = new byte[256];
        for (n = 0; n < nArray2.length; ++n) {
            int n6 = nArray2[n];
            byArray[n] = (byte)((n6 & 0xFF0000) >> 16);
            byArray2[n] = (byte)((n6 & 0xFF00) >> 8);
            byArray3[n] = (byte)(n6 & 0xFF);
        }
        n = n2 != 0 ? 255 : -1;
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3, n);
        BufferedImage bufferedImage2 = new BufferedImage(indexColorModel, indexColorModel.createCompatibleWritableRaster(n3, n4), false, null);
        WritableRaster writableRaster = bufferedImage2.getRaster();
        int[] nArray3 = new int[1];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n7 = bufferedImage.getRGB(i, j);
                n7 = n7 >>> 24 > 127 ? nArray[i][j] : n;
                nArray3[0] = n7;
                writableRaster.setPixel(i, j, nArray3);
            }
        }
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeImageToFile(BufferedImage bufferedImage, FileObject fileObject, Params params) throws IOException {
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            AnimationRasterizer.encodeImage(bufferedImage, outputStream, params);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    private static void encodeImage(BufferedImage bufferedImage, OutputStream outputStream, Params params) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(params.getImageType().getName());
        ImageWriter imageWriter = iterator.hasNext() ? iterator.next() : null;
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteProgressive()) {
            imageWriteParam.setProgressiveMode(params.isProgressive() ? 1 : 0);
        }
        if (imageWriteParam.canWriteCompressed()) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(params.getCompressionQuality());
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        imageOutputStream.close();
    }

    private static BufferedImage decodeImage(InputStream inputStream, Params params) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(params.getImageType().getName());
        ImageReader imageReader = iterator.hasNext() ? iterator.next() : null;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0);
        imageReader.dispose();
        imageInputStream.close();
        return bufferedImage;
    }

    private static String getActiveConfigurationName(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null || !(project instanceof J2MEProject)) {
            return "";
        }
        return AnimationRasterizer.getDefaultName((J2MEProject)project);
    }

    private static String getDefaultName(J2MEProject j2MEProject) {
        AntProjectHelper antProjectHelper = (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper projectConfigurationsHelper = j2MEProject.getConfigurationHelper();
        return projectConfigurationsHelper.getActiveConfiguration() != projectConfigurationsHelper.getDefaultConfiguration() ? "_" + projectConfigurationsHelper.getActiveConfiguration().getDisplayName() : "";
    }

    static interface ProgressUpdater {
        public void updateProgress(String var1);
    }

    public static class PreviewInfo {
        final BufferedImage m_image;
        final String m_imageFormat;
        final int m_imageSize;

        private PreviewInfo(BufferedImage bufferedImage, String string, int n) {
            this.m_image = bufferedImage;
            this.m_imageFormat = string;
            this.m_imageSize = n;
        }
    }

    public static interface Params {
        public SVGImage getSVGImage() throws IOException, BadLocationException;

        public int getImageWidth();

        public int getImageHeight();

        public float getStartTime();

        public float getEndTime();

        public float getFramesPerSecond();

        public boolean isForAllConfigurations();

        public double getRatio();

        public float getCompressionQuality();

        public boolean isProgressive();

        public boolean isInSingleImage();

        public boolean isTransparent();

        public ImageType getImageType();

        public void setImageWidth(int var1);

        public void setImageHeight(int var1);

        public int getNumberFrames();

        public J2MEProject getProject();

        public String getElementId();

        public ColorReductionMethod getColorReductionMethod();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        JPEG("JPG", "JPEG", true, false, false, ".jpg"),
        PNG8("PNG", "PNG-8", false, true, true, ".png"),
        PNG24("PNG", "PNG-24", false, true, false, ".png");

        private final String m_name;
        private final String m_displayName;
        private final boolean m_supportsCompression;
        private final boolean m_supportsTransparency;
        private final String m_extension;
        private final boolean m_colorReduction;

        private ImageType(String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4) {
            this.m_name = string2;
            this.m_displayName = string3;
            this.m_supportsCompression = bl;
            this.m_supportsTransparency = bl2;
            this.m_colorReduction = bl3;
            this.m_extension = string4;
        }

        public boolean supportsCompression() {
            return this.m_supportsCompression;
        }

        public boolean supportsTransparency() {
            return this.m_supportsTransparency;
        }

        public boolean needsColorReduction() {
            return this.m_colorReduction;
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.m_displayName;
        }

        public String getFileName(String string) {
            String string2;
            String string3 = string.toLowerCase();
            if (!string3.endsWith(string2 = ".svg") && !string3.endsWith(string2 = ".svgz")) {
                string2 = "";
            }
            string = string.substring(0, string.length() - string2.length()) + this.m_extension;
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorReductionMethod implements ColorReducer
    {
        QUANTIZE(AnimationRasterizer.getMessage("LBL_ColorReductionColorQuantization")){

            public BufferedImage reduceColors(BufferedImage bufferedImage, Params params) {
                return AnimationRasterizer.reduceColorsQuantize(bufferedImage, params);
            }
        }
        ,
        MEDIAN_CUT(AnimationRasterizer.getMessage("LBL_ColorReductionMedianCut")){

            public BufferedImage reduceColors(BufferedImage bufferedImage, Params params) {
                return AnimationRasterizer.reduceColorsMedianCut(bufferedImage, params);
            }
        };

        private final String m_displayName;

        private ColorReductionMethod(String string2) {
            this.m_displayName = string2;
        }

        public String toString() {
            return this.m_displayName;
        }
    }

    private static interface ColorReducer {
        public BufferedImage reduceColors(BufferedImage var1, Params var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CompressionLevel
    extends Enum<CompressionLevel> {
        public static final /* enum */ CompressionLevel MAXIMUM = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionMaximum"), 10);
        public static final /* enum */ CompressionLevel VERY_HIGH = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionVeryHigh"), 30);
        public static final /* enum */ CompressionLevel HIGH = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionHigh"), 40);
        public static final /* enum */ CompressionLevel MEDIUM = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionMedium"), 60);
        public static final /* enum */ CompressionLevel LOW = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionLow"), 80);
        public static final /* enum */ CompressionLevel MINIMUM = new CompressionLevel(AnimationRasterizer.getMessage("LBL_CompressionMinimum"), 99);
        private final String m_name;
        private final int m_rate;
        private static final /* synthetic */ CompressionLevel[] $VALUES;

        public static final CompressionLevel[] values() {
            return (CompressionLevel[])$VALUES.clone();
        }

        public static CompressionLevel valueOf(String string) {
            return Enum.valueOf(CompressionLevel.class, string);
        }

        private CompressionLevel(String string2, int n2) {
            this.m_name = string2;
            this.m_rate = n2;
        }

        public String toString() {
            return this.m_name;
        }

        public int getRate() {
            return this.m_rate;
        }

        public static CompressionLevel getLevel(int n) {
            assert (n >= 0 && n <= 99);
            for (CompressionLevel compressionLevel : CompressionLevel.values()) {
                if (n > compressionLevel.getRate()) continue;
                return compressionLevel;
            }
            assert (false) : "Could not find compression level for rate: " + n;
            return MINIMUM;
        }

        static {
            $VALUES = new CompressionLevel[]{MAXIMUM, VERY_HIGH, HIGH, MEDIUM, LOW, MINIMUM};
        }
    }
}

