/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.m2g.SVGImage;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public final class MoveFocusActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor ACTIVATE_MOUSE_CURSOR = new ActionMouseCursor(12, 3);
    private static final Color FOCUS_OUTLINE_COLOR = Color.GREEN;
    private final AbstractSVGAction m_focusNext = new AbstractSVGAction("svg_focus_next", false){

        public void actionPerformed(ActionEvent actionEvent) {
            if (++MoveFocusActionFactory.this.m_focusedIdIndex > MoveFocusActionFactory.this.m_focusTargets.size() - 1) {
                MoveFocusActionFactory.this.m_focusedIdIndex = 0;
            }
            MoveFocusActionFactory.this.focusElement();
        }
    };
    private final transient AbstractSVGAction m_focusPrevious = new AbstractSVGAction("svg_focus_previous", false){

        public void actionPerformed(ActionEvent actionEvent) {
            if (--MoveFocusActionFactory.this.m_focusedIdIndex < 0) {
                MoveFocusActionFactory.this.m_focusedIdIndex = MoveFocusActionFactory.this.m_focusTargets.size() - 1;
            }
            assert (MoveFocusActionFactory.this.m_focusedIdIndex >= 0);
            MoveFocusActionFactory.this.focusElement();
        }
    };
    private final transient AbstractSVGAction m_activateFocused = new AbstractSVGAction("svg_activate_focused", false){

        public void actionPerformed(ActionEvent actionEvent) {
            SVGImage sVGImage = MoveFocusActionFactory.this.m_sceneMgr.getSVGImage();
            if (sVGImage != null) {
                sVGImage.activate();
            }
        }
    };
    private final List<String> m_focusTargets = new ArrayList<String>();
    private int m_focusedIdIndex = -1;
    private ShowFocusAction m_showFocusAction = null;

    public MoveFocusActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    private void focusElement() {
        if (this.m_showFocusAction != null) {
            this.m_showFocusAction.actionCompleted();
            this.m_showFocusAction = null;
        }
        SVGObject sVGObject = null;
        String string = this.m_focusTargets.get(this.m_focusedIdIndex);
        if (string != null) {
            sVGObject = this.getPerseusController().getObjectById(string);
            assert (sVGObject != null);
            this.m_showFocusAction = new ShowFocusAction(sVGObject);
            this.m_sceneMgr.startAction(this.m_showFocusAction);
        }
        this.m_sceneMgr.getSVGImage().focusOn((SVGElement)(sVGObject != null ? sVGObject.getSVGElement() : null));
        this.m_sceneMgr.getScreenManager().repaint();
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        int n;
        MouseEvent mouseEvent;
        if (aWTEvent.getID() == 2533) {
            ((PerseusController)aWTEvent.getSource()).getFocusableTargets(this.m_focusTargets);
            this.m_focusedIdIndex = 0;
            this.setActionseEnabled(true);
        } else if (aWTEvent.getID() == 2534) {
            this.m_focusTargets.clear();
            this.setActionseEnabled(false);
        } else if (aWTEvent.getID() == 500 && (mouseEvent = (MouseEvent)aWTEvent).getButton() == 1 && mouseEvent.getClickCount() == 1 && (n = this.getFocusTargetIdAt(mouseEvent, bl)) != -1) {
            this.m_focusedIdIndex = n;
            this.focusElement();
            this.m_activateFocused.actionPerformed(null);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        return mouseEvent.getID() == 503 && this.getFocusTargetIdAt(mouseEvent, bl) != -1 ? ACTIVATE_MOUSE_CURSOR : null;
    }

    private int getFocusTargetIdAt(MouseEvent mouseEvent, boolean bl) {
        String string;
        SVGLocatableElement sVGLocatableElement;
        if (!bl && this.m_sceneMgr.isReadOnly() && this.m_focusTargets.size() > 0 && (sVGLocatableElement = this.m_sceneMgr.getPerseusController().findElementAt(mouseEvent.getX(), mouseEvent.getY())) != null && (string = sVGLocatableElement.getId()) != null) {
            return this.m_focusTargets.indexOf(string);
        }
        return -1;
    }

    public Action[] getMenuActions() {
        return new Action[]{this.m_focusNext, this.m_focusPrevious, this.m_activateFocused};
    }

    private void setActionseEnabled(boolean bl) {
        this.m_activateFocused.setEnabled(bl);
        this.m_focusNext.setEnabled(bl);
        this.m_focusPrevious.setEnabled(bl);
    }

    private final class ShowFocusAction
    extends AbstractComposerAction {
        private final SVGObject m_focused;

        public ShowFocusAction(SVGObject sVGObject) {
            super(MoveFocusActionFactory.this);
            this.m_focused = sVGObject;
        }

        public void paint(Graphics graphics, int n, int n2, boolean bl) {
            if (bl && !this.m_isCompleted) {
                SVGObjectOutline sVGObjectOutline = this.m_focused.getOutline();
                sVGObjectOutline.draw(graphics, n, n2, FOCUS_OUTLINE_COLOR, false);
                sVGObjectOutline.setDirty();
            }
        }

        public void actionCompleted() {
            this.m_focused.repaint(5);
            super.actionCompleted();
        }
    }
}

