/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.ActionWrapper;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.filesystems.FileObject;
import org.openide.util.actions.SystemAction;

public final class ActionWrapperFactory {
    private static final String CLASS_EXT = ".class";
    final String m_actionId;
    final int m_toolBarPosition;

    public static ActionWrapperFactory create(FileObject fileObject) {
        return new ActionWrapperFactory(fileObject);
    }

    private ActionWrapperFactory(FileObject fileObject) {
        this.m_actionId = (String)fileObject.getAttribute("actionId");
        this.m_toolBarPosition = ActionWrapperFactory.getAttribute(fileObject, "toolBarPosition");
    }

    public ActionWrapper createWrapper(SceneManager sceneManager) {
        if (this.m_actionId != null) {
            Action action = null;
            if (this.m_actionId.endsWith(CLASS_EXT)) {
                String string = "";
                try {
                    string = this.m_actionId.substring(0, this.m_actionId.length() - CLASS_EXT.length());
                    Class<?> clazz = Class.forName(string);
                    action = SystemAction.get(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    SceneManager.log(Level.SEVERE, "Class " + string + " not found for actionID " + this.m_actionId, classNotFoundException);
                }
            } else {
                action = sceneManager.getAction(this.m_actionId);
            }
            if (action != null) {
                return new ActionWrapper(action, this.m_toolBarPosition);
            }
        } else {
            return new ActionWrapper();
        }
        return null;
    }

    private static int getAttribute(FileObject fileObject, String string) {
        Integer n = (Integer)fileObject.getAttribute(string);
        return n != null ? n : -1;
    }
}

