/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.util.Collection;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.ui.basic.NameGenerator;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SchemaReferenceDecorator
extends AbstractReferenceDecorator {
    private AbstractReferenceCustomizer customizer;
    private int prefixCounter;

    public SchemaReferenceDecorator(AbstractReferenceCustomizer abstractReferenceCustomizer) {
        this.customizer = abstractReferenceCustomizer;
    }

    public String validate(ExternalReferenceNode externalReferenceNode) {
        String string;
        Object object;
        if (externalReferenceNode.hasModel()) {
            object = externalReferenceNode.getModel();
            if (object == null) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_SchemaReferenceDecorator_NoModel");
            }
            string = this.customizer.getComponentModel();
            if (object.equals(string)) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_SchemaReferenceDecorator_SameModel");
            }
            if (string instanceof SchemaModel) {
                SchemaModel schemaModel = (SchemaModel)string;
                Collection collection = schemaModel.getSchema().getSchemaReferences();
                for (SchemaModelReference schemaModelReference : collection) {
                    try {
                        SchemaModel schemaModel2 = schemaModelReference.resolveReferencedModel();
                        if (!object.equals(schemaModel2)) continue;
                        return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_SchemaReferenceDecorator_AlreadyRefd");
                    }
                    catch (CatalogModelException catalogModelException) {
                    }
                }
            }
        }
        object = externalReferenceNode.getNamespace();
        string = this.customizer.getTargetNamespace();
        if (this.customizer.mustNamespaceDiffer()) {
            if (object != null && !"NO_NAME_SPACE".equals(object) && string != null && string.equals(object)) {
                return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_SchemaReferenceDecorator_SameNamespace");
            }
        } else if (object != null && !"NO_NAME_SPACE".equals(object) && string != null && !string.equals(object)) {
            return NbBundle.getMessage(SchemaReferenceDecorator.class, (String)"LBL_SchemaReferenceDecorator_DifferentNamespace");
        }
        return null;
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node node) {
        return this.customizer.createExternalReferenceNode(node);
    }

    protected String generatePrefix(Model model) {
        Model model2 = this.customizer.getComponentModel();
        if (model2 instanceof SchemaModel) {
            return NameGenerator.getInstance().generateNamespacePrefix(null, (SchemaModel)model2, this.prefixCounter++);
        }
        return "";
    }

    public Utilities.DocumentTypesEnum getDocumentType() {
        return Utilities.DocumentTypesEnum.schema;
    }

    public String getHtmlDisplayName(String string, ExternalReferenceNode externalReferenceNode) {
        if (this.validate(externalReferenceNode) != null) {
            return "<s>" + string + "</s>";
        }
        return string;
    }

    public String getNamespace(Model model) {
        SchemaModel schemaModel;
        Schema schema;
        if (model instanceof SchemaModel && (schema = (schemaModel = (SchemaModel)model).getSchema()) != null) {
            return schema.getTargetNamespace();
        }
        return null;
    }
}

