/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized;

import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.schema.model.Annotation;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Notation;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.ui.nodes.FilteredSchemaComponentNodeChildren;
import org.netbeans.modules.xml.schema.ui.nodes.ReadOnlyCookie;
import org.netbeans.modules.xml.schema.ui.nodes.RefreshableChildren;
import org.netbeans.modules.xml.schema.ui.nodes.SchemaUIContext;
import org.netbeans.modules.xml.schema.ui.nodes.StructuralSchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedChildrenExtension;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategoryNode;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.PrimitiveSimpleType;
import org.netbeans.modules.xml.xam.Named;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorizedChildren<C extends SchemaComponent>
extends RefreshableChildren {
    private SchemaUIContext context;
    private SchemaUIContext structuralContext;
    private SchemaComponentReference<C> reference;
    private List<Class<? extends SchemaComponent>> childFilters;
    private CategorizedChildrenExtension extension;
    private static final Map<Class<? extends SchemaComponent>, String> CATEGORIZED_TYPES = new LinkedHashMap<Class<? extends SchemaComponent>, String>();
    public static final List<Class<? extends SchemaComponent>> UNCATEGORIZED_TYPES;

    public CategorizedChildren(SchemaUIContext schemaUIContext, SchemaComponentReference<C> schemaComponentReference) {
        this(schemaUIContext, schemaComponentReference, null);
    }

    public CategorizedChildren(SchemaUIContext schemaUIContext, SchemaComponentReference<C> schemaComponentReference, List<Class<? extends SchemaComponent>> list) {
        this.context = schemaUIContext;
        this.reference = schemaComponentReference;
        this.childFilters = list;
        this.extension = new CategorizedChildrenExtension();
        SchemaModel schemaModel = schemaComponentReference.get().getModel();
        this.structuralContext = new SchemaUIContext(schemaModel, new StructuralSchemaNodeFactory(schemaModel, schemaUIContext.getLookup()), schemaUIContext.getLookup());
    }

    public SchemaUIContext getContext() {
        return this.context;
    }

    protected SchemaUIContext getStructuralContext() {
        return this.structuralContext;
    }

    public SchemaComponentReference<C> getReference() {
        return this.reference;
    }

    public List<Class<? extends SchemaComponent>> getChildFilters() {
        return this.childFilters;
    }

    protected void addNotify() {
        super.addNotify();
        this.refreshChildren();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.nodes.clear();
        this.refresh();
    }

    @Override
    public void refreshChildren() {
        this.setKeys(this.createKeys());
    }

    private boolean isChildAllowed(Class<? extends SchemaComponent> clazz) {
        if (this.getChildFilters() == null) {
            return true;
        }
        for (Class<SchemaComponent> clazz2 : this.getChildFilters()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected List<Node> createKeys() {
        boolean bl;
        SchemaComponent schemaComponent = this.getReference().get();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ReadOnlyCookie readOnlyCookie = (ReadOnlyCookie)this.getContext().getLookup().lookup(ReadOnlyCookie.class);
        boolean bl2 = bl = readOnlyCookie != null && readOnlyCookie.isReadOnly();
        if (!bl && this.getChildFilters() != null && this.isChildAllowed(PrimitiveSimpleType.class)) {
            arrayList.addAll(this.extension.getExtension(schemaComponent, this.getContext()));
        }
        if (schemaComponent instanceof Schema) {
            Object object;
            for (SchemaComponent object2 : schemaComponent.getChildren(UNCATEGORIZED_TYPES)) {
                if (!this.isChildAllowed(object2.getComponentType())) continue;
                object = this.getContext().getFactory().createNode(object2);
                arrayList.add((Node)object);
            }
            for (Class clazz : CATEGORIZED_TYPES.keySet()) {
                if (!this.isChildAllowed(clazz) || bl && schemaComponent.getChildren(clazz).isEmpty()) continue;
                object = new CategoryNode(this.getContext(), this.getReference(), clazz, new FilteredSchemaComponentNodeChildren<C>(this.getContext(), this.getReference(), clazz, new SchemaComponentComparator()));
                String string = CATEGORIZED_TYPES.get(clazz);
                ((CategoryNode)((Object)object)).setBadge(string);
                arrayList.add((Node)object);
            }
        } else {
            for (SchemaComponent schemaComponent2 : schemaComponent.getChildren()) {
                if (!this.isChildAllowed(schemaComponent2.getComponentType())) continue;
                Node node = this.getContext().getFactory().createNode(schemaComponent2);
                arrayList.add(node);
            }
        }
        return arrayList;
    }

    protected Node[] createNodes(Object object) {
        Node[] nodeArray = null;
        if (object instanceof Node) {
            nodeArray = new Node[]{(Node)object};
        }
        return nodeArray;
    }

    private static Node getFolderNode() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        Node node = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            node = dataObject.getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return node;
    }

    public static Image getBadgedFolderIcon(int n, Class<? extends SchemaComponent> clazz) {
        String string;
        Node node = CategorizedChildren.getFolderNode();
        Image image = null;
        if (node != null) {
            image = node.getIcon(n);
        }
        if ((string = CATEGORIZED_TYPES.get(clazz)) != null) {
            return CategorizedChildren.badgeImage(image, string);
        }
        return null;
    }

    public static Image getOpenedBadgedFolderIcon(int n, Class<? extends SchemaComponent> clazz) {
        String string;
        Node node = CategorizedChildren.getFolderNode();
        Image image = null;
        if (node != null) {
            image = node.getOpenedIcon(n);
        }
        if ((string = CATEGORIZED_TYPES.get(clazz)) != null) {
            return CategorizedChildren.badgeImage(image, string);
        }
        return null;
    }

    private static Image badgeImage(Image image, String string) {
        Image image2 = image;
        if (string != null) {
            Image image3 = Utilities.loadImage((String)string);
            image2 = Utilities.mergeImages((Image)image, (Image)image3, (int)8, (int)8);
        }
        return image2;
    }

    static {
        CATEGORIZED_TYPES.put(GlobalAttribute.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/attribute_badge.png");
        CATEGORIZED_TYPES.put(GlobalAttributeGroup.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/attribute_badge.png");
        CATEGORIZED_TYPES.put(GlobalComplexType.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/complexType_badge.png");
        CATEGORIZED_TYPES.put(GlobalElement.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/element_badge.png");
        CATEGORIZED_TYPES.put(GlobalGroup.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/group_badge.png");
        CATEGORIZED_TYPES.put(SchemaModelReference.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/referencedSchemas_badge.png");
        CATEGORIZED_TYPES.put(GlobalSimpleType.class, "org/netbeans/modules/xml/schema/ui/nodes/resources/simpleType_badge.png");
        UNCATEGORIZED_TYPES = new ArrayList<Class<? extends SchemaComponent>>(2);
        UNCATEGORIZED_TYPES.add(Annotation.class);
        UNCATEGORIZED_TYPES.add(Notation.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaComponentComparator
    implements Comparator<SchemaComponent>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SchemaComponentComparator() {
        }

        @Override
        public int compare(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
            boolean bl = schemaComponent instanceof Named;
            boolean bl2 = schemaComponent2 instanceof Named;
            if (bl && bl2) {
                String string = ((Named)schemaComponent).getName();
                String string2 = ((Named)schemaComponent2).getName();
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                if (string != null) {
                    return -1;
                }
                return 1;
            }
            if (bl) {
                return -1;
            }
            return 1;
        }
    }
}

