/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicBorders;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.ui.basic.UIUtilities;
import org.netbeans.modules.xml.schema.ui.nodes.SchemaComponentNode;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.PrimitiveSimpleType;
import org.netbeans.modules.xml.schema.ui.nodes.schema.SchemaNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaComponentSelectionPanel<T extends ReferenceableSchemaComponent>
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    static final long serialVersionUID = 1L;
    public static final String PROPERTY_SELECTION = "selectionChanged";
    private Class<T> type;
    private transient SchemaModel model;
    private transient T currentSelection;
    private Collection<? extends SchemaComponent> exclude;
    private BeanTreeView typeView;
    private boolean includePrimitives;
    public JPanel cvPanel;
    private JTextPane descriptionPane;
    private JScrollPane jScrollPane1;
    private JLabel selectedLbl;
    public JPanel typeSelectionPanel;

    public SchemaComponentSelectionPanel(SchemaModel schemaModel, Class<T> clazz, T t, Collection<? extends SchemaComponent> collection, boolean bl) {
        this.type = clazz;
        this.exclude = collection == null ? Collections.emptyList() : collection;
        this.includePrimitives = bl;
        this.initComponents();
        this.model = schemaModel;
        this.initialize(t);
    }

    private void initComponents() {
        this.typeSelectionPanel = new EmbededPanel(this);
        this.cvPanel = new JPanel();
        this.selectedLbl = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionPane = new JTextPane();
        this.cvPanel.setLayout(new BorderLayout());
        this.selectedLbl.setLabelFor(this.descriptionPane);
        Mnemonics.setLocalizedText((JLabel)this.selectedLbl, (String)NbBundle.getMessage(SchemaComponentSelectionPanel.class, (String)"LBL_Currently_Selected", (Object[])new Object[]{"", ""}));
        this.selectedLbl.setToolTipText(NbBundle.getMessage(SchemaComponentSelectionPanel.class, (String)"HINT_Currently_Selected"));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setMinimumSize(new Dimension(20, 28));
        this.descriptionPane.setBorder(null);
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setBackground(this.getBackground());
        this.jScrollPane1.setViewportView(this.descriptionPane);
        GroupLayout groupLayout = new GroupLayout((Container)this.typeSelectionPanel);
        this.typeSelectionPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.selectedLbl).addContainerGap()).add((Component)this.jScrollPane1, -1, 340, Short.MAX_VALUE).add((Component)this.cvPanel, -1, 340, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cvPanel, -1, 250, Short.MAX_VALUE).add(6, 6, 6).add((Component)this.selectedLbl).add(0, 0, 0).add((Component)this.jScrollPane1, -1, 108, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.typeSelectionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.typeSelectionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initialize(T t) {
        ArrayList<Class<? extends SchemaComponent>> arrayList = new ArrayList<Class<? extends SchemaComponent>>();
        arrayList.add(SchemaModelReference.class);
        arrayList.add(this.type);
        if (this.includePrimitives && !this.type.isAssignableFrom(PrimitiveSimpleType.class)) {
            arrayList.add(PrimitiveSimpleType.class);
        }
        CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(this.model, arrayList, Lookup.EMPTY);
        SchemaNode schemaNode = categorizedSchemaNodeFactory.createRootNode();
        this.typeView = new BeanTreeView();
        this.typeView.setBorder(BasicBorders.getTextFieldBorder());
        this.typeView.setPopupAllowed(false);
        this.typeView.setDefaultActionAllowed(false);
        this.typeView.setSelectionMode(1);
        this.typeView.setRootVisible(false);
        this.typeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaComponentSelectionPanel.class, (String)"LBL_GlobalReferenceTree"));
        this.typeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaComponentSelectionPanel.class, (String)"LBL_GlobalReferenceTree"));
        this.cvPanel.add((Component)this.typeView, "Center");
        this.getExplorerManager().setRootContext((Node)schemaNode);
        if (t != null) {
            EventQueue.invokeLater(new Runnable((ReferenceableSchemaComponent)t){
                final /* synthetic */ ReferenceableSchemaComponent val$initialSelection;
                {
                    this.val$initialSelection = referenceableSchemaComponent;
                }

                public void run() {
                    SchemaComponentSelectionPanel.this.setInitialSelection(this.val$initialSelection);
                }
            });
        }
    }

    public void setInitialSelection(T t) {
        Node node;
        this.currentSelection = t;
        if (this.currentSelection != null && (node = UIUtilities.findNode(this.getExplorerManager().getRootContext(), this.currentSelection, this.model)) != null) {
            this.setDescription(node);
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            if (nodeArray.length > 0) {
                SchemaComponentNode<T> schemaComponentNode = this.findReferenceableNode(nodeArray[0]);
                this.setCurrentSelection(schemaComponentNode == null ? null : (ReferenceableSchemaComponent)schemaComponentNode.getReference().get());
                this.setDescription((Node)schemaComponentNode);
                return;
            }
            this.setCurrentSelection(null);
        }
    }

    private void setCurrentSelection(T t) {
        T t2 = this.currentSelection;
        this.currentSelection = t == null || this.exclude.contains(t) ? null : t;
        this.firePropertyChange(PROPERTY_SELECTION, t2, this.currentSelection);
    }

    public T getCurrentSelection() {
        return this.currentSelection;
    }

    public ExplorerManager getExplorerManager() {
        return ((EmbededPanel)this.getTypeSelectionPanel()).getExplorerManager();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.typeView.setEnabled(bl);
        this.selectedLbl.setEnabled(bl);
        this.descriptionPane.setEnabled(bl);
    }

    public JPanel getTypeSelectionPanel() {
        return this.typeSelectionPanel;
    }

    private SchemaComponentNode<T> findReferenceableNode(Node node) {
        SchemaComponentNode schemaComponentNode = null;
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            schemaComponentNode = (SchemaComponentNode)node2.getCookie(SchemaComponentNode.class);
            if (schemaComponentNode == null || !this.type.isInstance(schemaComponentNode.getReference().get())) continue;
            return schemaComponentNode;
        }
        return null;
    }

    private void setDescription(Node node) {
        String string = "";
        String string2 = "";
        if (this.currentSelection != null) {
            string = this.currentSelection.getName();
            SchemaComponentNode schemaComponentNode = (SchemaComponentNode)node.getCookie(SchemaComponentNode.class);
            string2 = schemaComponentNode == null ? "" : "(" + schemaComponentNode.getTypeDisplayName() + ")";
        }
        this.selectedLbl.setText(NbBundle.getMessage(SchemaComponentSelectionPanel.class, (String)"LBL_Currently_Selected", (Object[])new Object[]{string, string2}));
        if (node != null && node.getShortDescription() != null) {
            this.descriptionPane.setText(node.getShortDescription());
        } else {
            this.descriptionPane.setText("");
        }
        this.descriptionPane.setCaretPosition(0);
    }

    private static class EmbededPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private static final long serialVersionUID = 1L;
        private ExplorerManager explorerManager;
        private PropertyChangeListener listener;

        public EmbededPanel(PropertyChangeListener propertyChangeListener) {
            this.listener = propertyChangeListener;
            this.explorerManager = new ExplorerManager();
        }

        public ExplorerManager getExplorerManager() {
            return this.explorerManager;
        }

        public void removeNotify() {
            super.removeNotify();
            this.getExplorerManager().removePropertyChangeListener(this.listener);
        }

        public void addNotify() {
            super.addNotify();
            this.getExplorerManager().addPropertyChangeListener(this.listener);
        }
    }
}

