/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Derivation;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.ui.basic.editors.DerivationTypeForm;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivationTypeEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private String property;
    private String typeDisplayName;
    private HashMap<Derivation.Type, ? extends Derivation> typeToDerivationMap = null;

    public DerivationTypeEditor(SchemaComponent schemaComponent, String string, String string2) {
        this.property = string;
        this.typeDisplayName = string2;
        this.initialize(schemaComponent);
    }

    private void initialize(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof Element) {
            if (schemaComponent instanceof GlobalElement && "final".equals(this.property)) {
                HashMap<Derivation.Type, GlobalElement.Final> hashMap = new HashMap<Derivation.Type, GlobalElement.Final>();
                hashMap.put(Derivation.Type.EMPTY, GlobalElement.Final.EMPTY);
                hashMap.put(Derivation.Type.ALL, GlobalElement.Final.ALL);
                hashMap.put(Derivation.Type.EXTENSION, GlobalElement.Final.EXTENSION);
                hashMap.put(Derivation.Type.RESTRICTION, GlobalElement.Final.RESTRICTION);
                this.typeToDerivationMap = hashMap;
            } else if ("block".equals(this.property)) {
                HashMap<Derivation.Type, Element.Block> hashMap = new HashMap<Derivation.Type, Element.Block>();
                hashMap.put(Derivation.Type.EMPTY, Element.Block.EMPTY);
                hashMap.put(Derivation.Type.ALL, Element.Block.ALL);
                hashMap.put(Derivation.Type.EXTENSION, Element.Block.EXTENSION);
                hashMap.put(Derivation.Type.RESTRICTION, Element.Block.RESTRICTION);
                hashMap.put(Derivation.Type.SUBSTITUTION, Element.Block.SUBSTITUTION);
                this.typeToDerivationMap = hashMap;
            }
        } else if (schemaComponent instanceof GlobalComplexType) {
            if ("final".equals(this.property)) {
                HashMap<Derivation.Type, GlobalComplexType.Final> hashMap = new HashMap<Derivation.Type, GlobalComplexType.Final>();
                hashMap.put(Derivation.Type.EMPTY, GlobalComplexType.Final.EMPTY);
                hashMap.put(Derivation.Type.ALL, GlobalComplexType.Final.ALL);
                hashMap.put(Derivation.Type.EXTENSION, GlobalComplexType.Final.EXTENSION);
                hashMap.put(Derivation.Type.RESTRICTION, GlobalComplexType.Final.RESTRICTION);
                this.typeToDerivationMap = hashMap;
            } else if ("block".equals(this.property)) {
                HashMap<Derivation.Type, GlobalComplexType.Block> hashMap = new HashMap<Derivation.Type, GlobalComplexType.Block>();
                hashMap.put(Derivation.Type.EMPTY, GlobalComplexType.Block.EMPTY);
                hashMap.put(Derivation.Type.ALL, GlobalComplexType.Block.ALL);
                hashMap.put(Derivation.Type.EXTENSION, GlobalComplexType.Block.EXTENSION);
                hashMap.put(Derivation.Type.RESTRICTION, GlobalComplexType.Block.RESTRICTION);
                this.typeToDerivationMap = hashMap;
            }
        } else if (schemaComponent instanceof GlobalSimpleType) {
            if ("final".equals(this.property)) {
                HashMap<Derivation.Type, GlobalSimpleType.Final> hashMap = new HashMap<Derivation.Type, GlobalSimpleType.Final>();
                hashMap.put(Derivation.Type.EMPTY, GlobalSimpleType.Final.EMPTY);
                hashMap.put(Derivation.Type.ALL, GlobalSimpleType.Final.ALL);
                hashMap.put(Derivation.Type.RESTRICTION, GlobalSimpleType.Final.RESTRICTION);
                hashMap.put(Derivation.Type.LIST, GlobalSimpleType.Final.LIST);
                hashMap.put(Derivation.Type.UNION, GlobalSimpleType.Final.UNION);
                this.typeToDerivationMap = hashMap;
            }
        } else if (schemaComponent instanceof Schema) {
            if ("finalDefault".equals(this.property)) {
                HashMap<Derivation.Type, Schema.Final> hashMap = new HashMap<Derivation.Type, Schema.Final>();
                hashMap.put(Derivation.Type.EMPTY, Schema.Final.EMPTY);
                hashMap.put(Derivation.Type.ALL, Schema.Final.ALL);
                hashMap.put(Derivation.Type.EXTENSION, Schema.Final.EXTENSION);
                hashMap.put(Derivation.Type.RESTRICTION, Schema.Final.RESTRICTION);
                hashMap.put(Derivation.Type.LIST, Schema.Final.LIST);
                hashMap.put(Derivation.Type.UNION, Schema.Final.UNION);
                this.typeToDerivationMap = hashMap;
            } else if ("blockDefault".equals(this.property)) {
                HashMap<Derivation.Type, Schema.Block> hashMap = new HashMap<Derivation.Type, Schema.Block>();
                hashMap.put(Derivation.Type.EMPTY, Schema.Block.EMPTY);
                hashMap.put(Derivation.Type.ALL, Schema.Block.ALL);
                hashMap.put(Derivation.Type.EXTENSION, Schema.Block.EXTENSION);
                hashMap.put(Derivation.Type.RESTRICTION, Schema.Block.RESTRICTION);
                this.typeToDerivationMap = hashMap;
            }
        }
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof Set) {
            return ((Set)object).toString();
        }
        return object.toString();
    }

    private Set<Derivation.Type> convertToDerivationType(Set<Derivation> set) {
        HashSet<Derivation.Type> hashSet = new HashSet<Derivation.Type>();
        if (set != null && !set.isEmpty()) {
            Set<Derivation.Type> set2 = this.typeToDerivationMap.keySet();
            int n = 0;
            for (Derivation.Type type : set2) {
                if (!set.contains(this.typeToDerivationMap.get(type))) continue;
                hashSet.add(type);
                if (++n != set.size()) continue;
                break;
            }
        }
        return hashSet;
    }

    private Set<? extends Derivation> convertToDerivation(Set<Derivation.Type> set) {
        HashSet<Derivation> hashSet = new HashSet<Derivation>();
        for (Derivation.Type type : set) {
            hashSet.add(this.typeToDerivationMap.get(type));
        }
        return hashSet;
    }

    @Override
    public Component getCustomEditor() {
        Object object = this.getValue();
        Set set = Collections.emptySet();
        if (object instanceof Set) {
            set = (Set)object;
        }
        final DerivationTypeForm derivationTypeForm = new DerivationTypeForm(this.property, this.convertToDerivationType(set), this.typeToDerivationMap.keySet());
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)derivationTypeForm, NbBundle.getMessage(DerivationTypeEditor.class, (String)"LBL_Derivation_Type_Editor_Title", (Object)this.typeDisplayName, (Object)NbBundle.getMessage(DerivationTypeEditor.class, (String)("LBL_" + this.property))), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        Set<Derivation.Type> set = derivationTypeForm.getCurrentSelection();
                        DerivationTypeEditor.this.setValue(set.isEmpty() ? null : DerivationTypeEditor.this.convertToDerivation(set));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), illegalArgumentException.getLocalizedMessage(), null, new Date());
                        throw illegalArgumentException;
                    }
                }
            }
        });
        derivationTypeForm.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("valid")) {
                    dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialog;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        featureDescriptor.setValue("canEditAsText", Boolean.FALSE);
    }
}

