/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.utils;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphLayout {
    private static final int GAP = 3;
    private static final int INDENT = 2;

    public static int getNextFreeX(Graph graph) {
        if (graph == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < graph.getVertexCount(); ++i) {
            Vertex vertex = graph.getVertex(i);
            int n2 = vertex.getX() + vertex.getWidth();
            if (n2 <= n) continue;
            n = n2;
        }
        n = n == 0 ? (n += 2) : (n += 3);
        return n;
    }

    public static void layout(Graph graph) {
        GraphLayout.layout(graph, -8, 8, 1);
    }

    public static void layout(Graph graph, int n, int n2, int n3) {
        Dimension dimension;
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        HashSet<Vertex> hashSet2 = new HashSet<Vertex>();
        for (int i = graph.getVertexCount() - 1; i >= 0; --i) {
            Vertex vertex = graph.getVertex(i);
            Link link = vertex.getOutgoingLink();
            if (link == null) {
                hashSet2.add(vertex);
                continue;
            }
            if (link.getTarget() != graph) continue;
            hashSet.add(vertex);
        }
        HashSet<Vertex> hashSet3 = new HashSet<Vertex>();
        int n4 = 0;
        int n5 = -1;
        for (Vertex vertex : hashSet) {
            dimension = GraphLayout.layout(vertex, n, n4, hashSet3, n2, n3);
            if (dimension == null) continue;
            n4 += dimension.height + n3;
            n5 = Math.max(n5, dimension.width);
        }
        if (n5 >= 0) {
            n -= n5 + n2;
        }
        n4 = 0;
        for (Vertex vertex : hashSet2) {
            dimension = GraphLayout.layout(vertex, n, n4, hashSet3, n2, n3);
            if (dimension == null) continue;
            n4 += dimension.height + n3;
        }
    }

    public static Dimension layout(Vertex vertex, int n, int n2, Set<Vertex> set, int n3, int n4) {
        int n5;
        if (set.contains(vertex)) {
            return null;
        }
        set.add(vertex);
        int n6 = vertex.getWidth();
        int n7 = vertex.getHeight();
        int n8 = n - n6 - n3;
        int n9 = n2;
        int n10 = vertex.getItemCount();
        int n11 = -1;
        for (n5 = 0; n5 < n10; ++n5) {
            Vertex vertex2;
            Dimension dimension;
            SourcePin sourcePin;
            VertexItem vertexItem = vertex.getItem(n5);
            Link link = vertexItem.getIngoingLink();
            if (link == null || !((sourcePin = link.getSource()) instanceof Vertex) || (dimension = GraphLayout.layout(vertex2 = (Vertex)sourcePin, n8, n9, set, n3, n4)) == null) continue;
            n9 += dimension.height + n4;
            n11 = Math.max(n11, dimension.width);
        }
        n11 = n11 < 0 ? n6 : (n11 += n3 + n6);
        n5 = n9 != n2 ? n9 - n4 - n2 : 0;
        int n12 = n - n6;
        int n13 = n2 + Math.max(0, (n5 - n7) / 2);
        n5 = Math.max(n5, n13 + n7 - n2);
        vertex.setLocation(n12, n13);
        return new Dimension(n11, n5);
    }
}

