/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.graphics.RRectangle;
import org.netbeans.modules.soa.mappercore.graphics.Triangle;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class Constant
extends Vertex {
    public Constant(Icon icon) {
        this(null, icon);
    }

    public Constant(Object object, Icon icon) {
        super(object, icon);
    }

    public RRectangle createShape(int n) {
        return new RRectangle(0.0, 0.0, this.getWidth() * n, this.getHeight() * n, n, 0.0, n, 0.0);
    }

    public void paint(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        boolean bl = canvasRendererContext.isSelected(treePath, this);
        int n2 = canvasRendererContext.getStep();
        int n3 = canvasRendererContext.getGraphX() + this.getX() * n2;
        int n4 = n + this.getY() * n2;
        int n5 = this.getWidth() * n2;
        int n6 = this.getHeight() * n2;
        double d = (double)n3 + 0.5;
        double d2 = (double)n4 + 0.5;
        Rectangle rectangle = new Rectangle(n5, n6);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.translate(d, d2);
        RRectangle rRectangle = new RRectangle(0.0, 0.0, n2 * 3, n6, n2, 0.0, n2, 0.0);
        graphics2D.setPaint(Color.WHITE);
        int n7 = n2 * 3;
        int n8 = n5 - n7;
        graphics2D.fillRect(n7, 0, n8, n6);
        graphics2D.setPaint(new TexturePaint(MapperStyle.GRADIENT_TEXTURE, rectangle));
        graphics2D.fill(rRectangle);
        Icon icon = this.getIcon();
        if (icon != null) {
            double d3 = (double)n2 - 0.5;
            double d4 = (double)Math.round(0.5 * (double)n6) - 0.5 - (double)(icon.getIconHeight() / 2) + 1.0;
            graphics2D.translate(d3, d4);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            icon.paintIcon(canvasRendererContext.getCanvas(), graphics2D, 0, 0);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.translate(-d3, -d4);
        }
        graphics2D.translate(-0.5, -0.5);
        graphics2D.setPaint(MapperStyle.VERTEX_BORDER_COLOR);
        graphics2D.translate(0.5, 0.5);
        for (int i = 2 * n2; i < n6; i += 2 * n2) {
            graphics2D.drawLine(n7, i, n7 + n8, i);
        }
        graphics2D.drawLine(n7, 0, n7, n6 - 1);
        rRectangle.setBounds(0.0, 0.0, n5, n6);
        if (bl) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(MapperStyle.SELECTION_STROKE);
            graphics2D.setPaint(MapperStyle.SELECTION_COLOR);
            graphics2D.draw(rRectangle);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.setPaint(MapperStyle.VERTEX_BORDER_COLOR);
            graphics2D.draw(rRectangle);
        }
        graphics2D.fill(new Triangle(n5 - n2, n6, n5, n6 - n2, n5, n6));
        graphics2D.translate(-d, -d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            VertexItem vertexItem = this.getItem(i);
            vertexItem.paint(graphics2D, treePath, canvasRendererContext, n);
        }
        this.paintSourcePin(graphics2D, treePath, canvasRendererContext, n);
    }

    public void layout() {
        int n = this.getWidth() - 3;
        int n2 = this.getItemCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            VertexItem vertexItem = this.getItem(i);
            int n4 = vertexItem.isHairline() ? 0 : 2;
            vertexItem.setBounds(3, n3, n, n4);
            n3 += n4;
        }
        this.setHeight(Math.max(n3, 2));
        super.layout();
    }

    public int getMaximumWidth() {
        return 30;
    }
}

