/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.icons;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.icons.Icon2D;
import org.netbeans.modules.soa.mappercore.model.Vertex;

public class StringIcon2D
implements Icon2D {
    private double radius;
    private Color color;
    private Shape shape;
    private static Shape SHAPE;

    public StringIcon2D(String string) {
        this(string, MapperStyle.ICON_COLOR, 0.8);
    }

    public StringIcon2D(String string, Color color, double d) {
        this.radius = d;
        this.color = color;
        Font font = new Font("SansSerif", 0, 20);
        Area area = new Area(font.createGlyphVector(new FontRenderContext(null, true, true), string).getOutline());
        Rectangle2D rectangle2D = area.getBounds2D();
        double d2 = 2.0 / Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.shape = new GeneralPath(area.createTransformedArea(AffineTransform.getTranslateInstance(-rectangle2D.getCenterX(), -rectangle2D.getCenterY())).createTransformedArea(AffineTransform.getScaleInstance(d2, d2)));
    }

    public void paintIcon(Vertex vertex, Graphics2D graphics2D, int n) {
        Paint paint = graphics2D.getPaint();
        double d = this.radius * (double)(n - 2);
        graphics2D.setPaint(this.color);
        graphics2D.scale(d, d);
        graphics2D.fill(this.shape);
        graphics2D.scale(1.0 / d, 1.0 / d);
        graphics2D.setPaint(paint);
    }
}

