/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.graphics;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RRectangle
implements Shape {
    private double x;
    private double y;
    private double width;
    private double height;
    private double radiusTopLeft;
    private double radiusTopRight;
    private double radiusBottomLeft;
    private double radiusBottomRight;

    public RRectangle(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.setBounds(d, d2, d3, d4);
        this.setRadiuses(d5, d6, d7, d8);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public void setRadiuses(double d, double d2, double d3, double d4) {
        this.radiusTopLeft = Math.max(0.0, d);
        this.radiusTopRight = Math.max(0.0, d2);
        this.radiusBottomLeft = Math.max(0.0, d3);
        this.radiusBottomRight = Math.max(0.0, d4);
    }

    public double getMaxRadius() {
        return Math.min(this.width, this.height) / 2.0;
    }

    public double getRadiusTopLeft() {
        return Math.min(this.getMaxRadius(), this.radiusTopLeft);
    }

    public double getRadiusTopRight() {
        return Math.min(this.getMaxRadius(), this.radiusTopRight);
    }

    public double getRadiusBottomLeft() {
        return Math.min(this.getMaxRadius(), this.radiusBottomLeft);
    }

    public double getRadiusBottomRight() {
        return Math.min(this.getMaxRadius(), this.radiusBottomRight);
    }

    public Rectangle getBounds() {
        int n = (int)Math.floor(this.x);
        int n2 = (int)Math.floor(this.y);
        return new Rectangle(n, n2, (int)Math.ceil(this.x + this.width) - n, (int)Math.ceil(this.y + this.height) - n2);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2) {
        d2 -= this.y;
        if ((d -= this.x) < 0.0 || d > this.width || d2 < 0.0 || d2 > this.height) {
            return false;
        }
        double d3 = this.getMaxRadius();
        double d4 = Math.min(d3, this.radiusTopLeft);
        double d5 = d - d4;
        double d6 = d2 - d4;
        if (d5 < 0.0 && d6 < 0.0) {
            return d5 * d5 + d6 * d6 < d4 * d4;
        }
        d4 = Math.min(d3, this.radiusTopRight);
        d5 = this.width - d - d4;
        d6 = d2 - d4;
        if (d5 < 0.0 && d6 < 0.0) {
            return d5 * d5 + d6 * d6 < d4 * d4;
        }
        d4 = Math.min(d3, this.radiusBottomLeft);
        d5 = d - d4;
        d6 = this.height - d2 - d4;
        if (d5 < 0.0 && d6 < 0.0) {
            return d5 * d5 + d6 * d6 < d4 * d4;
        }
        d4 = Math.min(d3, this.radiusBottomRight);
        d5 = this.width - d - d4;
        d6 = this.height - d2 - d4;
        if (d5 < 0.0 && d6 < 0.0) {
            return d5 * d5 + d6 * d6 < d4 * d4;
        }
        return true;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = d - this.x;
        double d6 = d2 - this.y;
        double d7 = d5 + d3;
        double d8 = d6 + d4;
        return !(d7 < 0.0 || d5 > this.width || d8 < 0.0 || d6 > this.height);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d + d3;
        double d6 = d2 + d4;
        return this.contains(d, d2) && this.contains(d5, d6) && this.contains(d5, d2) && this.contains(d, d6);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new RRectanglePathIterator(this.x, this.y, this.width, this.height, this.radiusTopLeft, this.radiusTopRight, this.radiusBottomLeft, this.radiusBottomRight, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    private static class RRectanglePathIterator
    implements PathIterator {
        double[] coords;
        int index = 0;
        static final double K1 = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
        static final double K2 = 1.0 - K1;

        RRectanglePathIterator(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, AffineTransform affineTransform) {
            double d9 = Math.min(d3, d4) / 2.0;
            d5 = Math.min(d9, d5);
            d6 = Math.min(d9, d6);
            d7 = Math.min(d9, d7);
            d8 = Math.min(d9, d8);
            double d10 = d5 * K2;
            double d11 = d6 * K2;
            double d12 = d7 * K2;
            double d13 = d8 * K2;
            double d14 = d + d3;
            double d15 = d2 + d4;
            this.coords = new double[]{d, d2 + d5, d, d2 + d10, d + d10, d2, d + d5, d2, d14 - d6, d2, d14 - d11, d2, d14, d2 + d11, d14, d2 + d6, d14, d15 - d8, d14, d15 - d13, d14 - d13, d15, d14 - d8, d15, d + d7, d15, d + d12, d15, d, d15 - d12, d, d15 - d7, d, d2 + d5};
            if (affineTransform != null) {
                affineTransform.transform(this.coords, 0, this.coords, 0, 17);
            }
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > 34;
        }

        public void next() {
            this.index = this.getNextIndex(this.index);
        }

        private int getNextIndex(int n) {
            if (n == 32) {
                return 34;
            }
            if (n == 0) {
                return 2;
            }
            if ((n & 7) == 0) {
                return n + 2;
            }
            return n + 6;
        }

        public int currentSegment(float[] fArray) {
            double[] dArray = this.coords;
            if (this.index >= 34) {
                return 4;
            }
            if (this.index == 0) {
                fArray[0] = (float)dArray[0];
                fArray[1] = (float)dArray[1];
                return 0;
            }
            if ((this.index & 7) == 0) {
                fArray[0] = (float)dArray[this.index];
                fArray[1] = (float)dArray[this.index + 1];
                return 1;
            }
            fArray[0] = (float)dArray[this.index];
            fArray[1] = (float)dArray[this.index + 1];
            fArray[2] = (float)dArray[this.index + 2];
            fArray[3] = (float)dArray[this.index + 3];
            fArray[4] = (float)dArray[this.index + 4];
            fArray[5] = (float)dArray[this.index + 5];
            return 3;
        }

        public int currentSegment(double[] dArray) {
            double[] dArray2 = this.coords;
            if (this.index >= 34) {
                return 4;
            }
            if (this.index == 0) {
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                return 0;
            }
            if ((this.index & 7) == 0) {
                dArray[0] = dArray2[this.index];
                dArray[1] = dArray2[this.index + 1];
                return 1;
            }
            dArray[0] = dArray2[this.index];
            dArray[1] = dArray2[this.index + 1];
            dArray[2] = dArray2[this.index + 2];
            dArray[3] = dArray2[this.index + 3];
            dArray[4] = dArray2[this.index + 4];
            dArray[5] = dArray2[this.index + 5];
            return 3;
        }
    }
}

