/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.j2seproject.ui.wizards.NewJ2SEProjectWizardIterator;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements ActionListener,
PropertyChangeListener {
    private static boolean lastMainClassCheck = true;
    public static final String SHARED_LIBRARIES = "sharedLibraries";
    private PanelConfigureProject panel;
    private boolean valid;
    private String currentLibrariesLocation;
    private String projectLocation;
    private JButton btnLibFolder;
    private JCheckBox cbSharable;
    private JCheckBox createMainCheckBox;
    private JLabel lblHint;
    private JLabel lblLibFolder;
    private JTextField mainClassTextField;
    private JCheckBox setAsMainCheckBox;
    private JTextField txtLibFolder;

    public PanelOptionsVisual(PanelConfigureProject panelConfigureProject, NewJ2SEProjectWizardIterator.WizardType wizardType) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.txtLibFolder.setText(this.currentLibrariesLocation);
        this.cbSharableActionPerformed(null);
        switch (wizardType) {
            case LIB: {
                this.setAsMainCheckBox.setVisible(false);
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                break;
            }
            case APP: {
                this.createMainCheckBox.addActionListener(this);
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                break;
            }
            case EXT: {
                this.setAsMainCheckBox.setVisible(true);
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
            }
        }
        this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.mainClassChanged();
            }
        });
        this.txtLibFolder.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.librariesLocationChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.librariesLocationChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.librariesLocationChanged();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.createMainCheckBox) {
            lastMainClassCheck = this.createMainCheckBox.isSelected();
            this.mainClassTextField.setEnabled(lastMainClassCheck);
            this.panel.fireChangeEvent();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("projectName".equals(propertyChangeEvent.getPropertyName())) {
            String string = NewJ2SEProjectWizardIterator.getPackageName((String)propertyChangeEvent.getNewValue());
            if (!Utilities.isJavaIdentifier((String)string)) {
                string = NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNameSuffix", (Object)string);
            }
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"), string));
        }
        if ("projectLocation".equals(propertyChangeEvent.getPropertyName())) {
            this.projectLocation = (String)propertyChangeEvent.getNewValue();
        }
    }

    private void initComponents() {
        this.cbSharable = new JCheckBox();
        this.lblLibFolder = new JLabel();
        this.txtLibFolder = new JTextField();
        this.btnLibFolder = new JButton();
        this.lblHint = new JLabel();
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.setAsMainCheckBox = new JCheckBox();
        this.cbSharable.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSharable, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_SharableProject_Checkbox"));
        this.cbSharable.setMargin(new Insets(0, 0, 0, 0));
        this.cbSharable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOptionsVisual.this.cbSharableActionPerformed(actionEvent);
            }
        });
        this.lblLibFolder.setLabelFor(this.txtLibFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Location_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Browse_Button"));
        this.btnLibFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOptionsVisual.this.btnLibFolderActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"HINT_LibrariesFolder"));
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.createMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.mainClassTextField.setText("com.myapp.Main");
        this.setAsMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_setAsMainCheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbSharable).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(19, 19, 19).add((Component)this.lblLibFolder).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblHint, -2, 243, Short.MAX_VALUE).add((Component)this.txtLibFolder, -1, 243, Short.MAX_VALUE)))).addPreferredGap(0).add((Component)this.btnLibFolder)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.setAsMainCheckBox).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.createMainCheckBox).addPreferredGap(0).add((Component)this.mainClassTextField, -1, 319, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbSharable).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnLibFolder).add((Component)this.txtLibFolder, -2, -1, -2).add((Component)this.lblLibFolder)).addPreferredGap(0).add((Component)this.lblHint).add(30, 30, 30).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createMainCheckBox).add((Component)this.mainClassTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.setAsMainCheckBox).addContainerGap(50, Short.MAX_VALUE)));
        this.cbSharable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_sharableProject"));
        this.txtLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_LibrariesLocation"));
        this.btnLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_browseLibraries"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_setAsMainCheckBox"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_setAsMainCheckBox"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void cbSharableActionPerformed(ActionEvent actionEvent) {
        this.txtLibFolder.setEnabled(this.cbSharable.isSelected());
        this.btnLibFolder.setEnabled(this.cbSharable.isSelected());
        this.lblHint.setEnabled(this.cbSharable.isSelected());
        this.lblLibFolder.setEnabled(this.cbSharable.isSelected());
        if (this.cbSharable.isSelected()) {
            this.txtLibFolder.setText(this.currentLibrariesLocation);
        } else {
            this.txtLibFolder.setText("");
        }
    }

    private void btnLibFolderActionPerformed(ActionEvent actionEvent) {
        File file = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String string = SharableLibrariesUtils.browseForLibraryLocation((String)this.txtLibFolder.getText().trim(), (Component)this, (File)file);
        if (string != null) {
            this.currentLibrariesLocation = string;
            if (this.cbSharable.isSelected()) {
                this.txtLibFolder.setText(this.currentLibrariesLocation);
            }
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.cbSharable.isSelected()) {
            String string = this.txtLibFolder.getText();
            if (this.projectLocation != null) {
                if (new File(string).isAbsolute()) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    File file;
                    File file2 = FileUtil.normalizeFile((File)new File(this.projectLocation));
                    if (!CollocationQuery.areCollocated((File)file2, (File)(file = PropertyUtils.resolveFile((File)file2, (String)string)))) {
                        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.valid) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.valid;
        }
        return true;
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() && this.setAsMainCheckBox.isVisible() ? Boolean.TRUE : Boolean.FALSE));
        wizardDescriptor.putProperty("mainClass", this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        wizardDescriptor.putProperty(SHARED_LIBRARIES, this.cbSharable.isSelected() ? this.txtLibFolder.getText() : null);
    }

    private void mainClassChanged() {
        String string = this.mainClassTextField.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() != 0 && Utilities.isJavaIdentifier((String)string2)) continue;
            bl = false;
            break;
        }
        this.valid = bl;
        this.panel.fireChangeEvent();
    }

    private void librariesLocationChanged() {
        this.panel.fireChangeEvent();
    }
}

