/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.java.j2seproject.ui.customizer.ClassPathUiSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class J2SEClassPathUi {
    private J2SEClassPathUi() {
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener {
        private final J2SEProject project;
        private final JList list;
        private final DefaultListModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addJar;
        private final ButtonModel addLibrary;
        private final ButtonModel addAntArtifact;
        private final ButtonModel remove;
        private final ButtonModel moveUp;
        private final ButtonModel moveDown;
        private final ButtonModel edit;
        private Document libraryPath;

        private EditMediator(J2SEProject j2SEProject, JList jList, DefaultListModel defaultListModel, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, ButtonModel buttonModel5, ButtonModel buttonModel6, ButtonModel buttonModel7, Document document) {
            this.list = jList;
            if (!(jList.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (DefaultListModel)jList.getModel();
            this.selectionModel = jList.getSelectionModel();
            this.addJar = buttonModel;
            this.addLibrary = buttonModel2;
            this.addAntArtifact = buttonModel3;
            this.remove = buttonModel4;
            this.moveUp = buttonModel5;
            this.moveDown = buttonModel6;
            this.edit = buttonModel7;
            this.project = j2SEProject;
            this.libraryPath = document;
        }

        public static void register(J2SEProject j2SEProject, JList jList, DefaultListModel defaultListModel, ButtonModel buttonModel, ButtonModel buttonModel2, ButtonModel buttonModel3, ButtonModel buttonModel4, ButtonModel buttonModel5, ButtonModel buttonModel6, ButtonModel buttonModel7, Document document) {
            EditMediator editMediator = new EditMediator(j2SEProject, jList, defaultListModel, buttonModel, buttonModel2, buttonModel3, buttonModel4, buttonModel5, buttonModel6, buttonModel7, document);
            buttonModel.addActionListener(editMediator);
            buttonModel2.addActionListener(editMediator);
            buttonModel3.addActionListener(editMediator);
            buttonModel4.addActionListener(editMediator);
            buttonModel5.addActionListener(editMediator);
            buttonModel6.addActionListener(editMediator);
            buttonModel7.addActionListener(editMediator);
            editMediator.selectionModel.addListSelectionListener(editMediator);
            editMediator.valueChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.addJar) {
                FileChooser fileChooser = this.project.getAntProjectHelper().isSharableProject() ? new FileChooser(this.project.getAntProjectHelper(), true) : new FileChooser(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), null);
                fileChooser.enableVariableBasedSelection(true);
                fileChooser.setFileHidingEnabled(false);
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
                fileChooser.setFileSelectionMode(2);
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setDialogTitle(NbBundle.getMessage(J2SEClassPathUi.class, (String)"LBL_AddJar_DialogTitle"));
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setFileFilter((FileFilter)new SimpleFileFilter(NbBundle.getMessage(J2SEClassPathUi.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"}));
                File file = FoldersListSettings.getDefault().getLastUsedClassPathFolder();
                fileChooser.setCurrentDirectory(file);
                int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this.list));
                if (n == 0) {
                    String[] stringArray;
                    try {
                        stringArray = fileChooser.getSelectedPaths();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                        return;
                    }
                    int[] nArray = ClassPathUiSupport.addJarFiles(this.listModel, this.list.getSelectedIndices(), stringArray, fileChooser.getSelectedPathVariables());
                    this.list.setSelectedIndices(nArray);
                    file = FileUtil.normalizeFile((File)fileChooser.getCurrentDirectory());
                    FoldersListSettings.getDefault().setLastUsedClassPathFolder(file);
                }
            } else if (object == this.addLibrary) {
                Serializable serializable;
                Object object2;
                LibraryManager libraryManager = null;
                boolean bl = false;
                try {
                    object2 = this.libraryPath.getText(0, this.libraryPath.getLength());
                    if (object2 != null && ((String)object2).length() > 0) {
                        serializable = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)object2);
                        URL uRL = FileUtil.normalizeFile((File)serializable).toURI().toURL();
                        libraryManager = LibraryManager.forLocation((URL)uRL);
                    } else {
                        bl = true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    bl = true;
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
                if (libraryManager == null && bl) {
                    libraryManager = LibraryManager.getDefault();
                }
                if (libraryManager == null) {
                    return;
                }
                object2 = LibraryChooser.showDialog((LibraryManager)libraryManager, (LibraryChooser.Filter)new LibraryChooser.Filter(){

                    public boolean accept(Library library) {
                        return "j2se".equals(library.getType());
                    }
                }, (LibraryChooser.LibraryImportHandler)this.project.getReferenceHelper().getLibraryChooserImportHandler());
                if (object2 != null) {
                    serializable = new HashSet();
                    for (int i = 0; i < this.listModel.getSize(); ++i) {
                        String string;
                        String string2;
                        ClassPathSupport.Item item = (ClassPathSupport.Item)this.listModel.get(i);
                        if (item.getType() != 1) continue;
                        if (item.isBroken()) {
                            string2 = item.getReference();
                            string = ClassPathSupport.getLibraryNameFromReference(string2);
                            assert (string != null) : "Not a library reference: " + string2;
                            Library library = libraryManager.getLibrary(string);
                            if (library != null) {
                                this.listModel.remove(i);
                                item = ClassPathSupport.Item.create(library, string2);
                                this.listModel.add(i, item);
                            }
                        } else {
                            string2 = item.getLibrary();
                            string = libraryManager.getLibrary(string2.getName());
                            if (string == null) {
                                this.listModel.remove(i);
                                item = ClassPathSupport.Item.createBroken(1, item.getReference());
                                this.listModel.add(i, item);
                            }
                        }
                        if (item.isBroken()) continue;
                        serializable.add(item.getLibrary());
                    }
                    int[] nArray = ClassPathUiSupport.addLibraries(this.listModel, this.list.getSelectedIndices(), object2.toArray(new Library[object2.size()]), (Set)((Object)serializable));
                    this.list.setSelectedIndices(nArray);
                }
            } else if (object == this.addAntArtifact) {
                AntArtifactChooser.ArtifactItem[] artifactItemArray = AntArtifactChooser.showDialog(new String[]{"jar", "folder"}, this.project, this.list.getParent());
                if (artifactItemArray != null) {
                    int[] nArray = ClassPathUiSupport.addArtifacts(this.listModel, this.list.getSelectedIndices(), artifactItemArray);
                    this.list.setSelectedIndices(nArray);
                }
            } else if (object == this.remove) {
                int[] nArray = ClassPathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(nArray);
            } else if (object == this.edit) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)this.listModel.get(this.list.getSelectedIndices()[0]);
                ClassPathUiSupport.edit(this.listModel, this.list.getSelectedIndices(), this.project.getAntProjectHelper());
                this.list.repaint();
            } else if (object == this.moveUp) {
                int[] nArray = ClassPathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(nArray);
            } else if (object == this.moveDown) {
                int[] nArray = ClassPathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(nArray);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = false;
            if (this.selectionModel.getMinSelectionIndex() != -1) {
                bl = true;
                int n = this.selectionModel.getMinSelectionIndex();
                int n2 = this.selectionModel.getMinSelectionIndex();
                for (int i = n; i <= n2; ++i) {
                    ClassPathSupport.Item item;
                    if (!this.selectionModel.isSelectedIndex(i) || (item = (ClassPathSupport.Item)this.listModel.get(i)).getType() != 3) continue;
                    bl = false;
                    break;
                }
            }
            this.edit.setEnabled(ClassPathUiSupport.canEdit(this.selectionModel, this.listModel));
            this.remove.setEnabled(bl);
            this.moveUp.setEnabled(ClassPathUiSupport.canMoveUp(this.selectionModel));
            this.moveDown.setEnabled(ClassPathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
        }
    }

    public static class ClassPathListCellRenderer
    extends DefaultListCellRenderer {
        private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
        private static final Pattern UNKNOWN_FILE_REFERENCE = Pattern.compile("\\$\\{([^${}]+)\\}");
        private static String RESOURCE_ICON_JAR = "org/netbeans/modules/java/j2seproject/ui/resources/jar.gif";
        private static String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/java/j2seproject/ui/resources/libraries.gif";
        private static String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/java/j2seproject/ui/resources/projectDependencies.gif";
        private static String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/java/j2seproject/ui/resources/referencedClasspath.gif";
        private static String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/java/j2seproject/ui/resources/brokenProjectBadge.gif";
        private static String RESOURCE_ICON_SOURCE_BADGE = "org/netbeans/modules/java/j2seproject/ui/resources/jarSourceBadge.png";
        private static String RESOURCE_ICON_JAVADOC_BADGE = "org/netbeans/modules/java/j2seproject/ui/resources/jarJavadocBadge.png";
        private static ImageIcon ICON_JAR = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_JAR));
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_LIBRARY = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_LIBRARY));
        private static ImageIcon ICON_ARTIFACT = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_ARTIFACT));
        private static ImageIcon ICON_CLASSPATH = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_CLASSPATH));
        private static ImageIcon ICON_BROKEN_BADGE = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_BROKEN_BADGE));
        private static ImageIcon ICON_JAVADOC_BADGE = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_JAVADOC_BADGE));
        private static ImageIcon ICON_SOURCE_BADGE = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_SOURCE_BADGE));
        private static ImageIcon ICON_BROKEN_JAR;
        private static ImageIcon ICON_BROKEN_LIBRARY;
        private static ImageIcon ICON_BROKEN_ARTIFACT;
        private PropertyEvaluator evaluator;
        private FileObject projectFolder;
        private static final Map WELL_KNOWN_PATHS_NAMES;

        public ClassPathListCellRenderer(PropertyEvaluator propertyEvaluator, FileObject fileObject) {
            this.evaluator = propertyEvaluator;
            this.projectFolder = fileObject;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)object;
            super.getListCellRendererComponent((JList<?>)jList, this.getDisplayName(item), n, bl, bl2);
            this.setIcon(ClassPathListCellRenderer.getIcon(item));
            this.setToolTipText(this.getToolTipText(item));
            return this;
        }

        private String getDisplayName(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(J2SEClassPathUi.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(item));
                    }
                    return item.getLibrary().getDisplayName();
                }
                case 3: {
                    String string = (String)WELL_KNOWN_PATHS_NAMES.get(ClassPathSupport.getAntPropertyName(item.getReference()));
                    return string == null ? item.getReference() : string;
                }
                case 2: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(J2SEClassPathUi.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(item));
                    }
                    Project project = item.getArtifact().getProject();
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    String string = projectInformation.getDisplayName();
                    return MessageFormat.format(NbBundle.getMessage(J2SEClassPathUi.class, (String)"MSG_ProjectArtifactFormat"), string, item.getArtifactURI().toString());
                }
                case 0: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(J2SEClassPathUi.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                    }
                    if (item.getVariableBasedProperty() != null) {
                        String string = item.getVariableBasedProperty();
                        return string.substring(6, string.indexOf("}")) + string.substring(string.indexOf("}") + 1);
                    }
                    return item.getFilePath();
                }
            }
            return item.getReference();
        }

        static Icon getIcon(ClassPathSupport.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_LIBRARY == null) {
                            ICON_BROKEN_LIBRARY = new ImageIcon(Utilities.mergeImages((Image)ICON_LIBRARY.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_LIBRARY;
                    }
                    return ICON_LIBRARY;
                }
                case 2: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_ARTIFACT == null) {
                            ICON_BROKEN_ARTIFACT = new ImageIcon(Utilities.mergeImages((Image)ICON_ARTIFACT.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_ARTIFACT;
                    }
                    Project project = item.getArtifact().getProject();
                    if (project != null) {
                        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                        return projectInformation.getIcon();
                    }
                    return ICON_ARTIFACT;
                }
                case 0: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_JAR == null) {
                            ICON_BROKEN_JAR = new ImageIcon(Utilities.mergeImages((Image)ICON_JAR.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_JAR;
                    }
                    String string = item.getFilePath();
                    ImageIcon imageIcon = ICON_JAR;
                    if (item.getSourceFilePath() != null) {
                        imageIcon = new ImageIcon(Utilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_SOURCE_BADGE.getImage(), (int)8, (int)8));
                    }
                    if (item.getJavadocFilePath() != null) {
                        imageIcon = new ImageIcon(Utilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_JAVADOC_BADGE.getImage(), (int)8, (int)0));
                    }
                    return imageIcon;
                }
                case 3: {
                    return ICON_CLASSPATH;
                }
            }
            return null;
        }

        private String getToolTipText(ClassPathSupport.Item item) {
            if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
                return this.evaluator.evaluate(item.getReference());
            }
            switch (item.getType()) {
                case 0: {
                    String string = item.getFilePath();
                    File file = new File(string);
                    if (file.isAbsolute() && item.getVariableBasedProperty() == null) break;
                    file = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.projectFolder), (String)string);
                    return file.getAbsolutePath();
                }
            }
            return null;
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getProjectName(ClassPathSupport.Item item) {
            String string = item.getReference();
            return string.substring(12, string.indexOf(".", 12));
        }

        private String getLibraryName(ClassPathSupport.Item item) {
            String string = item.getReference();
            if (string == null) {
                if (item.getLibrary() != null) {
                    return item.getLibrary().getName();
                }
                return "XXX";
            }
            return string.substring(7, string.indexOf(".classpath"));
        }

        private String getFileRefName(ClassPathSupport.Item item) {
            String string = item.getReference();
            Matcher matcher = FOREIGN_PLAIN_FILE_REFERENCE.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            matcher = UNKNOWN_FILE_REFERENCE.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return string;
        }

        static {
            WELL_KNOWN_PATHS_NAMES = new HashMap();
            WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(J2SEProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(J2SEProjectProperties.class, (String)"LBL_JavacTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("run.classpath", NbBundle.getMessage(J2SEProjectProperties.class, (String)"LBL_RunClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(J2SEProjectProperties.class, (String)"LBL_RunTestClasspath_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(J2SEProjectProperties.class, (String)"LBL_BuildClassesDir_DisplayName"));
            WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(J2SEProjectProperties.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
        }
    }
}

