/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.compapp.casaeditor.properties.NamespaceEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceEditorPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
DocumentListener {
    static final long serialVersionUID = 1L;
    public static final String PROP_VALID_SELECTION = "validSelection";
    private boolean isValid = true;
    private Collection<NamespaceEditor.PrefixNamespacePair> mURIs;
    public ButtonGroup buttonGroup1;
    public JLabel dummyLabel1;
    public JLabel dummyLabel2;
    public JScrollPane jScrollPane1;
    public JLabel localNameEntryLabel;
    public JTextField localNameTextField;
    public JLabel namespaceEntryLabel;
    public JRadioButton otherNamespaceRadioButton;
    public JTextField otherNamespaceTextField;
    public JLabel prefixEntryLabel;
    public JLabel prefixErrorLabel;
    public JTextField prefixTextField;
    public JRadioButton schemaNamespaceRadioButton;
    public JList uriList;
    public JLabel uriListLabel;

    public NamespaceEditorPanel(QName qName, Collection<NamespaceEditor.PrefixNamespacePair> collection, Collection<NamespaceEditor.Option> collection2) {
        this.mURIs = collection;
        this.initComponents();
        this.initialize(qName, collection2);
        this.initializeCustomListeners();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.schemaNamespaceRadioButton = new JRadioButton();
        this.otherNamespaceRadioButton = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.uriList = new JList();
        this.otherNamespaceTextField = new JTextField();
        this.dummyLabel1 = new JLabel();
        this.dummyLabel2 = new JLabel();
        this.namespaceEntryLabel = new JLabel();
        this.prefixEntryLabel = new JLabel();
        this.prefixTextField = new JTextField();
        this.localNameEntryLabel = new JLabel();
        this.localNameTextField = new JTextField();
        this.prefixErrorLabel = new JLabel();
        this.uriListLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.schemaNamespaceRadioButton, (String)NbBundle.getMessage(NamespaceEditorPanel.class, (String)"LBL_SchemaNamespace"));
        this.schemaNamespaceRadioButton.setToolTipText(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"HINT_SchemaNamespace"));
        this.schemaNamespaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.schemaNamespaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.schemaNamespaceRadioButton);
        this.schemaNamespaceRadioButton.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.otherNamespaceRadioButton, (String)NbBundle.getMessage(NamespaceEditorPanel.class, (String)"LBL_OtherNamespace"));
        this.otherNamespaceRadioButton.setToolTipText(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"HINT_OtherNamespace"));
        this.otherNamespaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.otherNamespaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.otherNamespaceRadioButton);
        this.otherNamespaceRadioButton.addActionListener(this);
        this.uriList.addListSelectionListener(this);
        this.jScrollPane1.setViewportView(this.uriList);
        this.uriList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSN_NameSpacesList"));
        this.uriList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_NameSpacesListDescription"));
        this.namespaceEntryLabel.setLabelFor(this.otherNamespaceTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/compapp/casaeditor/properties/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.namespaceEntryLabel, (String)resourceBundle.getString("LBL_NamespaceEntry"));
        this.prefixEntryLabel.setLabelFor(this.prefixTextField);
        Mnemonics.setLocalizedText((JLabel)this.prefixEntryLabel, (String)resourceBundle.getString("LBL_PrefixEntry"));
        this.prefixTextField.setToolTipText(resourceBundle.getString("HINT_Prefix"));
        this.localNameEntryLabel.setLabelFor(this.localNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.localNameEntryLabel, (String)resourceBundle.getString("LBL_LocalNameEntry"));
        this.localNameTextField.setToolTipText(resourceBundle.getString("HINT_LocalName"));
        this.prefixErrorLabel.setForeground(new Color(255, 0, 0));
        this.uriListLabel.setLabelFor(this.uriList);
        Mnemonics.setLocalizedText((JLabel)this.uriListLabel, (String)"List of pre-existing Namespaces:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.dummyLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.otherNamespaceRadioButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.prefixEntryLabel, -2, 28, -2).addPreferredGap(0).add((Component)this.prefixTextField, -2, 56, -2).add(225, 225, 225)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.namespaceEntryLabel).addPreferredGap(0).add((Component)this.otherNamespaceTextField, -1, 281, Short.MAX_VALUE))))).addPreferredGap(0).add((Component)this.prefixErrorLabel, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.schemaNamespaceRadioButton).add(22, 22, 22).add((Component)this.dummyLabel2).add(151, 151, 151)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.localNameEntryLabel).addPreferredGap(0).add((Component)this.localNameTextField, -1, 324, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.uriListLabel)))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(27, 27, 27).add((Component)this.jScrollPane1, -1, 365, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.namespaceEntryLabel, this.prefixEntryLabel}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((Component)this.dummyLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dummyLabel2).add((Component)this.localNameEntryLabel).add((Component)this.localNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.schemaNamespaceRadioButton).addPreferredGap(0).add((Component)this.uriListLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 124, -2).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(42, 42, 42).add((Component)this.prefixErrorLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(18, 18, 18).add((Component)this.otherNamespaceRadioButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.namespaceEntryLabel, -1, -1, Short.MAX_VALUE).add((Component)this.otherNamespaceTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.prefixEntryLabel).add((Component)this.prefixTextField, -2, -1, -2)))).addContainerGap(32, Short.MAX_VALUE)));
        this.schemaNamespaceRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSN_PreExsitingNameSpace"));
        this.schemaNamespaceRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_PreExisitngNameSpace"));
        this.otherNamespaceRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSN_NewNameSpace"));
        this.otherNamespaceRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_NewNameSpace"));
        this.otherNamespaceTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"HINT_OtherNamespace"));
        this.otherNamespaceTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"HINT_OtherNamespace"));
        this.namespaceEntryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSN_NameSpaceURI"));
        this.namespaceEntryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_NameSpaceURI"));
        this.prefixEntryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSN_Prefix"));
        this.prefixEntryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_Prefix"));
        this.prefixTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSN_PrefixEditor"));
        this.prefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_PrefixEditor"));
        this.localNameEntryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ASCN_LocalName"));
        this.localNameEntryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_LocalName"));
        this.localNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ASCN_LocalNameEditor"));
        this.localNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespaceEditorPanel.class, (String)"ACSD_LocalNameEditor"));
    }

    private void initializeCustomListeners() {
        this.localNameTextField.getDocument().addDocumentListener(this);
        this.prefixTextField.getDocument().addDocumentListener(this);
        this.otherNamespaceTextField.getDocument().addDocumentListener(this);
    }

    private void initialize(QName qName, Collection<NamespaceEditor.Option> collection) {
        NamespaceEditor.PrefixNamespacePair prefixNamespacePair = null;
        if (qName != null) {
            prefixNamespacePair = new NamespaceEditor.PrefixNamespacePair(qName.getPrefix(), qName.getNamespaceURI());
        }
        if (this.mURIs == null || this.mURIs.isEmpty()) {
            this.schemaNamespaceRadioButton.setVisible(false);
            this.uriList.setVisible(false);
            this.jScrollPane1.setVisible(false);
        } else {
            this.uriList.setListData(this.mURIs.toArray(new NamespaceEditor.PrefixNamespacePair[this.mURIs.size()]));
        }
        if (qName == null) {
            this.uriList.setEnabled(false);
            if (this.otherNamespaceRadioButton.isVisible()) {
                this.otherNamespaceRadioButton.setSelected(true);
                this.otherNamespaceTextField.setEnabled(true);
                this.prefixTextField.setEnabled(true);
            }
        } else if (this.mURIs != null && this.mURIs.contains(prefixNamespacePair)) {
            this.localNameTextField.setText(qName.getLocalPart());
            this.schemaNamespaceRadioButton.setSelected(true);
            this.uriList.setSelectedValue(prefixNamespacePair, true);
            this.uriList.setEnabled(true);
            this.otherNamespaceTextField.setEnabled(false);
            this.prefixTextField.setEnabled(false);
        } else {
            this.uriList.setEnabled(false);
            if (this.otherNamespaceRadioButton.isVisible()) {
                this.otherNamespaceRadioButton.setSelected(true);
                this.otherNamespaceTextField.setText(qName.getNamespaceURI());
                this.localNameTextField.setText(qName.getLocalPart());
                this.otherNamespaceTextField.setEnabled(true);
                this.prefixTextField.setEnabled(true);
            }
        }
    }

    public void setEditable(boolean bl) {
        this.schemaNamespaceRadioButton.setEnabled(bl);
        this.otherNamespaceRadioButton.setEnabled(bl);
        this.uriList.setEnabled(bl && this.uriList.isEnabled());
        this.localNameTextField.setEditable(bl);
        this.prefixTextField.setEditable(bl);
        this.otherNamespaceTextField.setEditable(bl);
    }

    public void checkValidity() {
        boolean bl = false;
        if (this.schemaNamespaceRadioButton.isSelected()) {
            bl = this.localNameTextField.getText().trim().length() > 0 && this.uriList.getSelectedValue() != null;
        } else if (this.otherNamespaceRadioButton.isSelected()) {
            bl = this.localNameTextField.getText().trim().length() > 0 && this.otherNamespaceTextField.getText().trim().length() > 0 && this.prefixTextField.getText().trim().length() > 0;
            bl = bl && !this.isDuplicatePrefix();
        }
        this.firePropertyChange(PROP_VALID_SELECTION, this.isValid, bl);
        this.isValid = bl;
    }

    private boolean isDuplicatePrefix() {
        boolean bl = false;
        String string = this.prefixTextField.getText().trim();
        if (string.length() > 0) {
            for (NamespaceEditor.PrefixNamespacePair prefixNamespacePair : this.mURIs) {
                if (!string.equals(prefixNamespacePair.getPrefix())) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.prefixErrorLabel.setText(NbBundle.getMessage(this.getClass(), (String)"LBL_PrefixAlreadyExists"));
            } else {
                this.prefixErrorLabel.setText("");
            }
        }
        return bl;
    }

    public QName getCurrentSelection() {
        if (this.schemaNamespaceRadioButton.isSelected()) {
            NamespaceEditor.PrefixNamespacePair prefixNamespacePair = (NamespaceEditor.PrefixNamespacePair)this.uriList.getSelectedValue();
            return new QName(prefixNamespacePair.getNamespace(), this.localNameTextField.getText().trim(), prefixNamespacePair.getPrefix());
        }
        if (this.otherNamespaceRadioButton.isSelected()) {
            return new QName(this.otherNamespaceTextField.getText().trim(), this.localNameTextField.getText().trim(), this.prefixTextField.getText().trim());
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.otherNamespaceRadioButton)) {
            this.uriList.setEnabled(false);
            this.otherNamespaceTextField.setEnabled(true);
            this.prefixTextField.setEnabled(true);
        } else if (object.equals(this.schemaNamespaceRadioButton)) {
            this.otherNamespaceTextField.setEnabled(false);
            this.prefixTextField.setEnabled(false);
            this.uriList.setEnabled(true);
        }
        this.checkValidity();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkValidity();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

