/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.JBIAttributes;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeChildren;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.ExtensionPropertyHelper;
import org.netbeans.modules.compapp.casaeditor.nodes.ReadOnlyFilterNode;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.CloneWSDLPortAction;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.WSDLEndpointAction;
import org.netbeans.modules.compapp.casaeditor.properties.PortTypeProperty;
import org.netbeans.modules.compapp.casaeditor.properties.PropertyUtils;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.PortNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLEndpointNode
extends CasaNode {
    private static final Image ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/nodes/resources/WSDLEndpointNode.png");
    private static final String CHILD_ID_PROVIDES = "Provides";
    private static final String CHILD_ID_CONSUMES = "Consumes";
    private static final String SOAP_BINDING = "soap";

    public WSDLEndpointNode(CasaPort casaPort, CasaNodeFactory casaNodeFactory) {
        super((Object)casaPort, (Children)new MyChildren(casaPort, casaNodeFactory), casaNodeFactory);
    }

    public String getName() {
        CasaPort casaPort = (CasaPort)this.getData();
        if (casaPort != null) {
            return casaPort.getEndpointName();
        }
        return super.getName();
    }

    public String getHtmlDisplayName() {
        try {
            String string = this.getName();
            CasaPort casaPort = (CasaPort)this.getData();
            String string2 = null;
            if (casaPort != null) {
                string2 = NbBundle.getMessage(WSDLEndpointNode.class, (String)"LBL_NameAttr", (Object)casaPort.getEndpointName());
            }
            if (string2 == null) {
                return string;
            }
            return string + " <font color='#999999'>" + string2 + "</font>";
        }
        catch (Throwable throwable) {
            return this.getBadName();
        }
    }

    @Override
    protected void addCustomActions(List<Action> list) {
        CasaPort casaPort = (CasaPort)this.getData();
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaPort.getModel();
        if (casaWrapperModel.isEditable(casaPort)) {
            if (casaWrapperModel.getBindingType(casaPort).equalsIgnoreCase(SOAP_BINDING)) {
                list.add(new WSDLEndpointAction());
            }
        } else {
            list.add((Action)SystemAction.get(CloneWSDLPortAction.class));
        }
    }

    @Override
    protected void setupPropertySheet(Sheet sheet) {
        final CasaPort casaPort = (CasaPort)this.getData();
        if (casaPort == null) {
            return;
        }
        Sheet.Set set = this.getPropertySet(sheet, PropertyUtils.PropertiesGroups.IDENTIFICATION_SET);
        PortTypeProperty portTypeProperty = new PortTypeProperty(this);
        set.put((Node.Property)portTypeProperty);
        PropertyUtils.installEndpointNameProperty(set, this, casaPort, JBIAttributes.ENDPOINT_NAME.getName(), "endpointName", NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_EndpointName"), NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_EndpointName"));
        PropertySupport.ReadOnly<String> readOnly = new PropertySupport.ReadOnly<String>("componentName", String.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_ComponentName"), ""){

            public String getValue() {
                return ((CasaWrapperModel)casaPort.getModel()).getBindingComponentName(casaPort);
            }
        };
        set.put((Node.Property)readOnly);
        for (Node node : this.getChildren().getNodes()) {
            if (!(node instanceof PortNode)) continue;
            WSDLEndpointNode.addPortChildrenProperties(sheet, node.getChildren(), this.isEditable());
            break;
        }
        String string = this.getModel().getBindingComponentName(casaPort);
        ExtensionPropertyHelper.setupExtensionPropertySheet(this, casaPort, sheet, "port", string);
    }

    private static void addPortChildrenProperties(Sheet sheet, Children children, boolean bl) {
        if (children == null) {
            return;
        }
        for (Node node : children.getNodes()) {
            Object object = bl ? node : new ReadOnlyFilterNode(node);
            Sheet.Set set = new Sheet.Set();
            set.setName(object.getDisplayName());
            sheet.put(set);
            Node.PropertySet[] propertySetArray = object.getPropertySets();
            if (propertySetArray != null) {
                for (Node.PropertySet propertySet : propertySetArray) {
                    set.put(propertySet.getProperties());
                }
            }
            WSDLEndpointNode.addPortChildrenProperties(sheet, object.getChildren(), bl);
        }
    }

    public Image getIcon(int n) {
        return ICON;
    }

    public Image getOpenedIcon(int n) {
        return ICON;
    }

    @Override
    public boolean isEditable(String string) {
        CasaPort casaPort = (CasaPort)this.getData();
        if (casaPort != null) {
            return this.getModel().isEditable(casaPort, string);
        }
        return false;
    }

    public boolean isEditable() {
        CasaPort casaPort = (CasaPort)this.getData();
        if (casaPort != null) {
            return this.getModel().isEditable(casaPort);
        }
        return false;
    }

    @Override
    public boolean isDeletable() {
        CasaPort casaPort = (CasaPort)this.getData();
        if (casaPort != null) {
            return this.getModel().isDeletable(casaPort);
        }
        return false;
    }

    private static class MyChildren
    extends CasaNodeChildren {
        public MyChildren(CasaComponent casaComponent, CasaNodeFactory casaNodeFactory) {
            super(casaComponent, casaNodeFactory);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof Port) {
                Node node = NodesFactory.getInstance().create((WSDLComponent)((Port)object));
                return new Node[]{node};
            }
            if (object instanceof Binding) {
                Node node = NodesFactory.getInstance().create((WSDLComponent)((Binding)object));
                return new Node[]{node};
            }
            return null;
        }

        public Object getChildKeys(Object object) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            CasaPort casaPort = (CasaPort)this.getData();
            if (casaPort != null) {
                Port port = ((CasaWrapperModel)casaPort.getModel()).getLinkedWSDLPort(casaPort);
                if (port != null) {
                    arrayList.add(port);
                    try {
                        Binding binding = (Binding)port.getBinding().get();
                        if (binding != null) {
                            arrayList.add(binding);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (casaPort.getConsumes() != null) {
                    arrayList.add(WSDLEndpointNode.CHILD_ID_CONSUMES);
                }
                if (casaPort.getProvides() != null) {
                    arrayList.add(WSDLEndpointNode.CHILD_ID_PROVIDES);
                }
            }
            return arrayList;
        }
    }
}

