/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Action;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeChildren;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.GoToSourceAction;
import org.netbeans.modules.compapp.casaeditor.properties.PropertyUtils;
import org.netbeans.modules.compapp.projects.jbi.api.JbiDefaultComponentInfo;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUnitProcessNode
extends CasaNode {
    public static final Image DEFAULT_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/nodes/resources/ServiceUnitNode.png");
    private static final String CHILD_ID_PROVIDES_LIST = "ProvidesList";
    private static final String CHILD_ID_CONSUMES_LIST = "ConsumesList";

    public ServiceUnitProcessNode(CasaEndpoint casaEndpoint, CasaNodeFactory casaNodeFactory) {
        super((Object)casaEndpoint, (Children)new MyChildren(casaEndpoint, casaNodeFactory), casaNodeFactory);
        assert (casaEndpoint != null);
    }

    public String getProcessName() {
        return ((CasaEndpoint)this.getData()).getProcessName();
    }

    public String getFilePath() {
        return ((CasaEndpoint)this.getData()).getFilePath();
    }

    public CasaServiceEngineServiceUnit getServiceEngineServiceUnit() {
        CasaEndpoint casaEndpoint = (CasaEndpoint)this.getData();
        return ServiceUnitProcessNode.getServiceEngineServiceUnit(casaEndpoint);
    }

    private static CasaServiceEngineServiceUnit getServiceEngineServiceUnit(CasaEndpoint casaEndpoint) {
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaEndpoint.getModel();
        CasaEndpointRef casaEndpointRef = casaWrapperModel.getServiceEngineEndpointRef(casaEndpoint);
        return casaWrapperModel.getCasaEngineServiceUnit(casaEndpointRef);
    }

    @Override
    protected void addCustomActions(List<Action> list) {
        CasaEndpoint casaEndpoint = (CasaEndpoint)this.getData();
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = ServiceUnitProcessNode.getServiceEngineServiceUnit(casaEndpoint);
        if (casaServiceEngineServiceUnit != null && casaServiceEngineServiceUnit.isInternal()) {
            list.add((Action)SystemAction.get(GoToSourceAction.class));
        }
    }

    public String getName() {
        return this.getProcessName();
    }

    @Override
    protected void setupPropertySheet(Sheet sheet) {
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.getServiceEngineServiceUnit();
        if (casaServiceEngineServiceUnit == null) {
            return;
        }
        Sheet.Set set = this.getPropertySet(sheet, PropertyUtils.PropertiesGroups.IDENTIFICATION_SET);
        PropertySupport.ReadOnly<String> readOnly = new PropertySupport.ReadOnly<String>("processName", String.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_ProcessName"), ""){

            public String getValue() {
                return ServiceUnitProcessNode.this.getProcessName();
            }
        };
        set.put((Node.Property)readOnly);
        PropertySupport.ReadOnly<String> readOnly2 = new PropertySupport.ReadOnly<String>("filePath", String.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_FilePath"), ""){

            public String getValue() {
                return ServiceUnitProcessNode.this.getFilePath();
            }
        };
        set.put((Node.Property)readOnly2);
    }

    public Image getIcon(int n) {
        return ServiceUnitProcessNode.getFileIconImage((CasaEndpoint)this.getData());
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    @Override
    public boolean isEditable(String string) {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    public static Image getFileIconImage(CasaEndpoint casaEndpoint) {
        Image image = DEFAULT_ICON;
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaEndpoint.getModel();
        CasaEndpointRef casaEndpointRef = casaWrapperModel.getServiceEngineEndpointRef(casaEndpoint);
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = (CasaServiceEngineServiceUnit)casaEndpointRef.getParent();
        String string = casaServiceEngineServiceUnit.getComponentName();
        JbiDefaultComponentInfo jbiDefaultComponentInfo = JbiDefaultComponentInfo.getJbiDefaultComponentInfo();
        JBIComponentStatus jBIComponentStatus = (JBIComponentStatus)jbiDefaultComponentInfo.getComponentHash().get(string);
        URL uRL = null;
        if (jBIComponentStatus != null && (uRL = jBIComponentStatus.getFileIconURL()) != null) {
            try {
                image = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyChildren
    extends CasaNodeChildren {
        public MyChildren(CasaEndpoint casaEndpoint, CasaNodeFactory casaNodeFactory) {
            super(casaEndpoint, casaNodeFactory);
        }

        protected Node[] createNodes(Object object) {
            CasaWrapperModel casaWrapperModel;
            assert (object instanceof String);
            CasaEndpoint casaEndpoint = (CasaEndpoint)this.getData();
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = ServiceUnitProcessNode.getServiceEngineServiceUnit(casaEndpoint);
            if (casaServiceEngineServiceUnit != null && (casaWrapperModel = this.mNodeFactory.getCasaModel()) != null) {
                String string = (String)object;
                if (string.equals(ServiceUnitProcessNode.CHILD_ID_CONSUMES_LIST)) {
                    return new Node[]{this.mNodeFactory.createNode_consumesList(this.getConsumeEndpointRefs())};
                }
                if (string.equals(ServiceUnitProcessNode.CHILD_ID_PROVIDES_LIST)) {
                    return new Node[]{this.mNodeFactory.createNode_providesList(this.getProvideEndpointRefs())};
                }
            }
            return null;
        }

        @Override
        public Object getChildKeys(Object object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ServiceUnitProcessNode.CHILD_ID_CONSUMES_LIST);
            arrayList.add(ServiceUnitProcessNode.CHILD_ID_PROVIDES_LIST);
            return arrayList;
        }

        private String getProcessName() {
            CasaEndpoint casaEndpoint = (CasaEndpoint)this.getData();
            return casaEndpoint.getProcessName();
        }

        private List<CasaConsumes> getConsumeEndpointRefs() {
            ArrayList<CasaConsumes> arrayList = new ArrayList<CasaConsumes>();
            CasaEndpoint casaEndpoint = (CasaEndpoint)this.getData();
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = ServiceUnitProcessNode.getServiceEngineServiceUnit(casaEndpoint);
            if (casaServiceEngineServiceUnit != null) {
                for (CasaConsumes casaConsumes : casaServiceEngineServiceUnit.getConsumes()) {
                    CasaEndpoint casaEndpoint2 = (CasaEndpoint)casaConsumes.getEndpoint().get();
                    String string = casaEndpoint2.getProcessName();
                    if (string == null || !string.equals(this.getProcessName())) continue;
                    arrayList.add(casaConsumes);
                }
            }
            return arrayList;
        }

        private List<CasaProvides> getProvideEndpointRefs() {
            ArrayList<CasaProvides> arrayList = new ArrayList<CasaProvides>();
            CasaEndpoint casaEndpoint = (CasaEndpoint)this.getData();
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = ServiceUnitProcessNode.getServiceEngineServiceUnit(casaEndpoint);
            if (casaServiceEngineServiceUnit != null) {
                for (CasaProvides casaProvides : casaServiceEngineServiceUnit.getProvides()) {
                    CasaEndpoint casaEndpoint2 = (CasaEndpoint)casaProvides.getEndpoint().get();
                    String string = casaEndpoint2.getProcessName();
                    if (string == null || !string.equals(this.getProcessName())) continue;
                    arrayList.add(casaProvides);
                }
            }
            return arrayList;
        }
    }
}

