/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.model.casa.validator.visitor;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean isCombiningChar(char c) {
        return false;
    }

    public static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static boolean isNCName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (!ValidationUtils.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (ValidationUtils.isNCNameChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNameChar(char c) {
        if (ValidationUtils.isLetter(c) || ValidationUtils.isDigit(c)) {
            return true;
        }
        if (ValidationUtils.isExtender(c) || ValidationUtils.isCombiningChar(c)) {
            return true;
        }
        switch (c) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNMToken(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        block3: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (ValidationUtils.isLetter(c) || ValidationUtils.isDigit(c) || ValidationUtils.isExtender(c) || ValidationUtils.isCombiningChar(c)) continue;
            switch (c) {
                case '-': 
                case '.': 
                case ':': 
                case '_': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isCDATA(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isExtender(char c) {
        if (c >= '\u3031' && c <= '\u3035') {
            return true;
        }
        if (c >= '\u30fc' && c <= '\u30fe') {
            return true;
        }
        switch (c) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': 
            case '\u309d': 
            case '\u309e': {
                return true;
            }
        }
        return false;
    }

    public static boolean isQName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (!ValidationUtils.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (cArray[i] == ':' || ValidationUtils.isNCNameChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqualXMLValues(String string, String string2) {
        return string == null && string2 == null || string == null && ValidationUtils.isEmpty(string2) || ValidationUtils.isEmpty(string) && string2 == null || string != null && string.equals(string2);
    }

    public static boolean isEmpty(String string) {
        return null == string || string.trim().length() == 0;
    }
}

