/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaMinimizable;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngine;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.openide.util.NbBundle;

public class CasaPinWidgetEngine
extends CasaPinWidget
implements CasaMinimizable {
    private static final int LABEL_MAX_CHAR = 48;
    private LabelWidget mNameWidget;
    private ImageWidget mEmptyWidget;
    private Image mCurrentImage = this.getPinImage();
    private static final boolean DEBUG = false;

    public CasaPinWidgetEngine(Scene scene, Image image, Image image2) {
        super(scene, image, image2);
        this.mEmptyWidget = new ImageWidget(scene);
        this.mEmptyWidget.setPreferredBounds(this.mImageWidget.getPreferredBounds());
        this.mNameWidget = new LabelWidget(scene);
        this.mNameWidget.setOpaque(false);
        switch (this.getDirection()) {
            case LEFT: {
                this.setLayout(RegionUtilities.createHorizontalFlowLayoutWithJustifications(LayoutFactory.SerialAlignment.LEFT_TOP, 5));
                this.addChild((Widget)this.mImageWidget);
                this.addChild((Widget)this.mNameWidget);
                this.addChild((Widget)this.mEmptyWidget);
                break;
            }
            case RIGHT: {
                this.setLayout(RegionUtilities.createHorizontalFlowLayoutWithJustifications(LayoutFactory.SerialAlignment.RIGHT_BOTTOM, 5));
                this.addChild((Widget)this.mEmptyWidget);
                this.addChild((Widget)this.mNameWidget);
                this.addChild((Widget)this.mImageWidget);
            }
        }
    }

    protected void setSelected(boolean bl) {
        super.setSelected(bl);
        this.mCurrentImage = this.mImageWidget.getImage();
    }

    protected void setPinName(String string) {
        String string2 = string;
        if (string2.length() > 48) {
            string2 = string2.substring(0, 48) + NbBundle.getMessage(this.getClass(), (String)"ELLIPSIS");
        }
        this.mNameWidget.setLabel(string2);
        Widget widget = this.getParentWidget();
        while (!(widget instanceof CasaNodeWidgetEngine)) {
            widget = widget.getParentWidget();
        }
        ((CasaNodeWidgetEngine)widget).readjustBounds();
    }

    protected RegionUtilities.Directions getDirection() {
        return RegionUtilities.Directions.LEFT;
    }

    public Anchor getAnchor() {
        return RegionUtilities.createFixedDirectionalAnchor(this, this.getDirection(), 0);
    }

    public void setLabelFont(Font font) {
        this.mNameWidget.setFont(font);
    }

    public void setLabelColor(Color color) {
        this.mNameWidget.setForeground(color);
    }

    public void setToolTip(String string) {
        this.mImageWidget.setToolTipText(string);
    }

    public void setMinimized(boolean bl) {
        Rectangle rectangle = bl ? new Rectangle() : null;
        this.mNameWidget.setPreferredBounds(rectangle);
        this.mImageWidget.setPreferredBounds(rectangle);
        this.setPreferredBounds(rectangle);
        this.mImageWidget.setImage(bl ? null : this.mCurrentImage);
    }
}

