/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaCustomizer;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.CasaMinimizable;
import org.netbeans.modules.compapp.casaeditor.graph.DependenciesRegistry;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaPopupMenuAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaQoSEditAction;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaExtensibilityElement;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.ConnectionNode;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.ClearConfigExtensionsAction;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CasaConnectionWidget
extends ConnectionWidget
implements CasaMinimizable {
    private static final Stroke STROKE_DEFAULT = new BasicStroke(1.0f);
    private static final Stroke STROKE_HOVERED = new BasicStroke(1.5f);
    private static final Stroke STROKE_SELECTED = new BasicStroke(2.0f);
    private static final Image IMAGE_QOS_BADGE_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/nodes/resources/QoS.png");
    private static final Image IMAGE_UNCONFIGURED_QOS_BADGE_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/nodes/resources/UnConfiguredQoS.png");
    private DependenciesRegistry mDependenciesRegistry = new DependenciesRegistry((Widget)this);
    private Widget mQoSWidget;
    private Widget mUnConfiguredQoSWidget;

    public CasaConnectionWidget(Scene scene) {
        super(scene);
        this.setSourceAnchorShape(AnchorShape.NONE);
        this.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.setPaintControlPoints(true);
        this.setState(ObjectState.createNormal());
        this.initQoSWidgets();
    }

    public void updateQoSWidgets() {
        ObjectScene objectScene = (ObjectScene)this.getScene();
        CasaConnection casaConnection = (CasaConnection)objectScene.findObject((Widget)this);
        this.updateQoSWidgets(casaConnection);
    }

    private void initQoSWidgets() {
        this.mQoSWidget = new ImageWidget(this.getScene(), IMAGE_QOS_BADGE_ICON);
        this.mUnConfiguredQoSWidget = new ImageWidget(this.getScene(), IMAGE_UNCONFIGURED_QOS_BADGE_ICON);
        CasaQoSEditAction casaQoSEditAction = new CasaQoSEditAction((CasaModelGraphScene)this.getScene());
        this.mQoSWidget.getActions().addAction((WidgetAction)casaQoSEditAction);
        this.mUnConfiguredQoSWidget.getActions().addAction((WidgetAction)casaQoSEditAction);
        CasaPopupMenuAction casaPopupMenuAction = new CasaPopupMenuAction(new PopupMenuProvider(){

            public JPopupMenu getPopupMenu(Widget widget, Point point) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)CasaConnectionWidget.this.getScene();
                CasaConnection casaConnection = (CasaConnection)casaModelGraphScene.findObject((Widget)CasaConnectionWidget.this);
                CasaNode casaNode = casaModelGraphScene.getNodeFactory().createNodeFor(casaConnection);
                ClearConfigExtensionsAction clearConfigExtensionsAction = new ClearConfigExtensionsAction(NbBundle.getMessage(ConnectionNode.class, (String)"CLEAR_QOS_CONFIG"), casaNode);
                jPopupMenu.add(clearConfigExtensionsAction.getPopupPresenter());
                return jPopupMenu;
            }
        });
        this.mQoSWidget.getActions().addAction((WidgetAction)casaPopupMenuAction);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectScene objectScene = (ObjectScene)CasaConnectionWidget.this.getScene();
                final CasaConnection casaConnection = (CasaConnection)objectScene.findObject((Widget)CasaConnectionWidget.this);
                if (casaConnection == null) {
                    return;
                }
                CasaConnectionWidget.this.updateQoSWidgets(casaConnection);
                casaConnection.getModel().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        CasaConnection casaConnection2 = null;
                        Object object = propertyChangeEvent.getSource();
                        if (object instanceof CasaExtensibilityElement) {
                            CasaComponent casaComponent;
                            for (casaComponent = (CasaExtensibilityElement)object; casaComponent != null && casaComponent instanceof CasaExtensibilityElement; casaComponent = (CasaComponent)casaComponent.getParent()) {
                            }
                            if (casaComponent == null || !(casaComponent instanceof CasaConnection)) {
                                return;
                            }
                            casaConnection2 = (CasaConnection)casaComponent;
                        } else if (object instanceof CasaConnection) {
                            casaConnection2 = (CasaConnection)object;
                        }
                        if (casaConnection2 == casaConnection) {
                            CasaConnectionWidget.this.updateQoSWidgets(casaConnection);
                        }
                    }
                });
            }
        });
    }

    public void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        Color color;
        Stroke stroke;
        CasaCustomizer casaCustomizer = CasaFactory.getCasaCustomizer();
        if (objectState2.isSelected() || objectState2.isFocused()) {
            this.bringToFront();
            stroke = STROKE_SELECTED;
            color = casaCustomizer.getCOLOR_SELECTION();
        } else if (objectState2.isHovered() || objectState2.isHighlighted()) {
            this.bringToFront();
            stroke = STROKE_HOVERED;
            color = casaCustomizer.getCOLOR_HOVERED_EDGE();
        } else {
            stroke = STROKE_DEFAULT;
            color = casaCustomizer.getCOLOR_CONNECTION_NORMAL();
        }
        this.setStroke(stroke);
        this.setForeground(color);
    }

    public void setForegroundColor(Color color) {
        this.setForeground(color);
    }

    protected void notifyAdded() {
        super.notifyAdded();
        Widget.Dependency dependency = new Widget.Dependency(){

            public void revalidateDependency() {
                if (CasaConnectionWidget.this.getBounds() == null) {
                    return;
                }
                Anchor anchor = CasaConnectionWidget.this.getSourceAnchor();
                if (anchor == null) {
                    return;
                }
                Widget widget = anchor.getRelatedWidget();
                if (widget == null) {
                    return;
                }
                Point point = anchor.getRelatedSceneLocation();
                int n = point.x + widget.getBounds().width / 2 + 10;
                int n2 = point.y - 6;
                CasaConnectionWidget.this.mQoSWidget.setPreferredLocation(new Point(n, n2));
                CasaConnectionWidget.this.mUnConfiguredQoSWidget.setPreferredLocation(new Point(n, n2));
            }
        };
        this.mDependenciesRegistry.registerDependency(dependency);
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.mDependenciesRegistry.removeAllDependencies();
        if (this.mQoSWidget != null) {
            this.mQoSWidget.removeFromParent();
        }
        if (this.mQoSWidget != null) {
            this.mUnConfiguredQoSWidget.removeFromParent();
        }
    }

    private void updateQoSWidgets(CasaConnection casaConnection) {
        boolean bl = false;
        if (CasaFactory.getCasaCustomizer().getBOOLEAN_CLASSIC_QOS_STYLE().booleanValue()) {
            if (this.isConnectionConfiguredWithQoS(casaConnection)) {
                if (this.getChildren().contains(this.mUnConfiguredQoSWidget)) {
                    this.removeChild(this.mUnConfiguredQoSWidget);
                    bl = true;
                }
                if (!this.getChildren().contains(this.mQoSWidget)) {
                    this.addChild(this.mQoSWidget);
                    bl = true;
                }
            } else {
                if (this.getChildren().contains(this.mQoSWidget)) {
                    this.removeChild(this.mQoSWidget);
                    bl = true;
                }
                if (!this.getChildren().contains(this.mUnConfiguredQoSWidget)) {
                    this.addChild(this.mUnConfiguredQoSWidget);
                    bl = true;
                }
            }
        } else {
            if (this.getChildren().contains(this.mUnConfiguredQoSWidget)) {
                this.removeChild(this.mUnConfiguredQoSWidget);
                bl = true;
            }
            if (this.getChildren().contains(this.mQoSWidget)) {
                this.removeChild(this.mQoSWidget);
                bl = true;
            }
        }
        if (bl) {
            this.getScene().validate();
        }
    }

    private boolean isConnectionConfiguredWithQoS(CasaConnection casaConnection) {
        return casaConnection.getChildren().size() != 0;
    }

    public void setMinimized(boolean bl) {
        if (bl) {
            if (this.getChildren().contains(this.mUnConfiguredQoSWidget)) {
                this.removeChild(this.mUnConfiguredQoSWidget);
            }
            if (this.getChildren().contains(this.mQoSWidget)) {
                this.removeChild(this.mQoSWidget);
            }
        } else {
            ObjectScene objectScene = (ObjectScene)this.getScene();
            CasaConnection casaConnection = (CasaConnection)objectScene.findObject((Widget)this);
            if (this.isConnectionConfiguredWithQoS(casaConnection)) {
                if (!this.getChildren().contains(this.mQoSWidget)) {
                    this.addChild(this.mQoSWidget);
                }
            } else if (!this.getChildren().contains(this.mUnConfiguredQoSWidget)) {
                this.addChild(this.mUnConfiguredQoSWidget);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CasaConnectionWidget.this.getScene().validate();
                }
            });
        }
    }
}

