/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.catd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.compapp.catd.util.Util;

public class Input {
    private String mName;
    private String mAction;
    private String mTemplate;
    private String[] mColumnNames;
    private List mRowList;
    private int mRowCount;
    private int mCurrentRow;
    private int mBatchSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadData(String dataFileName) {
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        BufferedReader fileIn = null;
        int colCnt = 0;
        try {
            fileIn = new BufferedReader(new InputStreamReader(new FileInputStream(dataFileName)));
            String record = fileIn.readLine();
            while (record.startsWith("#")) {
                record = fileIn.readLine();
            }
            StringTokenizer st = new StringTokenizer(record, ",");
            colCnt = st.countTokens();
            this.mColumnNames = new String[colCnt];
            for (int i = 0; i < colCnt; ++i) {
                this.mColumnNames[i] = st.nextToken();
            }
            while ((record = fileIn.readLine()) != null) {
                if (record.startsWith("#")) continue;
                Object[] row = new Object[colCnt];
                st = new StringTokenizer(record, ",");
                for (int i = 0; i < colCnt; ++i) {
                    row[i] = st.hasMoreTokens() ? st.nextToken() : "";
                }
                rowList.add(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return rowList;
    }

    private void incrementRow() {
        this.mCurrentRow = this.mCurrentRow < this.mRowCount - 1 ? ++this.mCurrentRow : 0;
    }

    public Input(String name, String action, String templateFile, String dataFile, int batchSize) {
        this.mName = name;
        this.mAction = action;
        this.mTemplate = Util.getFileContent(new File(templateFile));
        this.mRowList = this.loadData(dataFile);
        this.mRowCount = this.mRowList.size();
        this.mCurrentRow = 0;
        this.mBatchSize = batchSize;
    }

    public String getName() {
        return this.mName;
    }

    public String getAction() {
        return this.mAction;
    }

    public String nextData() {
        Object ret = null;
        String s = this.mTemplate;
        for (int i = 0; i < this.mBatchSize; ++i) {
            Object[] row = (Object[])this.mRowList.get(this.mCurrentRow);
            this.incrementRow();
            int J = row.length;
            for (int j = 0; j < J; ++j) {
                String data = (String)row[j];
                String placeHolder = "${" + this.mColumnNames[j] + "." + i + "}";
                s = Util.replaceAll(s, placeHolder, data);
            }
        }
        return s;
    }
}

