/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Collection;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncTokenList<T extends TokenId>
extends FlyOffsetGapList<TokenOrEmbedding<T>>
implements MutableTokenList<T> {
    private final TokenHierarchyOperation<?, T> tokenHierarchyOperation;
    private LanguagePath languagePath;
    private CharSequence inputSourceText;
    private LexerInputOperation<T> lexerInputOperation;
    private int rootModCount;
    private LAState laState;

    public IncTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation) {
        this.tokenHierarchyOperation = tokenHierarchyOperation;
    }

    public void reinit() {
        if (this.languagePath != null) {
            MutableTextInput mutableTextInput = this.tokenHierarchyOperation.mutableTextInput();
            this.inputSourceText = LexerSpiPackageAccessor.get().text(mutableTextInput);
            this.lexerInputOperation = new TextLexerInputOperation(this);
        } else {
            this.inputSourceText = null;
            this.releaseLexerInputOperation();
        }
        this.laState = LAState.empty();
    }

    public void releaseLexerInputOperation() {
        if (this.lexerInputOperation != null) {
            this.lexerInputOperation.release();
            this.lexerInputOperation = null;
        }
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public void setLanguagePath(LanguagePath languagePath) {
        this.languagePath = languagePath;
    }

    public boolean updateLanguagePath() {
        Language<?> language = LexerSpiPackageAccessor.get().language(this.tokenHierarchyOperation.mutableTextInput());
        if (language != null) {
            this.setLanguagePath(LanguagePath.get(language));
            return true;
        }
        return false;
    }

    @Override
    public synchronized int tokenCount() {
        if (this.lexerInputOperation != null) {
            this.tokenOrEmbeddingImpl(Integer.MAX_VALUE);
        }
        return this.size();
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        int n = abstractToken.rawOffset();
        return n < this.offsetGapStart() ? n : n - this.offsetGapLength();
    }

    @Override
    public int tokenOffsetByIndex(int n) {
        return this.elementOffset(n);
    }

    @Override
    public int[] tokenIndex(int n) {
        return LexerUtilsConstants.tokenIndexLazyTokenCreation(this, n);
    }

    @Override
    public synchronized int modCount() {
        return this.rootModCount;
    }

    public void incrementModCount() {
        ++this.rootModCount;
    }

    @Override
    public synchronized TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        return this.tokenOrEmbeddingImpl(n);
    }

    private TokenOrEmbedding<T> tokenOrEmbeddingImpl(int n) {
        while (this.lexerInputOperation != null && n >= this.size()) {
            AbstractToken<T> abstractToken = this.lexerInputOperation.nextToken();
            if (abstractToken != null) {
                if (!abstractToken.isFlyweight()) {
                    abstractToken.setTokenList(this);
                }
                this.updateElementOffsetAdd(abstractToken);
                this.add(abstractToken);
                this.laState = this.laState.add(this.lexerInputOperation.lookahead(), this.lexerInputOperation.lexerState());
                continue;
            }
            this.releaseLexerInputOperation();
            this.trimToSize();
            this.laState.trimToSize();
        }
        return n < this.size() ? (TokenOrEmbedding)this.get(n) : null;
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken = ((TextToken)abstractToken).createCopy(this, this.offset2Raw(n2));
        this.set(n, textToken);
        return textToken;
    }

    @Override
    public synchronized void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        this.set(n, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return LexerSpiPackageAccessor.get().inputAttributes(this.tokenHierarchyOperation.mutableTextInput());
    }

    protected int elementRawOffset(TokenOrEmbedding<T> tokenOrEmbedding) {
        return tokenOrEmbedding.token().rawOffset();
    }

    protected void setElementRawOffset(TokenOrEmbedding<T> tokenOrEmbedding, int n) {
        tokenOrEmbedding.token().setRawOffset(n);
    }

    protected boolean isElementFlyweight(TokenOrEmbedding<T> tokenOrEmbedding) {
        return tokenOrEmbedding.embedding() == null && tokenOrEmbedding.token().isFlyweight();
    }

    protected int elementLength(TokenOrEmbedding<T> tokenOrEmbedding) {
        return tokenOrEmbedding.token().length();
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbeddingUnsync(int n) {
        return (TokenOrEmbedding)this.get(n);
    }

    @Override
    public int lookahead(int n) {
        return this.laState.lookahead(n);
    }

    @Override
    public Object state(int n) {
        return this.laState.state(n);
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public TokenList<?> rootTokenList() {
        return this;
    }

    @Override
    public CharSequence inputSourceText() {
        return this.inputSourceText;
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int n, int n2, Object object) {
        if (this.lexerInputOperation != null) {
            this.lexerInputOperation.release();
        }
        return new TextLexerInputOperation(this, n, object, n2, this.inputSourceText.length());
    }

    @Override
    public boolean isFullyLexed() {
        return this.lexerInputOperation == null;
    }

    @Override
    public void replaceTokens(TokenListChange<T> tokenListChange, TokenHierarchyEventInfo tokenHierarchyEventInfo, boolean bl) {
        AbstractToken abstractToken;
        Object object;
        int n;
        Object object2;
        int n2 = tokenListChange.index();
        int n3 = tokenListChange.removedTokenCount();
        AbstractToken abstractToken2 = null;
        if (n3 > 0) {
            object2 = new TokenOrEmbedding[n3];
            this.copyElements(n2, n2 + n3, (Object[])object2, 0);
            abstractToken2 = object2[0].token();
            for (n = 0; n < n3; ++n) {
                object = object2[n];
                abstractToken = object.token();
                if (abstractToken.isFlyweight()) continue;
                this.updateElementOffsetRemove(abstractToken);
                abstractToken.setTokenList(null);
                EmbeddingContainer embeddingContainer = object.embedding();
                if (embeddingContainer == null) continue;
                assert (embeddingContainer.cachedModCount() != this.rootModCount) : "ModCount already updated";
                embeddingContainer.markRemoved(abstractToken.rawOffset());
            }
            this.remove(n2, n3);
            this.laState.remove(n2, n3);
            tokenListChange.setRemovedTokens((TokenOrEmbedding<T>[])object2);
        } else {
            tokenListChange.setRemovedTokensEmpty();
        }
        if (this.offsetGapStart() != tokenListChange.offset()) {
            this.moveOffsetGap(tokenListChange.offset(), tokenListChange.index());
        }
        this.updateOffsetGapLength(-tokenHierarchyEventInfo.diffLength());
        object2 = tokenListChange.addedTokenOrEmbeddings();
        if (object2 != null && object2.size() > 0) {
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (TokenOrEmbedding)object3.next();
                abstractToken = object.token();
                if (!abstractToken.isFlyweight()) {
                    abstractToken.setTokenList(this);
                }
                this.updateElementOffsetAdd(abstractToken);
            }
            this.addAll(n2, (Collection)object2);
            this.laState = this.laState.addAll(n2, tokenListChange.laState());
            tokenListChange.syncAddedTokenCount();
            if (n3 == 1 && object2.size() == 1) {
                object3 = tokenListChange.addedTokenOrEmbeddings().get(0).token();
                if (abstractToken2.id() == ((AbstractToken)object3).id() && abstractToken2.partType() == ((AbstractToken)object3).partType()) {
                    tokenListChange.markBoundsChange();
                }
            }
        }
        if (this.lexerInputOperation != null) {
            n = this.tokenCountCurrent();
            this.lexerInputOperation = this.createLexerInputOperation(n, this.elementOrEndOffset(n), n > 0 ? this.state(n - 1) : null);
        }
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        return 0;
    }

    @Override
    public int endOffset() {
        return this.inputSourceText != null ? this.inputSourceText.length() : 0;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    public void setInputSourceText(CharSequence charSequence) {
        this.inputSourceText = charSequence;
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this).toString();
    }
}

