/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubSequenceTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenList<T> tokenList;
    private final int limitStartOffset;
    private final int limitEndOffset;
    private int limitStartIndex;
    private int limitEndIndex;

    public static <T extends TokenId> SubSequenceTokenList<T> create(TokenList<T> tokenList, int n, int n2) {
        return new SubSequenceTokenList<T>(tokenList, n, n2);
    }

    public SubSequenceTokenList(TokenList<T> tokenList, int n, int n2) {
        int[] nArray;
        this.tokenList = tokenList;
        this.limitStartOffset = n;
        this.limitEndOffset = n2;
        if (n2 == Integer.MAX_VALUE) {
            this.limitEndIndex = tokenList.tokenCount();
        } else {
            nArray = tokenList.tokenIndex(n2);
            this.limitEndIndex = nArray[0];
            if (this.limitEndIndex != -1) {
                if (n2 > nArray[1] && this.limitEndIndex < tokenList.tokenCountCurrent()) {
                    ++this.limitEndIndex;
                }
            } else {
                this.limitEndIndex = 0;
            }
        }
        if (this.limitEndIndex > 0 && n > 0) {
            nArray = tokenList.tokenIndex(n);
            this.limitStartIndex = nArray[0];
            if (this.limitStartIndex < tokenList.tokenCountCurrent() && nArray[1] + tokenList.tokenOrEmbedding(this.limitStartIndex).token().length() <= n) {
                ++this.limitStartIndex;
            }
        }
    }

    public TokenList<T> delegate() {
        return this.tokenList;
    }

    public int limitStartOffset() {
        return this.limitStartOffset;
    }

    public int limitEndOffset() {
        return this.limitEndOffset;
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        return (n += this.limitStartIndex) < this.limitEndIndex ? this.tokenList.tokenOrEmbedding(n) : null;
    }

    @Override
    public int tokenOffsetByIndex(int n) {
        if ((n += this.limitStartIndex) >= this.limitEndIndex) {
            throw new IndexOutOfBoundsException("index=" + n + " >= limitEndIndex=" + this.limitEndIndex);
        }
        return this.tokenList.tokenOffsetByIndex(n);
    }

    @Override
    public int[] tokenIndex(int n) {
        return LexerUtilsConstants.tokenIndexBinSearch(this, n, this.tokenCountCurrent());
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    @Override
    public int tokenCountCurrent() {
        return this.limitEndIndex - this.limitStartIndex;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        return this.tokenList.replaceFlyToken(n + this.limitStartIndex, abstractToken, n2);
    }

    @Override
    public int modCount() {
        return this.tokenList.modCount();
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        return this.tokenList.tokenOffset(abstractToken);
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        this.tokenList.wrapToken(this.limitStartIndex + n, embeddingContainer);
    }

    @Override
    public TokenList<?> rootTokenList() {
        return this.tokenList.rootTokenList();
    }

    @Override
    public CharSequence inputSourceText() {
        return this.rootTokenList().inputSourceText();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenList.tokenHierarchyOperation();
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    @Override
    public int lookahead(int n) {
        return this.tokenList.lookahead(n);
    }

    @Override
    public Object state(int n) {
        return this.tokenList.state(n);
    }

    @Override
    public boolean isContinuous() {
        return this.tokenList.isContinuous();
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffsetByIndex(0);
        }
        return this.limitStartOffset;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffsetByIndex(n) + this.tokenList.tokenOrEmbedding(n).token().length();
        }
        return this.limitStartOffset;
    }

    @Override
    public boolean isRemoved() {
        return this.tokenList.isRemoved();
    }
}

