/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.ArrayList;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchTokenList<T extends TokenId>
extends ArrayList<TokenOrEmbedding<T>>
implements TokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private static boolean maintainLAState;
    private final TokenHierarchyOperation<?, T> tokenHierarchyOperation;
    private final CharSequence inputSourceText;
    private final LanguagePath languagePath;
    private final Set<T> skipTokenIds;
    private final InputAttributes inputAttributes;
    private LexerInputOperation<T> lexerInputOperation;
    private LAState laState;

    public static boolean isMaintainLAState() {
        return maintainLAState;
    }

    public static void setMaintainLAState(boolean bl) {
        maintainLAState = bl;
    }

    public BatchTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation, CharSequence charSequence, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.inputSourceText = charSequence;
        this.languagePath = LanguagePath.get(language);
        this.skipTokenIds = set;
        this.inputAttributes = inputAttributes;
        if (testing) {
            this.laState = LAState.empty();
        }
        this.lexerInputOperation = this.createLexerInputOperation();
    }

    protected LexerInputOperation<T> createLexerInputOperation() {
        return new TextLexerInputOperation(this);
    }

    @Override
    public TokenList<?> rootTokenList() {
        return this;
    }

    @Override
    public CharSequence inputSourceText() {
        return this.inputSourceText;
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public synchronized int tokenCount() {
        if (this.lexerInputOperation != null) {
            this.tokenOrEmbeddingImpl(Integer.MAX_VALUE);
        }
        return this.size();
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        int n = abstractToken.rawOffset();
        return n;
    }

    @Override
    public int tokenOffsetByIndex(int n) {
        int n2;
        AbstractToken<T> abstractToken = this.existingToken(n);
        if (abstractToken.isFlyweight()) {
            n2 = 0;
            while (--n >= 0) {
                abstractToken = this.existingToken(n);
                n2 += abstractToken.length();
                if (abstractToken.isFlyweight()) continue;
                n2 += abstractToken.offset(null);
                break;
            }
        } else {
            n2 = abstractToken.offset(null);
        }
        return n2;
    }

    @Override
    public int[] tokenIndex(int n) {
        return LexerUtilsConstants.tokenIndexLazyTokenCreation(this, n);
    }

    @Override
    public synchronized TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        return this.tokenOrEmbeddingImpl(n);
    }

    private TokenOrEmbedding<T> tokenOrEmbeddingImpl(int n) {
        while (this.lexerInputOperation != null && n >= this.size()) {
            AbstractToken<T> abstractToken = this.lexerInputOperation.nextToken();
            if (abstractToken != null) {
                if (!abstractToken.isFlyweight()) {
                    abstractToken.setTokenList(this);
                }
                this.add(abstractToken);
                if (this.laState == null) continue;
                this.laState = this.laState.add(this.lexerInputOperation.lookahead(), this.lexerInputOperation.lexerState());
                continue;
            }
            this.lexerInputOperation.release();
            this.lexerInputOperation = null;
            this.trimToSize();
        }
        return n < this.size() ? (TokenOrEmbedding)this.get(n) : null;
    }

    private AbstractToken<T> existingToken(int n) {
        return ((TokenOrEmbedding)this.get(n)).token();
    }

    @Override
    public int lookahead(int n) {
        return this.laState != null ? this.laState.lookahead(n) : -1;
    }

    @Override
    public Object state(int n) {
        return this.laState != null ? this.laState.state(n) : null;
    }

    @Override
    public int startOffset() {
        return 0;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffsetByIndex(n) + this.tokenOrEmbeddingImpl(n).token().length();
        }
        return 0;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken = ((TextToken)abstractToken).createCopy(this, n2);
        this.set(n, textToken);
        return textToken;
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        this.set(n, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public boolean isContinuous() {
        return this.skipTokenIds == null;
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.skipTokenIds;
    }
}

