/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.glf;

import java.awt.Component;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.glf.GLFTemplateWizardPanel2;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;

public final class GLFTemplateWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new GLFTemplateWizardPanel2(this)};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", true);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", true);
                jComponent.putClientProperty("WizardPanel_contentNumbered", true);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles createdModifiedFiles = ((GLFTemplateWizardPanel2)this.panels[0]).getComponent().getCreatedModifiedFiles();
        createdModifiedFiles.run();
        return BasicWizardIterator.getCreatedFiles(createdModifiedFiles, Templates.getProject((WizardDescriptor)this.wizard));
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        System.out.println(wizardDescriptor);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    Project getProject() {
        return (Project)this.wizard.getProperty("project");
    }

    WizardDescriptor getWizardDescriptor() {
        return this.wizard;
    }
}

