/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class BasicConfVisualPanel
extends BasicVisualPanel.NewTemplatePanel {
    private boolean wasBundleUpdated;
    private boolean wasLayerUpdated;
    private boolean listenersAttached;
    private final DocumentListener cnbDL;
    private final DocumentListener layerDL;
    private final DocumentListener bundleDL;
    private final ActionListener layerAL;
    private JLabel bundle;
    private JTextField bundleValue;
    private JLabel cnbHint;
    private JLabel codeNameBase;
    private JTextField codeNameBaseValue;
    private JPanel confPanel;
    private JLabel displayName;
    private JTextField displayNameValue;
    private JLabel filler;
    private JCheckBox generateLayer;
    private JLabel layer;
    private JTextField layerValue;

    public BasicConfVisualPanel(NewModuleProjectData newModuleProjectData) {
        super(newModuleProjectData);
        this.initComponents();
        this.initAccessibility();
        this.cnbDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicConfVisualPanel.this.checkValues(true, false, false);
            }
        };
        if (this.isLibraryWizard()) {
            this.layer.setVisible(false);
            this.layerValue.setVisible(false);
            this.generateLayer.setVisible(false);
            this.layerDL = null;
            this.layerAL = null;
        } else {
            this.layerDL = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    BasicConfVisualPanel.this.wasLayerUpdated = true;
                    BasicConfVisualPanel.this.checkValues(false, false, true);
                }
            };
            this.layerAL = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BasicConfVisualPanel.this.checkValues(false, false, true);
                }
            };
        }
        this.bundleDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicConfVisualPanel.this.wasBundleUpdated = true;
                BasicConfVisualPanel.this.checkValues(false, true, false);
            }
        };
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_BasicConfVisualPanel"));
        this.bundleValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_BundleValue"));
        this.codeNameBaseValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_CodeNameBaseValue"));
        this.displayNameValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_DisplayNameValue"));
        this.layerValue.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_LayerValue"));
        this.generateLayer.getAccessibleContext().setAccessibleDescription(BasicConfVisualPanel.getMessage("ACS_CTL_GenerateLayer"));
    }

    private boolean checkCodeNameBase() {
        String string = this.getCodeNameBaseValue();
        if (string.length() == 0) {
            this.setInfo(BasicConfVisualPanel.getMessage("MSG_EmptyCNB"), false);
        } else if (!Util.isValidJavaFQN(string)) {
            this.setError(BasicConfVisualPanel.getMessage("MSG_InvalidCNB"));
        } else if (this.getData().isSuiteComponent() && this.cnbIsAlreadyInSuite(this.getData().getSuiteRoot(), string)) {
            this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"MSG_ComponentWithSuchCNBAlreadyInSuite", (Object)string));
        } else {
            String string2 = string.replace('.', '/');
            if (!this.wasBundleUpdated) {
                this.bundleValue.setText(string2 + "/Bundle.properties");
                this.wasBundleUpdated = false;
            }
            if (!this.wasLayerUpdated) {
                this.layerValue.setText(string2 + "/layer.xml");
                this.wasLayerUpdated = false;
            }
            if (this.getData().isNetBeansOrg()) {
                String string3 = ModuleList.abbreviate(string);
                String string4 = this.getData().getProjectName();
                if (!string4.equals(string3)) {
                    this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)"BasicConfVisualPanel_err_wrong_nborg_name", (Object)string3));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkBundle() {
        return this.checkEntry(this.getBundleValue(), "bundle", ".properties");
    }

    private boolean checkLayer() {
        String string = this.getLayerValue();
        this.layerValue.setEnabled(string != null);
        return string != null ? this.checkEntry(string, "layer", ".xml") : true;
    }

    private boolean checkEntry(String string, String string2, String string3) {
        if (string.length() == 0) {
            this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)("BasicConfVisualPanel_err_" + string2 + "_empty")));
            return false;
        }
        if (string.indexOf(47) == -1) {
            this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)("BasicConfVisualPanel_err_" + string2 + "_def_pkg")));
            return false;
        }
        if (!string.endsWith(string3)) {
            this.setError(NbBundle.getMessage(BasicConfVisualPanel.class, (String)("BasicConfVisualPanel_err_" + string2 + "_ext"), (Object)string3));
            return false;
        }
        return true;
    }

    private void checkValues(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (bl && !this.checkCodeNameBase()) {
            return;
        }
        if (bl2 && !this.checkBundle()) {
            return;
        }
        if (bl3 && !this.checkLayer()) {
            return;
        }
        if (!bl && !this.checkCodeNameBase()) {
            return;
        }
        if (!bl2 && !this.checkBundle()) {
            return;
        }
        if (!bl3 && !this.checkLayer()) {
            return;
        }
        this.markValid();
    }

    void refreshData() {
        String string = this.getData().getProjectDisplayName();
        this.displayNameValue.setText(string);
        this.checkValues(true, false, false);
    }

    void storeData() {
        this.getData().setCodeNameBase(this.getCodeNameBaseValue());
        this.getData().setProjectDisplayName(this.displayNameValue.getText());
        this.getData().setBundle(this.getBundleValue());
        this.getData().setLayer(this.getLayerValue());
    }

    private String getCodeNameBaseValue() {
        return this.codeNameBaseValue.getText().trim();
    }

    private String getBundleValue() {
        return this.bundleValue.getText().trim();
    }

    private String getLayerValue() {
        String string = this.layerValue.getText().trim();
        return this.generateLayer.isSelected() ? string : null;
    }

    private boolean cnbIsAlreadyInSuite(String string, String string2) {
        boolean bl = false;
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        try {
            Project project = ProjectManager.getDefault().findProject(fileObject);
            for (NbModuleProject nbModuleProject : SuiteUtils.getSubProjects(project)) {
                if (!ProjectUtils.getInformation((Project)nbModuleProject).getName().equals(string2)) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
        return bl;
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.codeNameBaseValue.getDocument().addDocumentListener(this.cnbDL);
            this.bundleValue.getDocument().addDocumentListener(this.bundleDL);
            if (!this.isLibraryWizard()) {
                this.layerValue.getDocument().addDocumentListener(this.layerDL);
                this.generateLayer.addActionListener(this.layerAL);
            }
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.codeNameBaseValue.getDocument().removeDocumentListener(this.cnbDL);
            this.bundleValue.getDocument().removeDocumentListener(this.bundleDL);
            if (!this.isLibraryWizard()) {
                this.layerValue.getDocument().removeDocumentListener(this.layerDL);
                this.generateLayer.removeActionListener(this.layerAL);
            }
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(BasicConfVisualPanel.class, (String)string);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.codeNameBase = new JLabel();
        this.displayName = new JLabel();
        this.bundle = new JLabel();
        this.layer = new JLabel();
        this.codeNameBaseValue = new JTextField();
        this.displayNameValue = new JTextField();
        this.bundleValue = new JTextField();
        this.layerValue = new JTextField();
        this.filler = new JLabel();
        this.cnbHint = new JLabel();
        this.generateLayer = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.codeNameBase.setLabelFor(this.codeNameBaseValue);
        Mnemonics.setLocalizedText((JLabel)this.codeNameBase, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_CodeNameBase"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 6, 12);
        this.confPanel.add((Component)this.codeNameBase, gridBagConstraints);
        this.displayName.setLabelFor(this.displayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.displayName, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_ModuleDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 12);
        this.confPanel.add((Component)this.displayName, gridBagConstraints);
        this.bundle.setLabelFor(this.bundleValue);
        Mnemonics.setLocalizedText((JLabel)this.bundle, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_LocalizingBundle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 5, 0, 12);
        this.confPanel.add((Component)this.bundle, gridBagConstraints);
        this.layer.setLabelFor(this.layerValue);
        Mnemonics.setLocalizedText((JLabel)this.layer, (String)NbBundle.getMessage(BasicConfVisualPanel.class, (String)"LBL_XMLLayer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 20, 0, 12);
        this.confPanel.add((Component)this.layer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 4, 0);
        this.confPanel.add((Component)this.codeNameBaseValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.confPanel.add((Component)this.displayNameValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.confPanel.add((Component)this.bundleValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.confPanel.add((Component)this.layerValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.cnbHint, (String)BasicConfVisualPanel.getMessage("LBL_CodeNameBaseHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.confPanel.add((Component)this.cnbHint, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.generateLayer, (String)BasicConfVisualPanel.getMessage("CTL_GenerateLayer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.confPanel.add((Component)this.generateLayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
    }
}

