/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIUtil {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/apisupport/project/resources/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/apisupport/project/resources/defaultFolderOpen.gif";
    private static Reference<JFileChooser> iconChooser;

    private UIUtil() {
    }

    public static String keyToLogicalString(KeyStroke keyStroke) {
        String string = Utilities.keyToString((KeyStroke)keyStroke);
        int n = string.indexOf(45);
        return n == -1 ? string : string.substring(0, n).replace('C', 'D').replace('A', 'O') + string.substring(n);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x80) > 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n & 0x200) > 0) {
            stringBuffer.append("Alt+");
        }
        if ((n & 0x40) > 0) {
            stringBuffer.append("Shift+");
        }
        if ((n & 0x100) > 0) {
            stringBuffer.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuffer.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return stringBuffer.toString();
    }

    public static KeyStroke stringToKeyStroke(String string) {
        KeyStroke keyStroke;
        int n = 0;
        if (string.startsWith("Ctrl+")) {
            n |= 0x80;
            string = string.substring(5);
        }
        if (string.startsWith("Alt+")) {
            n |= 0x200;
            string = string.substring(4);
        }
        if (string.startsWith("Shift+")) {
            n |= 0x40;
            string = string.substring(6);
        }
        if (string.startsWith("Meta+")) {
            n |= 0x100;
            string = string.substring(5);
        }
        if ((keyStroke = Utilities.stringToKey((String)string)) == null) {
            return null;
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n);
        return keyStroke2;
    }

    public static KeyStroke[] stringToKeyStrokes(String string) {
        String string2 = " ";
        if (string.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = UIUtil.stringToKeyStroke(string3);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static String keyStrokesToString(KeyStroke[] keyStrokeArray) {
        StringBuffer stringBuffer = new StringBuffer(UIUtil.keyStrokeToString(keyStrokeArray[0]));
        int n = keyStrokeArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(' ').append(UIUtil.keyStrokeToString(keyStrokeArray[i]));
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static String keyStrokesToLogicalString(KeyStroke[] keyStrokeArray) {
        StringBuffer stringBuffer = new StringBuffer(UIUtil.keyToLogicalString(keyStrokeArray[0]));
        int n = keyStrokeArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(' ').append(UIUtil.keyToLogicalString(keyStrokeArray[i]));
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static void setProjectChooserDir(File file) {
        if (file == null || !file.isDirectory()) {
            return;
        }
        ProjectChooser.setProjectsFolder((File)file);
    }

    public static void setProjectChooserDirParent(File file) {
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        UIUtil.setProjectChooserDir(file2 != null ? file2 : (file.isDirectory() ? file : null));
    }

    public static void setText(JTextComponent jTextComponent, String string) {
        jTextComponent.setText(string);
        jTextComponent.setCaretPosition(string == null ? 0 : string.length());
    }

    public static String getIconDimensionWarning(File file, int n, int n2) {
        Dimension dimension = new Dimension(UIUtil.getIconDimension(file));
        if (dimension.height == n2 && dimension.width == n) {
            return "";
        }
        return NbBundle.getMessage(UIUtil.class, (String)"MSG_WrongIconSize", (Object[])new Object[]{dimension.width, dimension.height, n, n2});
    }

    public static String getNoIconSelectedWarning(int n, int n2) {
        return NbBundle.getMessage(UIUtil.class, (String)"MSG_NoIconSelected", (Object)n, (Object)n2);
    }

    public static boolean isValidIcon(File file, int n, int n2) {
        Dimension dimension = UIUtil.getIconDimension(file);
        return (double)n == dimension.getWidth() && (double)n2 == dimension.getHeight();
    }

    public static Dimension getIconDimension(File file) {
        try {
            ImageIcon imageIcon = new ImageIcon(file.toURI().toURL());
            return new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
            return new Dimension(-1, -1);
        }
    }

    public static JFileChooser getIconFileChooser() {
        JFileChooser jFileChooser;
        if (iconChooser != null && (jFileChooser = iconChooser.get()) != null) {
            return jFileChooser;
        }
        jFileChooser = new IconFileChooser();
        iconChooser = new WeakReference<JFileChooser>(jFileChooser);
        return jFileChooser;
    }

    public static JFileChooser getIconFileChooser(String string) {
        File file;
        JFileChooser jFileChooser = UIUtil.getIconFileChooser();
        String string2 = string.trim();
        if (string2.length() > 0 && (file = new File(string2)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        return jFileChooser;
    }

    public static JComboBox createPackageComboBox(SourceGroup sourceGroup) {
        JComboBox jComboBox = new JComboBox(PackageView.createListView((SourceGroup)sourceGroup));
        jComboBox.setRenderer(PackageView.listRenderer());
        return jComboBox;
    }

    public static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public static String generateTextAreaContent(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String string) {
        return UIUtil.createLayerPresenterComboModel(project, string, Collections.<String, Object>emptyMap());
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String string, Map<String, Object> map) {
        DefaultComboBoxModel<LayerItemPresenter> defaultComboBoxModel = new DefaultComboBoxModel<LayerItemPresenter>();
        try {
            FileSystem fileSystem = LayerUtils.getEffectiveSystemFilesystem(project);
            FileObject fileObject = fileSystem.getRoot().getFileObject(string);
            if (fileObject != null) {
                TreeSet<LayerItemPresenter> treeSet = new TreeSet<LayerItemPresenter>();
                for (FileObject object : UIUtil.getFolders(fileObject, map)) {
                    treeSet.add(new LayerItemPresenter(object, fileObject));
                }
                for (LayerItemPresenter layerItemPresenter : treeSet) {
                    defaultComboBoxModel.addElement(layerItemPresenter);
                }
            }
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
        return defaultComboBoxModel;
    }

    public static String getSFSPath(JComboBox jComboBox, String string) {
        String string2;
        Object object = jComboBox.getEditor().getItem();
        String string3 = null;
        if (object instanceof LayerItemPresenter) {
            string3 = ((LayerItemPresenter)object).getFullPath();
        } else if (object instanceof String && (string2 = ((String)object).trim()).length() > 0 && (string3 = UIUtil.searchLIPCategoryCombo(jComboBox, string2)) == null) {
            string3 = string2.startsWith(string) ? string2 : string + '/' + string2;
        }
        return string3;
    }

    public static NbModuleProject chooseSuiteComponent(Component component, SuiteProject suiteProject) {
        NbModuleProject nbModuleProject = null;
        Project project = UIUtil.chooseProject(component);
        if (project != null) {
            NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
            if (nbModuleProvider == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UIUtil.class, (String)"MSG_TryingToAddNonNBModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            } else if (SuiteUtils.getSubProjects(suiteProject).contains(project)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UIUtil.class, (String)"MSG_SuiteAlreadyContainsProject", (Object)ProjectUtils.getInformation((Project)suiteProject).getDisplayName(), (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            } else if (nbModuleProvider.getModuleType() == NbModuleProvider.SUITE_COMPONENT) {
                Object[] objectArray = new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), UIUtil.getSuiteProjectName(project), UIUtil.getSuiteProjectDirectory(project), ProjectUtils.getInformation((Project)suiteProject).getDisplayName()};
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UIUtil.class, (String)"MSG_MoveFromSuiteToSuite", (Object[])objectArray), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() == NotifyDescriptor.OK_OPTION) {
                    nbModuleProject = (NbModuleProject)project;
                }
            } else if (nbModuleProvider.getModuleType() == NbModuleProvider.STANDALONE) {
                nbModuleProject = (NbModuleProject)project;
            } else if (nbModuleProvider.getModuleType() == NbModuleProvider.NETBEANS_ORG) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UIUtil.class, (String)"MSG_TryingToAddNBORGModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
        }
        return nbModuleProject;
    }

    public static ListCellRenderer createProjectRenderer() {
        return new ProjectRenderer();
    }

    public static Image getTreeFolderIcon(boolean bl) {
        Image image = null;
        Icon icon = UIManager.getIcon(bl ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (icon != null) {
            image = Utilities.icon2Image((Icon)icon);
        } else {
            image = (Image)UIManager.get(bl ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (image == null) {
                image = Utilities.loadImage((String)(bl ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
            }
        }
        assert (image != null);
        return image;
    }

    public static NbModuleProject runLibraryWrapperWizard(Project project) {
        NewNbModuleWizardIterator newNbModuleWizardIterator = NewNbModuleWizardIterator.createLibraryModuleIterator(project);
        return UIUtil.runProjectWizard(newNbModuleWizardIterator, "CTL_NewLibraryWrapperProject");
    }

    public static NbModuleProject runProjectWizard(NewNbModuleWizardIterator newNbModuleWizardIterator, String string) {
        boolean bl;
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)newNbModuleWizardIterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(UIUtil.class, (String)string));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        NbModuleProject nbModuleProject = null;
        boolean bl2 = bl = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            FileObject fileObject = newNbModuleWizardIterator.getCreateProjectFolder();
            try {
                nbModuleProject = (NbModuleProject)ProjectManager.getDefault().findProject(fileObject);
                OpenProjects.getDefault().open(new Project[]{nbModuleProject}, false);
                if (wizardDescriptor.getProperty("setAsMain") == Boolean.TRUE) {
                    OpenProjects.getDefault().setMainProject((Project)nbModuleProject);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return nbModuleProject;
    }

    private static String searchLIPCategoryCombo(JComboBox jComboBox, String string) {
        String string2 = null;
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            LayerItemPresenter layerItemPresenter;
            Object e = jComboBox.getItemAt(i);
            if (!(e instanceof LayerItemPresenter) || !string.equals((layerItemPresenter = (LayerItemPresenter)jComboBox.getItemAt(i)).getDisplayName())) continue;
            string2 = layerItemPresenter.getFullPath();
            break;
        }
        return string2;
    }

    private static Project chooseProject(Component component) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        int n = jFileChooser.showOpenDialog(component);
        Project project = null;
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            UIUtil.setProjectChooserDirParent(file);
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
        return project;
    }

    private static File getSuiteDirectory(Project project) {
        File file = SuiteUtils.getSuiteDirectory(project);
        assert (file != null) : "Invalid suite provider for: " + project.getProjectDirectory();
        return file;
    }

    private static String getSuiteProjectDirectory(Project project) {
        return UIUtil.getSuiteDirectory(project).getAbsolutePath();
    }

    private static String getSuiteProjectName(Project project) {
        FileObject fileObject = FileUtil.toFileObject((File)UIUtil.getSuiteDirectory(project));
        if (fileObject == null) {
            return "???";
        }
        return Util.getDisplayName(fileObject);
    }

    private static Collection<FileObject> getFolders(FileObject fileObject, Map<String, Object> map) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        block0: for (FileObject fileObject2 : NbCollections.iterable((Enumeration)fileObject.getFolders(false))) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (!entry.getValue().equals(fileObject2.getAttribute(entry.getKey()))) continue;
                continue block0;
            }
            hashSet.add(fileObject2);
            hashSet.addAll(UIUtil.getFolders(fileObject2, map));
        }
        return hashSet;
    }

    public static boolean showAcceptCancelDialog(String string, String string2, String string3, String string4, int n) {
        return UIUtil.showAcceptCancelDialog(string, string2, string3, null, string4, n);
    }

    public static boolean showAcceptCancelDialog(String string, String string2, String string3, String string4, String string5, int n) {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string2, string);
        dialogDescriptor.setModal(true);
        JButton jButton = new JButton(string3);
        jButton.setDefaultCapable(true);
        if (string4 != null) {
            jButton.getAccessibleContext().setAccessibleDescription(string4);
        }
        dialogDescriptor.setOptions(new Object[]{jButton, string5 != null ? new JButton(string5) : NotifyDescriptor.CANCEL_OPTION});
        dialogDescriptor.setMessageType(n);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(jButton);
    }

    private static class IconFileChooser
    extends JFileChooser {
        private final JTextField iconInfo = new JTextField();

        private IconFileChooser() {
            JPanel jPanel = IconFileChooser.getAccesoryPanel(this.iconInfo);
            this.setDialogTitle(NbBundle.getMessage(UIUtil.class, (String)"TITLE_IconDialog"));
            this.setAccessory(jPanel);
            this.setAcceptAllFileFilterUsed(false);
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            this.addChoosableFileFilter(new IconFilter());
            this.setFileView(new FileView(){

                public Icon getIcon(File file) {
                    ImageIcon imageIcon;
                    if ((file.getName().endsWith(".gif") || file.getName().endsWith(".png")) && (imageIcon = new ImageIcon(file.getAbsolutePath())).getIconWidth() == 16 && imageIcon.getIconHeight() == 16) {
                        return imageIcon;
                    }
                    return null;
                }

                public String getName(File file) {
                    File file2 = IconFileChooser.this.getSelectedFile();
                    if (file2 != null && (file2.getName().endsWith(".gif") || file2.getName().endsWith(".png"))) {
                        ImageIcon imageIcon = new ImageIcon(file2.getAbsolutePath());
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(file2.getName()).append(" [");
                        stringBuffer.append(imageIcon.getIconWidth()).append('x').append(imageIcon.getIconHeight());
                        stringBuffer.append(']');
                        IconFileChooser.this.setApproveButtonToolTipText(stringBuffer.toString());
                        IconFileChooser.this.iconInfo.setText(stringBuffer.toString());
                    } else {
                        IconFileChooser.this.iconInfo.setText("");
                    }
                    return super.getName(file);
                }
            });
        }

        private static JPanel getAccesoryPanel(JTextField jTextField) {
            jTextField.setColumns(15);
            jTextField.setEditable(false);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JLabel jLabel = new JLabel();
            jPanel.setLayout(new FlowLayout(0, 6, 0));
            jPanel2.setLayout(new GridLayout(2, 1, 0, 6));
            jLabel.setLabelFor(jTextField);
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(UIUtil.class, (String)"LBL_IconInfo"));
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
            jPanel.add(jPanel2);
            return jPanel;
        }
    }

    private static final class IconFilter
    extends FileFilter {
        private IconFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase(Locale.ENGLISH).endsWith("gif") || file.getName().toLowerCase(Locale.ENGLISH).endsWith("png");
        }

        public String getDescription() {
            return "*.gif, *.png";
        }
    }

    private static class ProjectRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ProjectRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = null;
            if (!(object instanceof Project)) {
                string = object.toString();
            } else {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                string = projectInformation.getDisplayName();
                this.setIcon(projectInformation.getIcon());
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayerItemPresenter
    implements Comparable<LayerItemPresenter> {
        private String displayName;
        private final FileObject item;
        private final FileObject root;
        private final boolean contentType;

        public LayerItemPresenter(FileObject fileObject, FileObject fileObject2, boolean bl) {
            this.item = fileObject;
            this.root = fileObject2;
            this.contentType = bl;
        }

        public LayerItemPresenter(FileObject fileObject, FileObject fileObject2) {
            this(fileObject, fileObject2, false);
        }

        public FileObject getFileObject() {
            return this.item;
        }

        public String getFullPath() {
            return this.item.getPath();
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.computeDisplayName();
            }
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public int compareTo(LayerItemPresenter layerItemPresenter) {
            int n = Collator.getInstance().compare(this.getDisplayName(), layerItemPresenter.getDisplayName());
            if (n != 0) {
                return n;
            }
            return this.getFullPath().compareTo(layerItemPresenter.getFullPath());
        }

        private static String getFileObjectName(FileObject fileObject) {
            String string = null;
            try {
                string = fileObject.getFileSystem().getStatus().annotateName(fileObject.getNameExt(), Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = fileObject.getName();
            }
            return string;
        }

        private String computeDisplayName() {
            FileObject fileObject = this.contentType ? this.item.getParent() : this.item;
            String string = this.contentType ? "/" : " | ";
            Stack<String> stack = new Stack<String>();
            stack.push(LayerItemPresenter.getFileObjectName(fileObject));
            FileObject fileObject2 = fileObject.getParent();
            while (!this.root.getPath().equals(fileObject2.getPath())) {
                stack.push(LayerItemPresenter.getFileObjectName(fileObject2));
                fileObject2 = fileObject2.getParent();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((String)stack.pop());
            while (!stack.empty()) {
                stringBuffer.append(string).append((String)stack.pop());
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class DocumentAdapter
    implements DocumentListener {
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(null);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(null);
        }
    }
}

