/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.ModulesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.PlatformNode;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class LibrariesNode
extends AbstractNode {
    static final String LIBRARIES_NAME = "libraries";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/apisupport/project/ui/resources/jar.gif";
    private static final String DISPLAY_NAME = LibrariesNode.getMessage("LBL_libraries");
    static final RequestProcessor RP = new RequestProcessor();
    private final Action[] actions;

    public LibrariesNode(NbModuleProject nbModuleProject) {
        super((Children)new LibrariesChildren(nbModuleProject));
        this.setName(LIBRARIES_NAME);
        this.setDisplayName(DISPLAY_NAME);
        this.actions = Util.getModuleType(nbModuleProject) == NbModuleProvider.SUITE_COMPONENT ? new Action[]{new AddModuleDependencyAction(nbModuleProject), new ModulesNodeFactory.AddNewLibraryWrapperAction(nbModuleProject, nbModuleProject)} : new Action[]{new AddModuleDependencyAction(nbModuleProject)};
    }

    public Image getIcon(int n) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean bl) {
        Image image = Utilities.loadImage((String)"org/netbeans/modules/apisupport/project/ui/resources/libraries-badge.png", (boolean)true);
        return Utilities.mergeImages((Image)UIUtil.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
    }

    public Action[] getActions(boolean bl) {
        return this.actions;
    }

    private static String createHtmlDescription(ModuleDependency moduleDependency) {
        StringBuffer stringBuffer = new StringBuffer("<html><u>" + moduleDependency.getModuleEntry().getCodeNameBase() + "</u><br>");
        if (moduleDependency.hasImplementationDepedendency()) {
            stringBuffer.append("<br><font color=\"red\">" + LibrariesNode.getMessage("CTL_ImplementationDependency") + "</font>");
        }
        if (moduleDependency.hasCompileDependency()) {
            stringBuffer.append("<br>").append(LibrariesNode.getMessage("CTL_NeededToCompile"));
        }
        if (moduleDependency.getReleaseVersion() != null) {
            stringBuffer.append("<br>").append(NbBundle.getMessage(LibrariesNode.class, (String)"CTL_MajorReleaseVersion", (Object)moduleDependency.getReleaseVersion()));
        }
        if (moduleDependency.getSpecificationVersion() != null) {
            stringBuffer.append("<br>").append(NbBundle.getMessage(LibrariesNode.class, (String)"CTL_SpecificationVersion", (Object)moduleDependency.getSpecificationVersion()));
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(LibrariesNode.class, (String)string);
    }

    private static void removeDependency(NbModuleProject nbModuleProject, ModuleDependency moduleDependency) throws IOException {
        new ProjectXMLManager(nbModuleProject).removeDependencies(Collections.singleton(moduleDependency));
        ProjectManager.getDefault().saveProject((Project)nbModuleProject);
    }

    private static final class RemoveAction
    extends DeleteAction {
        private RemoveAction() {
        }

        public String getName() {
            return LibrariesNode.getMessage("CTL_RemoveDependency");
        }

        protected void initialize() {
            super.initialize();
            this.putValue("AcceleratorKey", ((DeleteAction)SystemAction.get(DeleteAction.class)).getValue("AcceleratorKey"));
        }
    }

    static final class OpenProjectAction
    extends CookieAction {
        OpenProjectAction() {
        }

        protected void performAction(Node[] nodeArray) {
            block6: {
                try {
                    final Project[] projectArray = new Project[nodeArray.length];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        ModuleEntry moduleEntry = (ModuleEntry)nodeArray[i].getLookup().lookup(ModuleEntry.class);
                        assert (moduleEntry != null);
                        File file = moduleEntry.getSourceLocation();
                        assert (file != null);
                        Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
                        assert (project != null);
                        projectArray[i] = project;
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            StatusDisplayer.getDefault().setStatusText(LibrariesNode.getMessage("MSG_OpeningProjects"));
                            OpenProjects.getDefault().open(projectArray, false);
                        }
                    });
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)iOException);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }

        public String getName() {
            return LibrariesNode.getMessage("CTL_Open");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{ModuleDependency.class, TestModuleDependency.class};
        }
    }

    private static final class ShowJavadocAction
    extends AbstractAction {
        private final ModuleDependency dep;
        private final NbModuleProject project;
        private URL currectJavadoc;

        ShowJavadocAction(ModuleDependency moduleDependency, NbModuleProject nbModuleProject) {
            super(LibrariesNode.getMessage("CTL_ShowJavadoc"));
            this.dep = moduleDependency;
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.currectJavadoc);
        }

        public boolean isEnabled() {
            this.currectJavadoc = Util.getModuleType(this.project) == NbModuleProvider.NETBEANS_ORG ? Util.findJavadocForNetBeansOrgModules(this.dep) : Util.findJavadoc(this.dep, this.project.getPlatform(true));
            return this.currectJavadoc != null;
        }
    }

    private static final class EditDependencyAction
    extends AbstractAction {
        private final NbModuleProject project;
        private final String codeNameBase;

        EditDependencyAction(String string, NbModuleProject nbModuleProject) {
            super(LibrariesNode.getMessage("CTL_EditDependency"));
            this.codeNameBase = string;
            this.project = nbModuleProject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
            ModuleDependency moduleDependency = null;
            Window window = null;
            try {
                SuiteProvider suiteProvider = (SuiteProvider)this.project.getLookup().lookup(SuiteProvider.class);
                if (suiteProvider == null) {
                    ErrorManager.getDefault().log("Cannot get suite for module: " + this.project.getCodeNameBase());
                    return;
                }
                ModuleList.refreshSuiteModuleList(suiteProvider.getSuiteDirectory());
                ModuleDependency moduleDependency2 = projectXMLManager.getModuleDependency(this.codeNameBase);
                EditDependencyPanel editDependencyPanel = new EditDependencyPanel(moduleDependency2, NbPlatform.getPlatformByDestDir(moduleDependency2.getModuleEntry().getDestDir()));
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editDependencyPanel, NbBundle.getMessage(LibrariesNode.class, (String)"CTL_EditModuleDependencyTitle", (Object)moduleDependency2.getModuleEntry().getLocalizedName()));
                dialogDescriptor.setHelpCtx(new HelpCtx(EditDependencyPanel.class));
                window = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                ((Dialog)window).setVisible(true);
                if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    moduleDependency = editDependencyPanel.getEditedDependency();
                    TreeSet<ModuleDependency> treeSet = new TreeSet<ModuleDependency>(projectXMLManager.getDirectDependencies());
                    treeSet.remove(moduleDependency2);
                    treeSet.add(moduleDependency);
                    projectXMLManager.replaceDependencies(treeSet);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
            }
            catch (IOException iOException) {
                if (moduleDependency != null) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Cannot store dependency: " + moduleDependency);
                } else {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Cannot get dependency for module: " + this.codeNameBase);
                }
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                if (window != null) {
                    window.dispose();
                }
            }
        }
    }

    private static final class AddModuleDependencyAction
    extends AbstractAction {
        private final NbModuleProject project;

        AddModuleDependencyAction(NbModuleProject nbModuleProject) {
            super(LibrariesNode.getMessage("CTL_AddModuleDependency"));
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SingleModuleProperties singleModuleProperties = SingleModuleProperties.getInstance(this.project);
            ModuleDependency[] moduleDependencyArray = AddModulePanel.selectDependencies(singleModuleProperties);
            ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
            try {
                for (ModuleDependency moduleDependency : moduleDependencyArray) {
                    projectXMLManager.addDependency(moduleDependency);
                }
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, "Cannot add selected dependencies: " + Arrays.asList(moduleDependencyArray));
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private static final class LibraryDependencyNode
    extends FilterNode {
        private final ModuleDependency dep;
        private final NbModuleProject project;

        LibraryDependencyNode(ModuleDependency moduleDependency, NbModuleProject nbModuleProject, Node node) {
            super(node, null, (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.fixed((Object[])new Object[]{moduleDependency, nbModuleProject})}));
            this.dep = moduleDependency;
            this.project = nbModuleProject;
            this.setShortDescription(LibrariesNode.createHtmlDescription(moduleDependency));
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{new EditDependencyAction(this.dep.getModuleEntry().getCodeNameBase(), this.project), SystemAction.get(FindAction.class), new ShowJavadocAction(this.dep, this.project), SystemAction.get(RemoveAction.class)};
        }

        public Action getPreferredAction() {
            return new EditDependencyAction(this.dep.getModuleEntry().getCodeNameBase(), this.project);
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            LibrariesNode.removeDependency(this.project, this.dep);
        }
    }

    private static final class ProjectDependencyNode
    extends AbstractNode {
        private final ModuleDependency dep;
        private final NbModuleProject project;

        ProjectDependencyNode(ModuleDependency moduleDependency, NbModuleProject nbModuleProject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{moduleDependency, nbModuleProject, moduleDependency.getModuleEntry()}));
            this.dep = moduleDependency;
            this.project = nbModuleProject;
            ModuleEntry moduleEntry = moduleDependency.getModuleEntry();
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            this.setDisplayName(moduleEntry.getLocalizedName());
            this.setShortDescription(LibrariesNode.createHtmlDescription(moduleDependency));
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(OpenProjectAction.class), new EditDependencyAction(this.dep.getModuleEntry().getCodeNameBase(), this.project), new ShowJavadocAction(this.dep, this.project), SystemAction.get(RemoveAction.class)};
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            LibrariesNode.removeDependency(this.project, this.dep);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LibrariesChildren
    extends Children.Keys<Object>
    implements AntProjectListener {
        private static final String JDK_PLATFORM_NAME = "jdkPlatform";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";
        private final NbModuleProject project;
        private ImageIcon librariesIcon;

        LibrariesChildren(NbModuleProject nbModuleProject) {
            this.project = nbModuleProject;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
            super.removeNotify();
        }

        private void refreshKeys() {
            RP.post(new Runnable(){

                public void run() {
                    try {
                        ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                            public Void run() throws IOException {
                                ProjectXMLManager projectXMLManager = new ProjectXMLManager(LibrariesChildren.this.project);
                                final ArrayList<Object> arrayList = new ArrayList<Object>();
                                arrayList.add(LibrariesChildren.JDK_PLATFORM_NAME);
                                TreeSet<String> treeSet = new TreeSet<String>();
                                treeSet.addAll(Arrays.asList(projectXMLManager.getBinaryOrigins()));
                                arrayList.addAll(treeSet);
                                TreeSet<ModuleDependency> treeSet2 = new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR);
                                treeSet2.addAll(projectXMLManager.getDirectDependencies());
                                arrayList.addAll(treeSet2);
                                RP.post(new Runnable(){

                                    public void run() {
                                        LibrariesChildren.this.setKeys(Collections.unmodifiableList(arrayList));
                                    }
                                });
                                return null;
                            }
                        });
                    }
                    catch (MutexException mutexException) {
                        Logger.getLogger(LibrariesNode.class.getName()).log(Level.FINE, null, mutexException);
                    }
                }
            });
        }

        protected Node[] createNodes(Object object) {
            Object object2;
            if (object == JDK_PLATFORM_NAME) {
                object2 = PlatformNode.create(this.project.evaluator(), "nbjdk.home");
            } else if (object instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)object;
                File file = moduleDependency.getModuleEntry().getSourceLocation();
                if (file == null) {
                    File file2 = moduleDependency.getModuleEntry().getJarLocation();
                    URL uRL = FileUtil.urlForArchiveOrDir((File)file2);
                    assert (uRL != null);
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    ModuleEntry moduleEntry = moduleDependency.getModuleEntry();
                    String string = moduleEntry.getLocalizedName() + " - " + moduleEntry.getCodeNameBase();
                    Icon icon = this.getLibrariesIcon();
                    ActionFilterNode actionFilterNode = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(fileObject, string, icon, icon)));
                    object2 = new LibraryDependencyNode(moduleDependency, this.project, (Node)actionFilterNode);
                } else {
                    object2 = new ProjectDependencyNode(moduleDependency, this.project);
                }
            } else {
                File file = this.project.getHelper().resolveFile((String)object);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    return null;
                }
                Icon icon = this.getLibrariesIcon();
                FileObject fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject);
                String string = String.format(LibrariesNode.getMessage("LBL_WrappedLibraryFmt"), FileUtil.toFile((FileObject)fileObject).getName());
                object2 = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(fileObject2, string, icon, icon)));
            }
            assert (object2 != null);
            return new Node[]{object2};
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            if (this.project.getHelper().resolveFileObject("nbproject/project.xml") != null) {
                this.refreshKeys();
            }
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        private Icon getLibrariesIcon() {
            if (this.librariesIcon == null) {
                this.librariesIcon = new ImageIcon(Utilities.loadImage((String)LIBRARIES_ICON, (boolean)true));
            }
            return this.librariesIcon;
        }
    }
}

