/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.BadgingSupport;
import org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tax.parser.XMLParsingSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.io.TreeStreamResult;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Task;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerUtils {
    private static final Map<Project, LayerHandle> layerHandleCache = new WeakHashMap<Project, LayerHandle>();
    private static final Set<String> XML_LIKE_TYPES = new HashSet<String>();

    private LayerUtils() {
    }

    static URL[] currentify(URL uRL, String string, ClassPath classPath) {
        if (classPath == null) {
            return new URL[]{uRL};
        }
        try {
            if (uRL.getProtocol().equals("nbres")) {
                FileObject fileObject;
                String string2 = uRL.getFile();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                if ((fileObject = classPath.findResource(string2)) != null) {
                    return new URL[]{fileObject.getURL()};
                }
            } else if (uRL.getProtocol().equals("nbresloc")) {
                String string3;
                String string4;
                String string5;
                String string6;
                int n;
                ArrayList<URL> arrayList = new ArrayList<URL>();
                String string7 = uRL.getFile();
                if (string7.startsWith("/")) {
                    string7 = string7.substring(1);
                }
                if ((n = string7.lastIndexOf(47)) == -1) {
                    string6 = "";
                    string5 = string7;
                } else {
                    string6 = string7.substring(0, n + 1);
                    string5 = string7.substring(n + 1);
                }
                n = string5.lastIndexOf(46);
                if (n == -1) {
                    string4 = string5;
                    string3 = "";
                } else {
                    string4 = string5.substring(0, n);
                    string3 = string5.substring(n);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>(LayerUtils.computeSubVariants(string));
                arrayList2.add(string);
                Collections.reverse(arrayList2);
                for (String string8 : arrayList2) {
                    String string9 = string6 + string4 + string8 + string3;
                    FileObject fileObject = classPath.findResource(string9);
                    if (fileObject == null) continue;
                    arrayList.add(fileObject.getURL());
                }
                if (!arrayList.isEmpty()) {
                    return arrayList.toArray(new URL[arrayList.size()]);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Util.err.notify(16, (Throwable)fileStateInvalidException);
        }
        return new URL[]{uRL};
    }

    private static List<String> computeSubVariants(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return Collections.emptyList();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        List<String> list = LayerUtils.computeSubVariants(string2, string3);
        return list.subList(0, list.size() - 1);
    }

    private static List<String> computeSubVariants(String string, String string2) {
        int n = string2.indexOf(95, 1);
        if (n == -1) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            linkedList.add(string + string2);
            return linkedList;
        }
        String string3 = string2.substring(n);
        List<String> list = LayerUtils.computeSubVariants(string, string3);
        List<String> list2 = LayerUtils.computeSubVariants(string + string2.substring(0, n), string3);
        LinkedList<String> linkedList = new LinkedList<String>(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public static LayerHandle layerForProject(Project project) {
        LayerHandle layerHandle = layerHandleCache.get(project);
        if (layerHandle == null) {
            layerHandle = new LayerHandle(project, null);
            layerHandleCache.put(project, layerHandle);
        }
        return layerHandle;
    }

    public static String findGeneratedName(FileObject fileObject, String string) {
        String string2;
        Matcher matcher = Pattern.compile("(.+/)?([^/.]+)(\\.[^/]+)?").matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        if (string4 == null) {
            string4 = "";
        } else if (string4.equals(".java")) {
            string4 = "_java";
        } else if (XML_LIKE_TYPES.contains(string4)) {
            string2 = string4.substring(1, 2).toUpperCase(Locale.ENGLISH);
            string3 = string3 + string2 + string4.substring(2);
            string4 = ".xml";
        }
        string2 = string3 + string4;
        if (fileObject == null || fileObject.getFileObject(string2) == null) {
            return string2;
        }
        int n = 1;
        while (fileObject.getFileObject(string2 = string3 + '_' + n + string4) != null) {
            ++n;
        }
        return string2;
    }

    static SavableTreeEditorCookie cookieForFile(FileObject fileObject) {
        return new CookieImpl(fileObject);
    }

    public static FileSystem getEffectiveSystemFilesystem(Project project) throws IOException {
        NbModuleProvider.NbModuleType nbModuleType = Util.getModuleType(project);
        FileSystem fileSystem = LayerUtils.layerForProject(project).layer(false);
        if (nbModuleType == NbModuleProvider.STANDALONE) {
            Set<File> set = LayerUtils.getPlatformJarsForStandaloneProject(project);
            FileSystem[] fileSystemArray = LayerUtils.getPlatformLayers(set);
            ClassPath classPath = LayerUtils.createLayerClasspath(Collections.singleton(project), set);
            return LayerUtils.mergeFilesystems(fileSystem, fileSystemArray, classPath);
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            NbModuleProject nbModuleProject2;
            SuiteProject suiteProject = SuiteUtils.findSuite(project);
            if (suiteProject == null) {
                throw new IOException("Could not load suite for " + project);
            }
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
            Set<NbModuleProject> set = SuiteUtils.getSubProjects(suiteProject);
            for (NbModuleProject nbModuleProject2 : set) {
                LayerHandle layerHandle;
                FileSystem fileSystem2;
                if (nbModuleProject2 == project || (fileSystem2 = (layerHandle = LayerUtils.layerForProject(nbModuleProject2)).layer(false)) == null) continue;
                arrayList.add(fileSystem2);
            }
            Set<File> set2 = LayerUtils.getPlatformJarsForSuiteComponentProject(project, suiteProject);
            arrayList.addAll(Arrays.asList(LayerUtils.getPlatformLayers(set2)));
            nbModuleProject2 = LayerUtils.createLayerClasspath(set, set2);
            return LayerUtils.mergeFilesystems(fileSystem, arrayList.toArray(new FileSystem[arrayList.size()]), (ClassPath)nbModuleProject2);
        }
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            XMLFileSystem xMLFileSystem;
            NbModuleProject nbModuleProject4;
            Set<NbModuleProject> set;
            block8: {
                NbModuleProject nbModuleProject3 = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class);
                set = LayerUtils.getProjectsForNetBeansOrgProject(nbModuleProject3);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                for (NbModuleProject nbModuleProject4 : set) {
                    FileObject fileObject;
                    FileObject fileObject2;
                    ManifestManager manifestManager;
                    String string;
                    if (nbModuleProject4.getManifest() == null || (string = (manifestManager = ManifestManager.getInstance(nbModuleProject4.getManifest(), false)).getLayer()) == null || (fileObject2 = nbModuleProject4.getSourceDirectory()) == null || (fileObject = fileObject2.getFileObject(string)) == null) continue;
                    arrayList.add(fileObject.getURL());
                }
                xMLFileSystem = new XMLFileSystem();
                try {
                    xMLFileSystem.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                }
                catch (PropertyVetoException propertyVetoException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)propertyVetoException);
                }
            }
            nbModuleProject4 = LayerUtils.createLayerClasspath(set, Collections.<File>emptySet());
            return LayerUtils.mergeFilesystems(fileSystem, new FileSystem[]{xMLFileSystem}, (ClassPath)nbModuleProject4);
        }
        throw new AssertionError((Object)nbModuleType);
    }

    public static Set<File> getPlatformJarsForStandaloneProject(Project project) {
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        NbPlatform nbPlatform = null;
        File file = nbModuleProvider.getActivePlatformLocation();
        if (file != null) {
            nbPlatform = NbPlatform.getPlatformByDestDir(file);
        }
        if (nbPlatform == null || !nbPlatform.isValid()) {
            nbPlatform = NbPlatform.getDefaultPlatform();
        }
        return LayerUtils.getPlatformJars(nbPlatform, null, null, null);
    }

    public static Set<File> getPlatformJarsForSuiteComponentProject(Project project, SuiteProject suiteProject) {
        NbPlatform nbPlatform = suiteProject.getPlatform(true);
        PropertyEvaluator propertyEvaluator = suiteProject.getEvaluator();
        String[] stringArray = SuiteProperties.getArrayProperty(propertyEvaluator, "enabled.clusters");
        String[] stringArray2 = SuiteProperties.getArrayProperty(propertyEvaluator, "disabled.clusters");
        String[] stringArray3 = SuiteProperties.getArrayProperty(propertyEvaluator, "disabled.modules");
        return LayerUtils.getPlatformJars(nbPlatform, stringArray, stringArray2, stringArray3);
    }

    public static Set<NbModuleProject> getProjectsForNetBeansOrgProject(NbModuleProject nbModuleProject) throws IOException {
        ModuleList moduleList = nbModuleProject.getModuleList();
        HashSet<NbModuleProject> hashSet = new HashSet<NbModuleProject>();
        hashSet.add(nbModuleProject);
        for (ModuleEntry moduleEntry : moduleList.getAllEntriesSoft()) {
            if (moduleEntry.getClusterDirectory().getName().equals("extra")) continue;
            File file = moduleEntry.getSourceLocation();
            assert (file != null) : moduleEntry;
            NbModuleProject nbModuleProject2 = (NbModuleProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            if (nbModuleProject2 == null) continue;
            hashSet.add(nbModuleProject2);
        }
        return hashSet;
    }

    private static Set<File> getPlatformJars(NbPlatform nbPlatform, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (nbPlatform == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = stringArray != null ? new HashSet<String>(Arrays.asList(stringArray)) : Collections.emptySet();
        HashSet<String> hashSet2 = stringArray2 != null ? new HashSet<String>(Arrays.asList(stringArray2)) : Collections.emptySet();
        HashSet<String> hashSet3 = stringArray3 != null ? new HashSet<String>(Arrays.asList(stringArray3)) : Collections.emptySet();
        ModuleEntry[] moduleEntryArray = nbPlatform.getModules();
        HashSet<File> hashSet4 = new HashSet<File>(moduleEntryArray.length);
        for (ModuleEntry moduleEntry : moduleEntryArray) {
            if (SingleModuleProperties.isExcluded(moduleEntry, hashSet3, hashSet, hashSet2)) continue;
            hashSet4.add(moduleEntry.getJarLocation());
        }
        return hashSet4;
    }

    private static FileSystem[] getPlatformLayers(Set<File> set) throws IOException {
        ArrayList<XMLFileSystem> arrayList = new ArrayList<XMLFileSystem>();
        block2: for (File file : set) {
            ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(file);
            for (String string : manifestManager.getRequiredTokens()) {
                if (string.startsWith("org.openide.modules.os.")) continue block2;
            }
            String string = manifestManager.getLayer();
            if (string == null) continue;
            URL uRL = new URL("jar:" + file.toURI() + "!/" + string);
            try {
                XMLFileSystem xMLFileSystem = new XMLFileSystem(uRL);
                boolean bl = false;
                Enumeration enumeration = xMLFileSystem.getRoot().getChildren(true);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject = (FileObject)enumeration.nextElement();
                    if (!fileObject.getNameExt().endsWith("_hidden")) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    arrayList.add(0, xMLFileSystem);
                    continue;
                }
                arrayList.add(xMLFileSystem);
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
            }
        }
        return arrayList.toArray(new FileSystem[arrayList.size()]);
    }

    static ClassPath createLayerClasspath(Set<? extends Project> set, Set<File> set2) throws IOException {
        Object object;
        Object object2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Project object3 : set) {
            object2 = (NbModuleProvider)object3.getLookup().lookup(NbModuleProvider.class);
            object = object2.getSourceDirectory();
            if (object == null) continue;
            arrayList.add(object.getURL());
        }
        for (File file : set2) {
            arrayList.add(FileUtil.getArchiveRoot((URL)file.toURI().toURL()));
            object2 = new File(file.getParentFile(), "locale");
            if (!((File)object2).isDirectory()) continue;
            object = file.getName();
            int n = ((String)object).lastIndexOf(46);
            if (n == -1) {
                n = ((String)object).length();
            }
            String string = ((String)object).substring(0, n);
            String string2 = ((String)object).substring(n);
            String[] stringArray = ((File)object2).list();
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string) || !stringArray[i].endsWith(string2) || stringArray[i].charAt(n) != '_') continue;
                arrayList.add(FileUtil.getArchiveRoot((URL)new File((File)object2, stringArray[i]).toURI().toURL()));
            }
        }
        return ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
    }

    private static FileSystem mergeFilesystems(FileSystem fileSystem, FileSystem[] fileSystemArray, final ClassPath classPath) {
        if (fileSystem == null) {
            fileSystem = new XMLFileSystem();
        }
        final FileSystem[] fileSystemArray2 = new FileSystem[fileSystemArray.length + 1];
        fileSystemArray2[0] = fileSystem;
        System.arraycopy(fileSystemArray, 0, fileSystemArray2, 1, fileSystemArray.length);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BadgingMergedFileSystem
        extends MultiFileSystem {
            private final BadgingSupport status;

            public BadgingMergedFileSystem() {
                super(fileSystemArray);
                this.status = new BadgingSupport((FileSystem)this);
                this.status.setClasspath(classPath);
                this.status.setSuffix("_" + Locale.getDefault());
            }

            public FileSystem.Status getStatus() {
                return this.status;
            }
        }
        return new BadgingMergedFileSystem();
    }

    static {
        XML_LIKE_TYPES.add(".settings");
        XML_LIKE_TYPES.add(".wstcref");
        XML_LIKE_TYPES.add(".wsmode");
        XML_LIKE_TYPES.add(".wsgrp");
        XML_LIKE_TYPES.add(".wsmgr");
    }

    public static final class LayerHandle {
        private final Project project;
        private final FileObject layerXML;
        private FileSystem fs;
        private SavableTreeEditorCookie cookie;
        private boolean autosave;

        LayerHandle(Project project, FileObject fileObject) {
            this.project = project;
            this.layerXML = fileObject;
        }

        public synchronized FileSystem layer(boolean bl) {
            if (this.fs == null) {
                FileObject fileObject = this.getLayerFile();
                if (fileObject == null) {
                    if (!bl) {
                        return null;
                    }
                    try {
                        String string;
                        NbModuleProvider nbModuleProvider = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
                        FileObject fileObject2 = nbModuleProvider.getManifestFile();
                        if (fileObject2 != null && (string = ManifestManager.getInstance(Util.getManifest(fileObject2), false).getLayer()) == null) {
                            string = this.newLayerPath();
                            EditableManifest editableManifest = Util.loadManifest(fileObject2);
                            editableManifest.setAttribute("OpenIDE-Module-Layer", string, null);
                            Util.storeManifest(fileObject2, editableManifest);
                        }
                        fileObject = NbModuleProjectGenerator.createLayer(this.project.getProjectDirectory(), nbModuleProvider.getResourceDirectoryPath(false) + '/' + this.newLayerPath());
                    }
                    catch (IOException iOException) {
                        Util.err.notify(1, (Throwable)iOException);
                        this.fs = FileUtil.createMemoryFileSystem();
                        return this.fs;
                    }
                }
                try {
                    this.cookie = LayerUtils.cookieForFile(fileObject);
                    this.fs = new WritableXMLFileSystem(fileObject.getURL(), this.cookie, null);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    throw new AssertionError((Object)fileStateInvalidException);
                }
                this.cookie.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (LayerHandle.this.autosave && "dirty".equals(propertyChangeEvent.getPropertyName())) {
                            try {
                                LayerHandle.this.save();
                            }
                            catch (IOException iOException) {
                                Util.err.notify(1, (Throwable)iOException);
                            }
                        }
                    }
                });
            }
            return this.fs;
        }

        public void save() throws IOException {
            if (this.cookie == null) {
                throw new IOException("Cannot save a nonexistent layer");
            }
            this.cookie.save();
        }

        public FileObject getLayerFile() {
            if (this.layerXML != null) {
                return this.layerXML;
            }
            NbModuleProvider nbModuleProvider = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
            if (nbModuleProvider == null) {
                return null;
            }
            Manifest manifest = Util.getManifest(nbModuleProvider.getManifestFile());
            if (manifest == null) {
                return null;
            }
            String string = ManifestManager.getInstance(manifest, false).getLayer();
            if (string == null) {
                return null;
            }
            return Util.getResourceDirectory(this.project).getFileObject(string);
        }

        public void setAutosave(boolean bl) {
            this.autosave = bl;
            if (bl && this.cookie != null) {
                try {
                    this.cookie.save();
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                }
            }
        }

        public boolean isAutosave() {
            return this.autosave;
        }

        private String newLayerPath() {
            String string;
            NbModuleProvider nbModuleProvider = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
            FileObject fileObject = nbModuleProvider.getManifestFile();
            if (fileObject != null && (string = ManifestManager.getInstance(Util.getManifest(fileObject), false).getLocalizingBundle()) != null) {
                return string.replaceFirst("/[^/]+$", "/layer.xml");
            }
            return nbModuleProvider.getCodeNameBase().replace('.', '/') + "/layer.xml";
        }

        public String toString() {
            FileObject fileObject = this.getLayerFile();
            if (fileObject != null) {
                return FileUtil.getFileDisplayName((FileObject)fileObject);
            }
            return FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
        }
    }

    private static final class CookieImpl
    implements SavableTreeEditorCookie,
    FileChangeListener,
    FileSystem.AtomicAction {
        private TreeDocumentRoot root;
        private boolean dirty;
        private Exception problem;
        private final FileObject f;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public CookieImpl(FileObject fileObject) {
            this.f = fileObject;
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }

        public TreeDocumentRoot getDocumentRoot() {
            return this.root;
        }

        public int getStatus() {
            if (this.problem != null) {
                return 3;
            }
            if (this.root != null) {
                return 1;
            }
            return 0;
        }

        public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
            if (this.root == null && this.f.isValid()) {
                try {
                    boolean bl = this.dirty;
                    int n = this.getStatus();
                    this.root = new XMLParsingSupport().parse(new InputSource(this.f.getURL().toExternalForm()));
                    this.problem = null;
                    this.dirty = false;
                    this.pcs.firePropertyChange("dirty", bl, false);
                    this.pcs.firePropertyChange("status", n, 1);
                }
                catch (IOException iOException) {
                    this.problem = iOException;
                    throw iOException;
                }
                catch (TreeException treeException) {
                    this.problem = treeException;
                    throw treeException;
                }
                ((TreeObject)this.root).addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        CookieImpl.this.modified();
                    }
                });
            }
            return this.root;
        }

        public Task prepareDocumentRoot() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        private void modified() {
            if (!this.dirty) {
                this.dirty = true;
                this.pcs.firePropertyChange("dirty", false, true);
            }
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public synchronized void save() throws IOException {
            if (this.root == null || !this.dirty) {
                return;
            }
            this.f.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            this.dirty = false;
            this.pcs.firePropertyChange("dirty", true, false);
        }

        public void run() throws IOException {
            OutputStream outputStream = this.f.getOutputStream();
            try {
                new TreeStreamResult(outputStream).getWriter(this.root).writeDocument();
            }
            catch (TreeException treeException) {
                throw (IOException)new IOException(treeException.toString()).initCause(treeException);
            }
            finally {
                outputStream.close();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.changed(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.changed(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.changed((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            assert (false);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            assert (false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed(FileEvent fileEvent) {
            CookieImpl cookieImpl = this;
            synchronized (cookieImpl) {
                if (fileEvent.firedFrom((FileSystem.AtomicAction)this)) {
                    return;
                }
                this.problem = null;
                this.dirty = false;
                this.root = null;
            }
            this.pcs.firePropertyChange("documentRoot", null, null);
        }
    }

    static interface SavableTreeEditorCookie
    extends TreeEditorCookie {
        public static final String PROP_DIRTY = "dirty";

        public boolean isDirty();

        public void save() throws IOException;
    }
}

