/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.search.impl.output;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import org.netbeans.modules.xml.search.api.SearchElement;
import org.netbeans.modules.xml.search.api.SearchEvent;
import org.netbeans.modules.xml.search.impl.output.Element;
import org.netbeans.modules.xml.search.impl.output.Tabbed;
import org.netbeans.modules.xml.search.impl.output.Tree;
import org.netbeans.modules.xml.search.spi.SearchListener;
import org.netbeans.modules.xml.ui.UI;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class View
extends TopComponent
implements SearchListener {
    private Tree myList;
    private Tree myTree;
    private Tabbed myTabbed;
    private int myFoundCount;
    public static final String NAME = "search";

    public View() {
        this.setIcon(UI.icon(View.class, "find").getImage());
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.myList = new Tree();
        this.myTree = new Tree();
    }

    public void searchStarted(SearchEvent searchEvent) {
        this.myFoundCount = 0;
    }

    public void searchFound(SearchEvent searchEvent) {
        SearchElement searchElement = searchEvent.getSearchElement();
        this.myTree.addElement(searchElement);
        this.myList.addElement(new Element(searchElement));
        ++this.myFoundCount;
    }

    public void searchFinished(SearchEvent searchEvent) {
        String string = searchEvent.getSearchOption().getText();
        String string2 = searchEvent.getSearchOption().getTarget().toString();
        this.myList.finished(string2, string, this.myFoundCount);
        this.myTree.finished(string2, string, this.myFoundCount);
        View view = (View)WindowManager.getDefault().findTopComponent(NAME);
        view.show(this.myList, this.myTree);
    }

    private void show(Tree tree, Tree tree2) {
        this.createTabbed();
        this.myTabbed.addTrees(tree, tree2);
        this.open();
        this.requestActive();
    }

    private void createTabbed() {
        if (this.myTabbed != null) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.myTabbed = new Tabbed();
        this.add(this.myTabbed, gridBagConstraints);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return UI.i18n(View.class, "LBL_Search_Results");
    }

    public String getToolTipText() {
        return UI.i18n(View.class, "TLT_Search_Results");
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.myTabbed != null) {
            this.myTabbed.closeAllTabs();
        }
        this.myList = null;
        this.myTree = null;
    }

    protected String preferredID() {
        return NAME;
    }
}

