/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.io.File;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.builtin.IRubyObject;

final class Util {
    private static final CharSequence JRUBY_BUILTIN_PATH_PART = "builtin" + File.separator + "javasupport";
    private static final CharSequence JRUBY_JAR_PART = "lib" + File.separator + "jruby.jar!" + File.separator;

    private Util() {
    }

    static RubyBoolean toRBoolean(IRubyObject ro, boolean value) {
        return RubyBoolean.newBoolean((Ruby)ro.getRuntime(), (boolean)value);
    }

    static IRubyObject nil(IRubyObject ro) {
        return ro.getRuntime().getNil();
    }

    static String relativizeToPWD(String path) {
        return Util.relativizeFile(System.getProperty("user.dir"), path);
    }

    static String relativizeFile(String base, String filepath) {
        String result = filepath;
        if (filepath.startsWith(base)) {
            result = filepath.substring(base.length() + 1);
        }
        return result;
    }

    static boolean areSameFiles(String first, String second) {
        try {
            String firstF = new File(first).getCanonicalPath();
            String secondF = new File(second).getCanonicalPath();
            return firstF.equals(secondF);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot resolve cannocical path", ioe);
        }
    }

    static void logEvent(int event, String file, int line, String methodName, IRubyObject klass) {
        System.err.printf("%s:%d [%s] %s#%s\n", file, line, EventHook.EVENT_NAMES[event], klass, methodName);
    }

    static boolean isJRubyCore(String file) {
        return file.contains(JRUBY_BUILTIN_PATH_PART) || file.contains(JRUBY_JAR_PART);
    }
}

