/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg.input;

import java.util.Vector;
import org.netbeans.microedition.svg.SVGAbstractButton;
import org.netbeans.microedition.svg.SVGComponent;

public abstract class InputHandler {
    public static final int UP = -1;
    public static final int DOWN = -2;
    public static final int LEFT = -3;
    public static final int RIGHT = -4;
    public static final int FIRE = -5;
    public static final int BACKSPACE = -8;
    protected final Vector caretListeners = new Vector(1);
    protected Boolean prevVisibility = null;
    public static final InputHandler BUTTON_INPUT_HANDLER = new InputHandler(){

        public boolean handleKeyPress(SVGComponent comp, int nKeyCode) {
            if (comp instanceof SVGAbstractButton && nKeyCode == -5) {
                ((SVGAbstractButton)comp).pressButton();
                return true;
            }
            return false;
        }

        public boolean handleKeyRelease(SVGComponent comp, int nKeyCode) {
            if (comp instanceof SVGAbstractButton && nKeyCode == -5) {
                ((SVGAbstractButton)comp).releaseButton();
                return true;
            }
            return false;
        }
    };

    public abstract boolean handleKeyPress(SVGComponent var1, int var2);

    public abstract boolean handleKeyRelease(SVGComponent var1, int var2);

    public void addVisibilityListener(CaretVisibilityListener listener) {
        this.caretListeners.addElement(listener);
    }

    public void removeVisibilityListener(CaretVisibilityListener listener) {
        this.caretListeners.removeElement(listener);
    }

    protected void fireCaretVisibilityChanged(boolean isVisible) {
        if (this.prevVisibility == null || this.prevVisibility != isVisible) {
            int listenerNum = this.caretListeners.size();
            for (int i = 0; i < listenerNum; ++i) {
                ((CaretVisibilityListener)this.caretListeners.elementAt(i)).setCaretVisible(isVisible);
            }
            this.prevVisibility = new Boolean(isVisible);
        }
    }

    public static interface CaretVisibilityListener {
        public void setCaretVisible(boolean var1);
    }
}

