/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGLabel;
import org.netbeans.microedition.svg.SVGPlayer;
import org.netbeans.microedition.svg.SVGTextArea;
import org.netbeans.microedition.svg.SVGTextField;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.NumPadInputHandler;
import org.w3c.dom.svg.SVGElement;

public class SVGForm
extends SVGPlayer
implements InputHandler.CaretVisibilityListener {
    private final Vector components = new Vector();
    private SVGComponent focusedComponent = null;
    private NumPadInputHandler inputHandler;

    public SVGForm(SVGImage svgImage, Display display) throws IllegalArgumentException {
        super(svgImage, display);
        this.setResetAnimationWhenStopped(false);
        this.setSVGEventListener(new SvgFormEventListener());
        this.setFullScreenMode(true);
    }

    public void add(SVGComponent component) {
        this.components.addElement(component);
        if (this.components.size() == 1) {
            component.requestFocus();
        }
    }

    public SVGComponent getFocusedField() {
        return this.focusedComponent;
    }

    synchronized void requestFocus(SVGComponent comp) {
        if (this.focusedComponent != comp) {
            if (this.focusedComponent != null) {
                this.focusedComponent.focusLost();
            }
            this.focusedComponent = comp;
            if (this.focusedComponent != null) {
                this.getSVGImage().focusOn((SVGElement)this.focusedComponent.getElement());
                this.focusedComponent.focusGained();
            } else {
                this.getSVGImage().focusOn(null);
            }
        }
    }

    public void activate(SVGComponent comp) {
        this.requestFocus(comp);
        this.getSVGImage().activate();
    }

    public void setCaretVisible(boolean isVisible) {
        if (this.focusedComponent instanceof SVGTextField) {
            ((SVGTextField)this.focusedComponent).setCaretVisible(isVisible);
        }
        if (this.focusedComponent instanceof SVGTextArea) {
            ((SVGTextArea)this.focusedComponent).setCaretVisible(isVisible);
        }
    }

    public synchronized NumPadInputHandler getNumPadInputHandler() {
        if (this.inputHandler == null) {
            this.inputHandler = new NumPadInputHandler(this.getDisplay());
            this.inputHandler.addVisibilityListener(this);
        }
        return this.inputHandler;
    }

    SVGLabel getLabelFor(SVGComponent component) {
        Enumeration en = this.components.elements();
        while (en.hasMoreElements()) {
            SVGLabel label;
            SVGComponent labelFor;
            SVGComponent comp = (SVGComponent)en.nextElement();
            if (!(comp instanceof SVGLabel) || (labelFor = (label = (SVGLabel)comp).getLabelFor()) != component) continue;
            return label;
        }
        return null;
    }

    private class SvgFormEventListener
    implements SVGEventListener {
        private SvgFormEventListener() {
        }

        public void keyPressed(int keyCode) {
            if (SVGForm.this.focusedComponent != null) {
                System.out.println("Pressed: " + keyCode + " [" + (char)keyCode + "]");
                switch (keyCode) {
                    case -1: {
                        int index = SVGForm.this.components.indexOf(SVGForm.this.focusedComponent);
                        if (--index < 0) {
                            index = SVGForm.this.components.size() - 1;
                        }
                        SVGForm.this.requestFocus((SVGComponent)SVGForm.this.components.elementAt(index));
                        break;
                    }
                    case -2: {
                        int index = SVGForm.this.components.indexOf(SVGForm.this.focusedComponent);
                        if (++index >= SVGForm.this.components.size()) {
                            index = 0;
                        }
                        SVGForm.this.requestFocus((SVGComponent)SVGForm.this.components.elementAt(index));
                        break;
                    }
                    default: {
                        InputHandler handler = SVGForm.this.focusedComponent.getInputHandler();
                        if (handler == null) break;
                        handler.handleKeyPress(SVGForm.this.focusedComponent, keyCode);
                    }
                }
            }
        }

        public void keyReleased(int keyCode) {
            InputHandler handler;
            if (SVGForm.this.focusedComponent != null && (handler = SVGForm.this.focusedComponent.getInputHandler()) != null) {
                handler.handleKeyRelease(SVGForm.this.focusedComponent, keyCode);
            }
        }

        public void pointerPressed(int x, int y) {
        }

        public void pointerReleased(int x, int y) {
        }

        public void hideNotify() {
        }

        public void showNotify() {
        }

        public void sizeChanged(int width, int height) {
        }
    }

    public static interface FocusListener {
        public void focusGained();

        public void focusLost();
    }
}

