/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.activesync;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.netbeans.mobility.activesync.ActiveSyncException;
import org.netbeans.mobility.activesync.DeviceConnectedListener;
import org.netbeans.mobility.activesync.RemoteFile;
import org.netbeans.mobility.activesync.RemoteFileInputStream;
import org.netbeans.mobility.activesync.RemoteProcess;

public class ActiveSyncOps {
    private static ActiveSyncOps activeSyncOps = null;
    private static boolean isAvaliable = false;
    private Object lock = new Object();
    private Vector listeners = new Vector();

    private ActiveSyncOps() {
        this.nInit();
    }

    public static ActiveSyncOps getDefault() {
        if (!ActiveSyncOps.isAvailable()) {
            return null;
        }
        if (activeSyncOps == null) {
            activeSyncOps = new ActiveSyncOps();
        }
        return activeSyncOps;
    }

    public static boolean isAvailable() {
        if (!isAvaliable) {
            try {
                System.loadLibrary("nbactivesync");
                isAvaliable = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                isAvaliable = false;
            }
        }
        return isAvaliable;
    }

    public boolean isDeviceConnected() throws ActiveSyncException {
        return this.nIsDeviceConnected();
    }

    public void addConnectionListener(DeviceConnectedListener deviceConnectedListener) throws ActiveSyncException, IllegalArgumentException {
        if (deviceConnectedListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.listeners.add(deviceConnectedListener);
    }

    public void removeConnectionListener(DeviceConnectedListener deviceConnectedListener) throws ActiveSyncException, IllegalArgumentException {
        if (deviceConnectedListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.listeners.remove(deviceConnectedListener);
    }

    public String getConnectedDeviceName() throws ActiveSyncException {
        return this.nGetDeviceName();
    }

    public String getConnectedDeviceOSName() throws ActiveSyncException {
        return this.nGetOSName();
    }

    public String getConnectedDeviceOSVersion() throws ActiveSyncException {
        return this.nGetOSVersion();
    }

    public Dimension getScreenSize() throws ActiveSyncException {
        int[] nArray = new int[2];
        if (this.nGetScreenSize(nArray)) {
            return new Dimension(nArray[0], nArray[1]);
        }
        return null;
    }

    public RemoteFile[] getRootFilesystems() throws ActiveSyncException {
        return this.nGetRootFilesystems();
    }

    public RemoteFile getTempDirectory() throws ActiveSyncException {
        return this.nGetTempDirectory();
    }

    public RemoteFile getHomeDirectory() throws ActiveSyncException {
        return this.nGetRootFilesystems()[0];
    }

    public long getFreeDiskSpace(RemoteFile remoteFile) throws ActiveSyncException, IllegalArgumentException {
        if (remoteFile == null) {
            throw new IllegalArgumentException("null directory");
        }
        return this.nGetFreeDiskSpace(remoteFile.getFullPath());
    }

    public RemoteFile[] listFiles(RemoteFile remoteFile) throws ActiveSyncException, IllegalArgumentException {
        return this.nListFiles(remoteFile.getFullPath());
    }

    public RemoteFile[] listFiles(String string) throws ActiveSyncException, IllegalArgumentException {
        if (!RemoteFile.isRemoteDirName(string)) {
            throw new IllegalArgumentException("bad directory name");
        }
        return this.nListFiles(string);
    }

    public void copyToDevice(File file, RemoteFile remoteFile) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("can't copy directory to device");
        }
        String string = file.getAbsolutePath();
        String string2 = remoteFile.getFullPath();
        if (remoteFile.isDirectory()) {
            string2 = string2 + "\\" + file.getName();
        }
        this.nCopyToDevice(string, string2);
    }

    public void copyFromDevice(RemoteFile remoteFile, File file) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (remoteFile.isDirectory()) {
            throw new IllegalArgumentException("can't copy directory from the device");
        }
        String string = remoteFile.getFullPath();
        String string2 = file.getAbsolutePath();
        if (file.isDirectory()) {
            string2 = string2 + "\\" + remoteFile.getName();
        }
        this.nCopyFromDevice(string, string2);
    }

    public void copy(RemoteFile remoteFile, RemoteFile remoteFile2) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (remoteFile == null) {
            throw new IllegalArgumentException("null source file");
        }
        if (remoteFile2 == null) {
            throw new IllegalArgumentException("null target file");
        }
        if (remoteFile2.isDirectory()) {
            this.nCopy(remoteFile.getFullPath(), remoteFile2.getFullPath() + "\\" + remoteFile.getName());
        } else {
            this.nCopy(remoteFile.getFullPath(), remoteFile2.getFullPath());
        }
    }

    public void move(RemoteFile remoteFile, RemoteFile remoteFile2) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (remoteFile == null) {
            throw new IllegalArgumentException("null source file");
        }
        if (remoteFile2 == null) {
            throw new IllegalArgumentException("null target file");
        }
        if (remoteFile2.isDirectory()) {
            this.nMove(remoteFile.getFullPath(), remoteFile2.getFullPath() + "\\" + remoteFile.getName());
        } else {
            this.nMove(remoteFile.getFullPath(), remoteFile2.getFullPath());
        }
    }

    public void delete(RemoteFile remoteFile) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (remoteFile == null) {
            throw new IllegalArgumentException("null file");
        }
        this.nDelete(remoteFile.getFullPath());
    }

    public RemoteFile createEmptyFile(String string, String string2) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (!RemoteFile.isRemoteDirName(string)) {
            throw new IllegalArgumentException("bad directory name");
        }
        if (!RemoteFile.isRemoteFileName(string2)) {
            throw new IllegalArgumentException("bad file name");
        }
        if (string.endsWith("\\")) {
            return this.nCreateEmptyFile(string + string2);
        }
        return this.nCreateEmptyFile(string + "\\" + string2);
    }

    public RemoteFile createNewDirectory(String string, String string2) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (!RemoteFile.isRemoteDirName(string)) {
            throw new IllegalArgumentException("bad parent directory name");
        }
        if (!RemoteFile.isRemoteFileName(string2)) {
            throw new IllegalArgumentException("bad new directory name");
        }
        if (string.endsWith("\\")) {
            return this.nCreateNewDirectory(string + string2);
        }
        return this.nCreateNewDirectory(string + "\\" + string2);
    }

    public InputStream getRemoteInputStream(RemoteFile remoteFile) throws IOException, ActiveSyncException, IllegalArgumentException {
        if (remoteFile == null) {
            throw new IllegalArgumentException("bad file name");
        }
        return new RemoteFileInputStream(remoteFile);
    }

    public RemoteProcess[] listRunningProcesses() throws ActiveSyncException {
        Vector vector = RemoteProcess.getAll();
        if (vector.size() == 0) {
            return new RemoteProcess[0];
        }
        RemoteProcess[] remoteProcessArray = vector.toArray(new RemoteProcess[0]);
        for (int i = 0; i < remoteProcessArray.length; ++i) {
            if (this.isRunning(remoteProcessArray[i])) continue;
            vector.remove(i);
        }
        return ((Vector)vector.clone()).toArray(new RemoteProcess[0]);
    }

    public boolean isRunning(RemoteProcess remoteProcess) throws ActiveSyncException {
        return this.nIsRunning(remoteProcess.getPdata());
    }

    public boolean destroyRemoteProcess(RemoteProcess remoteProcess) throws ActiveSyncException, IllegalArgumentException {
        return this.nTerminate(remoteProcess.getPdata());
    }

    public RemoteProcess executeRemoteProcess(String string, String[] stringArray) throws ActiveSyncException, IOException, IllegalArgumentException {
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("empty executable string");
        }
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + " ";
                string2 = string2 + stringArray[i];
            }
        }
        RemoteProcess remoteProcess = this.nExecuteRemoteProcess(string, string2);
        remoteProcess.setExecutable(string);
        remoteProcess.setCmdArgs(stringArray);
        return remoteProcess;
    }

    public int waitFor(RemoteProcess remoteProcess) throws ActiveSyncException, IOException, IllegalArgumentException {
        return this.nWaitFot(remoteProcess.getPdata());
    }

    private void notifyConnection(boolean bl) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DeviceConnectedListener)this.listeners.get(i)).onDeviceConnected(bl);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private native void nInit();

    private native boolean nIsDeviceConnected() throws ActiveSyncException;

    private native String nGetOSName() throws ActiveSyncException;

    private native String nGetOSVersion() throws ActiveSyncException;

    private native String nGetDeviceName() throws ActiveSyncException;

    private native int nGetFreeDiskSpace(String var1) throws ActiveSyncException;

    private native boolean nGetScreenSize(int[] var1);

    private native RemoteFile[] nGetRootFilesystems();

    private native RemoteFile nGetTempDirectory() throws ActiveSyncException;

    private native RemoteFile[] nListFiles(String var1) throws ActiveSyncException, IllegalArgumentException;

    private native RemoteFile nCreateEmptyFile(String var1) throws ActiveSyncException;

    private native RemoteFile nCreateNewDirectory(String var1) throws ActiveSyncException;

    private native void nCopyToDevice(String var1, String var2) throws IOException, ActiveSyncException, IllegalArgumentException;

    private native void nCopyFromDevice(String var1, String var2) throws IOException, ActiveSyncException, IllegalArgumentException;

    private native void nCopy(String var1, String var2);

    private native void nMove(String var1, String var2);

    private native void nDelete(String var1);

    private native RemoteProcess nExecuteRemoteProcess(String var1, String var2) throws ActiveSyncException, IOException, IllegalArgumentException;

    private native boolean nIsRunning(int var1) throws ActiveSyncException;

    private native boolean nTerminate(int var1) throws ActiveSyncException;

    private native int nWaitFot(int var1) throws ActiveSyncException;
}

