/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import java.util.HashSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class NoIdClassOnEntitySubclass
extends JPAClassRule {
    public NoIdClassOnEntitySubclass() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.ENTITY));
    }

    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        TypeMirror typeMirror;
        Entity entity = (Entity)problemContext.getModelElement();
        if (entity.getIdClass() == null && (typeMirror = typeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
            Entity entity2 = ModelUtils.getEntity(((JPAProblemContext)problemContext).getMetaData(), typeElement2);
            if (entity2 != null) {
                HashSet<String> hashSet = new HashSet<String>(1);
                for (Id id : entity2.getAttributes().getId()) {
                    hashSet.add(id.getName());
                }
                for (Id id : entity.getAttributes().getId()) {
                    if (hashSet.contains(id.getName())) continue;
                    return new ErrorDescription[]{NoIdClassOnEntitySubclass.createProblem(typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_EntitySubclassHasIdClass"))};
                }
            }
        }
        return null;
    }
}

