/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestTaskRunner {
    private static final String SPEC = "spec";
    private final Project project;
    private final boolean debug;
    private TestRunner rspecRunner;
    private TestRunner testUnitRunner;
    private String task;
    private final Map<String, String> taskToFolder = TestTaskRunner.initTaskToFolder();

    TestTaskRunner(Project project, boolean bl) {
        assert (project != null);
        this.project = project;
        this.debug = bl;
        this.rspecRunner = TestTaskRunner.getTestRunner(TestRunner.TestType.RSPEC);
        this.testUnitRunner = TestTaskRunner.getTestRunner(TestRunner.TestType.TEST_UNIT);
    }

    private static Map<String, String> initTaskToFolder() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("test", "test/");
        hashMap.put("test:units", "test/unit");
        hashMap.put("test:functionals", "test/functional");
        hashMap.put("test:integration", "test/integration");
        return hashMap;
    }

    private boolean isSupportedTestTask(String string) {
        return this.taskToFolder.containsKey(string);
    }

    List<RakeTask> filter(List<RakeTask> list) {
        ArrayList<RakeTask> arrayList = new ArrayList<RakeTask>(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!SPEC.equals(((RakeTask)iterator.next()).getTask()) || this.rspecRunner == null) continue;
            iterator.remove();
            this.task = SPEC;
            return arrayList;
        }
        return arrayList;
    }

    boolean needsPostRun() {
        return this.task != null;
    }

    void postRun() {
        if (this.task == null) {
            return;
        }
        if (SPEC.equals(this.task)) {
            this.rspecRunner.runAllTests(this.project, this.debug);
            return;
        }
        FileObject fileObject = this.project.getProjectDirectory().getFileObject(this.taskToFolder.get(this.task));
        this.testUnitRunner.runTest(fileObject, this.debug);
    }

    private static TestRunner getTestRunner(TestRunner.TestType testType) {
        Collection collection = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner testRunner : collection) {
            if (!testRunner.supports(testType)) continue;
            return testRunner;
        }
        return null;
    }
}

