/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.dbmodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.netbeans.modules.sql.project.dbmodel.KeyColumn;

public class ForeignKeyColumn
extends KeyColumn {
    private static final String RS_PK_NAME = "PK_NAME";
    private static final String RS_PKCATALOG_NAME = "PKTABLE_CAT";
    private static final String RS_PKSCHEMA_NAME = "PKTABLE_SCHEM";
    private static final String RS_PKTABLE_NAME = "PKTABLE_NAME";
    private static final String RS_PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String RS_FK_NAME = "FK_NAME";
    private static final String RS_FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String RS_UPDATE_RULE = "UPDATE_RULE";
    private static final String RS_DELETE_RULE = "DELETE_RULE";
    private static final String RS_DEFERRABILITY = "DEFERRABILITY";
    private String importCatalogName;
    private String importSchemaName;
    private String importTableName;
    private String importColumnName;
    private String importKeyName;
    private short updateRule;
    private short deleteRule;
    private short deferrability;

    public static List createForeignKeyColumnList(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            Locale locale = Locale.getDefault();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NULL_RS") + "(ERROR_NULL_RS)");
        }
        ArrayList<ForeignKeyColumn> arrayList = Collections.EMPTY_LIST;
        if (resultSet != null && resultSet.next()) {
            arrayList = new ArrayList<ForeignKeyColumn>();
            do {
                arrayList.add(new ForeignKeyColumn(resultSet));
            } while (resultSet.next());
        }
        return arrayList;
    }

    public ForeignKeyColumn(String string, String string2, String string3, String string4, String string5, String string6, String string7, short s, short s2, short s3, short s4) {
        super(string, string2, s);
        this.importKeyName = string3;
        this.importCatalogName = string7;
        this.importSchemaName = string6;
        this.importTableName = string5;
        this.importColumnName = string4;
        this.setUpdateRule(s2);
        this.setDeleteRule(s3);
        this.setDeferrability(s4);
    }

    public ForeignKeyColumn(ForeignKeyColumn foreignKeyColumn) {
        super(foreignKeyColumn.getName(), foreignKeyColumn.getColumnName(), foreignKeyColumn.getColumnSequence());
        this.importKeyName = foreignKeyColumn.getImportKeyName();
        this.importCatalogName = foreignKeyColumn.getImportCatalogName();
        this.importSchemaName = foreignKeyColumn.getImportSchemaName();
        this.importTableName = foreignKeyColumn.getImportTableName();
        this.importColumnName = foreignKeyColumn.getImportColumnName();
        this.setUpdateRule(foreignKeyColumn.getUpdateRule());
        this.setDeleteRule(foreignKeyColumn.getDeleteRule());
        this.setDeferrability(foreignKeyColumn.getDeferrability());
    }

    private ForeignKeyColumn(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            Locale locale = Locale.getDefault();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_VALID_RS") + "(ERROR_VALID_RS)");
        }
        this.importCatalogName = resultSet.getString(RS_PKCATALOG_NAME);
        this.importSchemaName = resultSet.getString(RS_PKSCHEMA_NAME);
        this.importTableName = resultSet.getString(RS_PKTABLE_NAME);
        this.importColumnName = resultSet.getString(RS_PKCOLUMN_NAME);
        this.importKeyName = resultSet.getString(RS_PK_NAME);
        this.columnName = resultSet.getString(RS_FKCOLUMN_NAME);
        this.keyName = resultSet.getString(RS_FK_NAME);
        this.sequenceNum = resultSet.getShort("KEY_SEQ");
        this.updateRule = resultSet.getShort(RS_UPDATE_RULE);
        this.deleteRule = resultSet.getShort(RS_DELETE_RULE);
        this.deferrability = resultSet.getShort(RS_DEFERRABILITY);
    }

    public String getImportCatalogName() {
        return this.importCatalogName;
    }

    public String getImportSchemaName() {
        return this.importSchemaName;
    }

    public String getImportTableName() {
        return this.importTableName;
    }

    public String getImportColumnName() {
        return this.importColumnName;
    }

    public String getImportKeyName() {
        return this.importKeyName;
    }

    public short getUpdateRule() {
        return this.updateRule;
    }

    public short getDeleteRule() {
        return this.deleteRule;
    }

    public short getDeferrability() {
        return this.deferrability;
    }

    private void setUpdateRule(short s) {
        switch (s) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.updateRule = s;
                break;
            }
            default: {
                Locale locale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_VALID_RULE") + "(ERROR_VALID_RULE)");
            }
        }
    }

    private void setDeleteRule(short s) {
        switch (s) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.deleteRule = s;
                break;
            }
            default: {
                Locale locale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_VALID_RULE") + "(ERROR_VALID_RULE)");
            }
        }
    }

    private void setDeferrability(short s) {
        switch (s) {
            case 5: 
            case 6: 
            case 7: {
                this.deferrability = s;
                break;
            }
            default: {
                System.err.println("Received unrecognized value for newFlag, but carrying on with it anyway.");
                this.deferrability = s;
            }
        }
    }
}

