/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse.render;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.EdgeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class ReferenceEdgeRenderer
extends EdgeRenderer {
    protected GeneralPath m_arrowHead = new GeneralPath();

    public ReferenceEdgeRenderer() {
        this.m_arrowHead.moveTo(-6.0f, -14.0f);
        this.m_arrowHead.lineTo(0.0f, 0.0f);
        this.m_arrowHead.lineTo(6.0f, -14.0f);
    }

    protected Shape getRawShape(VisualItem visualItem) {
        EdgeItem edgeItem = (EdgeItem)visualItem;
        NodeItem nodeItem = edgeItem.getSourceItem();
        NodeItem nodeItem2 = edgeItem.getTargetItem();
        int n = this.m_edgeType;
        ReferenceEdgeRenderer.getAlignedPoint((Point2D)this.m_tmpPoints[0], (Rectangle2D)nodeItem.getBounds(), (int)this.m_xAlign1, (int)this.m_yAlign1);
        ReferenceEdgeRenderer.getAlignedPoint((Point2D)this.m_tmpPoints[1], (Rectangle2D)nodeItem2.getBounds(), (int)this.m_xAlign2, (int)this.m_yAlign2);
        this.m_curWidth = (float)(this.m_width * this.getLineWidth(visualItem));
        EdgeItem edgeItem2 = (EdgeItem)visualItem;
        if (edgeItem2.isDirected() && this.m_edgeArrow != 0) {
            NodeItem nodeItem3;
            boolean bl = this.m_edgeArrow == 1;
            Point2D point2D = null;
            Point2D point2D2 = null;
            point2D = this.m_tmpPoints[bl ? 0 : 1];
            int n2 = GraphicsLib.intersectLineRectangle((Point2D)point2D, (Point2D)(point2D2 = this.m_tmpPoints[bl ? 1 : 0]), (Rectangle2D)(nodeItem3 = bl ? edgeItem2.getTargetItem() : edgeItem2.getSourceItem()).getBounds(), (Point2D[])this.m_isctPoints);
            if (n2 > 0) {
                point2D2 = this.m_isctPoints[0];
            }
            AffineTransform affineTransform = this.getArrowTrans(point2D, point2D2, this.m_curWidth);
            this.m_curArrow = affineTransform.createTransformedShape(this.m_arrowHead);
        } else {
            this.m_curArrow = null;
        }
        Shape shape = null;
        double d = this.m_tmpPoints[0].getX();
        double d2 = this.m_tmpPoints[0].getY();
        double d3 = this.m_tmpPoints[1].getX();
        double d4 = this.m_tmpPoints[1].getY();
        switch (n) {
            case 0: {
                this.m_line.setLine(d, d2, d3, d4);
                shape = this.m_line;
                break;
            }
            case 1: {
                this.getCurveControlPoints(edgeItem, this.m_ctrlPoints, d, d2, d3, d4);
                this.m_cubic.setCurve(d, d2, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), d3, d4);
                shape = this.m_cubic;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown edge type");
            }
        }
        return shape;
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape != null) {
            this.drawShape(graphics2D, visualItem, shape);
        }
        if (this.m_curArrow != null) {
            graphics2D.setPaint(ColorLib.getColor((int)visualItem.getFillColor()));
            graphics2D.draw(this.m_curArrow);
        }
    }
}

