/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.wizard.ImportDirectory;
import org.netbeans.modules.xml.schema.wizard.RetrieveXMLResourceVisualPanel1;
import org.netbeans.modules.xml.schema.wizard.RetrieveXMLResourceWizardPanel1;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;

public final class RetrieveXMLResourceWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private String schemaFileType = "retrieveSchemaResource";
    private String wsdlFileType = "retrieveWSDLResource";

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new RetrieveXMLResourceWizardPanel1()};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        RetrieveXMLResourceVisualPanel1.SourceType sourceType = (RetrieveXMLResourceVisualPanel1.SourceType)((Object)templateWizard.getProperty("sourceLocationTypeKey"));
        if (sourceType == RetrieveXMLResourceVisualPanel1.SourceType.LOCAL_FILE || sourceType == RetrieveXMLResourceVisualPanel1.SourceType.URL_ADDR) {
            return this.instantiateURL();
        }
        return Collections.singleton(templateWizard.getTargetFolder());
    }

    private Set instantiateLocalFile() throws IOException {
        FileObject fileObject;
        String string = (String)this.wizard.getProperty("sourceLocationKey");
        File file = (File)this.wizard.getProperty("targetFileKey");
        boolean bl = (Boolean)this.wizard.getProperty("overwriteFiles");
        if (((TemplateWizard)this.wizard).getTemplate().getName().equals(this.schemaFileType)) {
            new ImportDirectory(string, file, bl, Utilities.DocumentTypesEnum.schema);
        } else {
            new ImportDirectory(string, file, bl, Utilities.DocumentTypesEnum.wsdl);
        }
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        if ((fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(fileObject);
    }

    private Set instantiateURL() throws IOException {
        FileObject fileObject;
        File file = (File)this.wizard.getProperty("targetFileKey");
        String string = (String)this.wizard.getProperty("sourceLocationKey");
        File file2 = (File)this.wizard.getProperty("selectedSaveRootFolder");
        boolean bl = (Boolean)this.wizard.getProperty("overwriteFiles");
        RetrieverEngine retrieverEngine = RetrieverEngine.getRetrieverEngine((File)file2);
        RetrieveEntry retrieveEntry = null;
        retrieveEntry = (Boolean)this.wizard.getProperty("retrieveClosureKey") != false ? new RetrieveEntry(null, string, null, null, Utilities.DocumentTypesEnum.schema, true) : new RetrieveEntry(null, string, null, file, Utilities.DocumentTypesEnum.schema, false);
        retrieverEngine.addResourceToRetrieve(retrieveEntry);
        retrieverEngine.setFileOverwrite(bl);
        retrieverEngine.start();
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        if ((fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(fileObject);
    }

    public void initialize(TemplateWizard templateWizard) {
        DataFolder dataFolder;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        arrayList.addAll(Arrays.asList(sourceGroupArray));
        if (arrayList.isEmpty()) {
            dataFolder = sources.getSourceGroups("generic");
            arrayList.addAll(Arrays.asList(dataFolder));
        }
        dataFolder = DataFolder.findFolder((FileObject)((SourceGroup)arrayList.get(0)).getRootFolder());
        DataFolder dataFolder2 = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        try {
            if (templateWizard.getTargetFolder().equals(dataFolder2)) {
                templateWizard.setTargetFolder(dataFolder);
            }
        }
        catch (IOException iOException) {
            templateWizard.setTargetFolder(dataFolder);
        }
        templateWizard.putProperty("thisWizardIteratorKey", (Object)this);
        templateWizard.putProperty("currentProjectKey", (Object)project);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        templateWizard.putProperty("currentFolderKey", (Object)fileObject);
        this.wizard = templateWizard;
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }
}

