/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.multiview;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.multiview.SchemaABEViewMultiViewDesc;
import org.netbeans.modules.xml.schema.multiview.SchemaColumnViewMultiViewDesc;
import org.netbeans.modules.xml.schema.multiview.SchemaSourceMultiViewDesc;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.cookies.GetComponentCookie;
import org.netbeans.modules.xml.xam.ui.cookies.ViewComponentCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaMultiViewSupport
implements ViewComponentCookie,
ShowCookie {
    public static final String SCHEMA_EDITOR_HELP_ID = "SCHEMA_EDITOR_HELP_ID";
    private SchemaDataObject dobj;

    public SchemaMultiViewSupport(SchemaDataObject schemaDataObject) {
        this.dobj = schemaDataObject;
    }

    public static CloneableTopComponent createMultiView(SchemaDataObject schemaDataObject) {
        MultiViewDescription[] multiViewDescriptionArray = new MultiViewDescription[]{SchemaMultiViewSupport.getSchemaSourceMultiviewDesc(schemaDataObject), SchemaMultiViewSupport.getSchemaColumnViewMultiViewDesc(schemaDataObject), SchemaMultiViewSupport.getSchemaABEMultiviewDesc(schemaDataObject)};
        CloneableTopComponent cloneableTopComponent = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])multiViewDescriptionArray, (MultiViewDescription)multiViewDescriptionArray[0], (CloseOperationHandler)new SchemaEditorSupport.CloseHandler((DataObject)schemaDataObject));
        String string = schemaDataObject.getNodeDelegate().getDisplayName();
        cloneableTopComponent.setDisplayName(string);
        cloneableTopComponent.setName(string);
        return cloneableTopComponent;
    }

    private static MultiViewDescription getSchemaColumnViewMultiViewDesc(SchemaDataObject schemaDataObject) {
        return new SchemaColumnViewMultiViewDesc(schemaDataObject);
    }

    private static MultiViewDescription getSchemaSourceMultiviewDesc(SchemaDataObject schemaDataObject) {
        return new SchemaSourceMultiViewDesc(schemaDataObject);
    }

    private static MultiViewDescription getSchemaABEMultiviewDesc(SchemaDataObject schemaDataObject) {
        return new SchemaABEViewMultiViewDesc(schemaDataObject);
    }

    public static boolean isLastView(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    private static void requestMultiviewActive(String string) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            MultiViewPerspective[] multiViewPerspectiveArray;
            for (MultiViewPerspective multiViewPerspective : multiViewPerspectiveArray = multiViewHandler.getPerspectives()) {
                if (!multiViewPerspective.preferredID().equals(string)) continue;
                multiViewHandler.requestActive(multiViewPerspective);
            }
        }
    }

    private static String getMultiviewActive() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            return multiViewHandler.getSelectedPerspective().preferredID();
        }
        return null;
    }

    private static Collection<Component> getActiveComponents() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        Set<Component> set = Collections.emptySet();
        for (Node node : topComponent.getActivatedNodes()) {
            GetComponentCookie getComponentCookie = (GetComponentCookie)node.getCookie(GetComponentCookie.class);
            Component component = null;
            if (getComponentCookie != null) {
                component = getComponentCookie.getComponent();
            }
            if (component == null) {
                component = (Component)node.getLookup().lookup(Component.class);
            }
            if (component == null) continue;
            if (set.isEmpty()) {
                set = new HashSet<Component>();
            }
            set.add(component);
        }
        return set;
    }

    public void view(final ViewComponentCookie.View view, final Component component, final Object ... objectArray) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SchemaMultiViewSupport.this.viewInSwingThread(view, component, objectArray);
                }
            });
        } else {
            this.viewInSwingThread(view, component, objectArray);
        }
    }

    private void viewInSwingThread(ViewComponentCookie.View view, Component component, Object ... objectArray) {
        if (this.canView(view, component)) {
            String string;
            Object object;
            SchemaDataObject schemaDataObject;
            if (view == ViewComponentCookie.View.SUPER && this.dobj != (schemaDataObject = (SchemaDataObject)((Object)(object = TopComponent.getRegistry().getActivated()).getLookup().lookup(SchemaDataObject.class)))) {
                string = SchemaMultiViewSupport.getMultiviewActive();
                view = ViewComponentCookie.View.STRUCTURE;
                if ("xml-schema-abeview".equals(string)) {
                    view = ViewComponentCookie.View.DESIGN;
                } else if ("xml-schema-sourceview".equals(string)) {
                    view = ViewComponentCookie.View.SOURCE;
                }
            }
            object = this.dobj.getSchemaEditorSupport();
            object.open();
            switch (view) {
                case STRUCTURE: {
                    if (component instanceof AXIComponent) {
                        component = ((AXIComponent)component).getPeer();
                    }
                    SchemaMultiViewSupport.requestMultiviewActive("xml-schema-columnview");
                    break;
                }
                case DESIGN: {
                    SchemaMultiViewSupport.requestMultiviewActive("xml-schema-abeview");
                    break;
                }
                case SOURCE: {
                    if (component instanceof AXIComponent) {
                        component = ((AXIComponent)component).getPeer();
                    }
                    SchemaMultiViewSupport.requestMultiviewActive("xml-schema-sourceview");
                }
            }
            schemaDataObject = TopComponent.getRegistry().getActivated();
            string = (ShowCookie)schemaDataObject.getLookup().lookup(ShowCookie.class);
            Validator.ResultItem resultItem = null;
            if (objectArray != null && objectArray.length != 0) {
                for (Object object2 : objectArray) {
                    if (!(object2 instanceof Validator.ResultItem)) continue;
                    resultItem = (Validator.ResultItem)object2;
                    break;
                }
            }
            if (resultItem == null) {
                resultItem = new Validator.ResultItem(null, null, component, null);
            }
            if (string != null) {
                string.show(resultItem);
            }
        }
    }

    public void show(Validator.ResultItem resultItem) {
        TopComponent topComponent;
        SchemaDataObject schemaDataObject;
        ViewComponentCookie.View view = ViewComponentCookie.View.SOURCE;
        Component component = resultItem.getComponents();
        if (component != null && component.getModel() != null && component.getModel().getState() == Model.State.VALID && this.dobj == (schemaDataObject = (SchemaDataObject)((Object)(topComponent = TopComponent.getRegistry().getActivated()).getLookup().lookup(SchemaDataObject.class)))) {
            String string = SchemaMultiViewSupport.getMultiviewActive();
            if ("xml-schema-abeview".equals(string)) {
                AXIModel aXIModel = null;
                if (component instanceof AXIComponent) {
                    aXIModel = ((AXIComponent)component).getModel();
                } else if (component instanceof SchemaComponent) {
                    aXIModel = AXIModelFactory.getDefault().getModel(((SchemaComponent)component).getModel());
                }
                if (aXIModel != null && aXIModel.getState() == Model.State.VALID) {
                    view = ViewComponentCookie.View.DESIGN;
                }
            } else if ("xml-schema-columnview".equals(string)) {
                view = ViewComponentCookie.View.STRUCTURE;
            }
        }
        this.view(view, component, resultItem);
    }

    public boolean canView(ViewComponentCookie.View view, Component component) {
        if (view == null) {
            return false;
        }
        if (component == null) {
            return true;
        }
        switch (view) {
            case SOURCE: {
                if (!"xml-schema-sourceview".equals(SchemaMultiViewSupport.getMultiviewActive()) || !SchemaMultiViewSupport.getActiveComponents().contains(component)) {
                    if (component instanceof AXIComponent) {
                        return ((AXIComponent)component).getPeer() != null;
                    }
                    return true;
                }
                return false;
            }
            case STRUCTURE: {
                if (!(component instanceof SchemaComponent) && !(component instanceof AXIComponent)) {
                    return false;
                }
                if (component instanceof AXIComponent && ((AXIComponent)component).getPeer() == null) {
                    return false;
                }
                if ("xml-schema-columnview".equals(SchemaMultiViewSupport.getMultiviewActive()) && SchemaMultiViewSupport.getActiveComponents().contains(component)) {
                    TopComponent topComponent = TopComponent.getRegistry().getActivated();
                    SchemaDataObject schemaDataObject = (SchemaDataObject)((Object)topComponent.getLookup().lookup(SchemaDataObject.class));
                    return schemaDataObject != this.dobj;
                }
                return true;
            }
            case DESIGN: {
                if ("xml-schema-abeview".equals(SchemaMultiViewSupport.getMultiviewActive())) {
                    return false;
                }
                AXIModel aXIModel = null;
                if (component instanceof AXIComponent) {
                    aXIModel = ((AXIComponent)component).getModel();
                } else if (component instanceof SchemaComponent && !(aXIModel = AXIModelFactory.getDefault().getModel(((SchemaComponent)component).getModel())).canView((SchemaComponent)component)) {
                    return false;
                }
                return aXIModel != null && aXIModel.getState() == Model.State.VALID;
            }
            case SUPER: {
                return true;
            }
        }
        return false;
    }
}

