/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.AddTagFix;
import org.netbeans.modules.javadoc.hints.FixAll;
import org.netbeans.modules.javadoc.hints.GenerateJavadocFix;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.modules.javadoc.hints.RemoveTagFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Analyzer {
    private static final String ERROR_IDENT = "<error>";
    private final CompilationInfo javac;
    private final SourceVersion spec;
    private final FixAll fixAll = new FixAll();
    private final Document doc;
    private final FileObject file;
    private final Severity severity;
    private final AbstractHint.HintSeverity hintSeverity;
    private final TreePath currentPath;
    private final boolean createJavadocKind;
    private final Access access;

    Analyzer(CompilationInfo compilationInfo, Document document, TreePath treePath, Severity severity, AbstractHint.HintSeverity hintSeverity, boolean bl, Access access) {
        this.javac = compilationInfo;
        this.doc = document;
        this.file = compilationInfo.getFileObject();
        this.currentPath = treePath;
        this.severity = severity;
        this.hintSeverity = hintSeverity;
        this.spec = Analyzer.resolveSourceVersion(compilationInfo.getFileObject());
        this.createJavadocKind = bl;
        this.access = access;
    }

    private ErrorDescription createErrorDescription(String string, LazyFixList lazyFixList, Position[] positionArray) {
        if (this.hintSeverity == AbstractHint.HintSeverity.CURRENT_LINE_WARNING) {
            return ErrorDescriptionFactory.createErrorDescription((Severity)this.severity, (String)string, (LazyFixList)lazyFixList, (FileObject)this.file, (int)CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file), (int)CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file));
        }
        return ErrorDescriptionFactory.createErrorDescription((Severity)this.severity, (String)string, (LazyFixList)lazyFixList, (Document)this.doc, (Position)positionArray[0], (Position)positionArray[1]);
    }

    private ErrorDescription createErrorDescription(String string, List<Fix> list, Position[] positionArray) {
        return this.createErrorDescription(string, ErrorDescriptionFactory.lazyListForFixes(list), positionArray);
    }

    public List<ErrorDescription> analyze() {
        List<ErrorDescription> list = Collections.emptyList();
        Tree tree = this.currentPath.getLeaf();
        if (this.javac.getTreeUtilities().isSynthetic(this.currentPath) || !this.isValid(this.currentPath)) {
            return list;
        }
        Element element = this.javac.getTrees().getElement(this.currentPath);
        if (element == null) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, "Cannot resolve element for " + tree + " in " + this.file);
            return list;
        }
        if (this.isGuarded(tree)) {
            return list;
        }
        String string = this.javac.getElements().getDocComment(element);
        if (string == null) {
            if (!this.createJavadocKind) {
                return list;
            }
            if (Analyzer.hasErrors(tree) || JavadocUtilities.hasInheritedDoc(this.javac, element)) {
                return list;
            }
            try {
                Position[] positionArray = this.createSignaturePositions(tree);
                ErrorDescription errorDescription = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_JAVADOC_DESC"), this.createGenerateFixes(element), positionArray);
                list = new ArrayList<ErrorDescription>();
                list.add(errorDescription);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
            }
        } else {
            if (this.createJavadocKind || Analyzer.hasErrors(tree)) {
                return list;
            }
            list = new ArrayList<ErrorDescription>();
            Doc doc = this.javac.getElementUtilities().javaDocFor(element);
            if (doc.isMethod() || doc.isConstructor()) {
                ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)doc;
                ExecutableElement executableElement = (ExecutableElement)element;
                MethodTree methodTree = (MethodTree)tree;
                this.processTypeParameters(executableElement, methodTree, executableMemberDoc, list);
                this.processParameters(executableElement, methodTree, executableMemberDoc, list);
                this.processReturn(executableElement, methodTree, executableMemberDoc, list);
                this.processThrows(executableElement, methodTree, executableMemberDoc, list);
            } else if (doc.isClass() || doc.isInterface()) {
                TypeElement typeElement = (TypeElement)element;
                ClassDoc classDoc = (ClassDoc)doc;
                ClassTree classTree = (ClassTree)tree;
                this.processTypeParameters(typeElement, classTree, classDoc, list);
                this.processParameters(typeElement, classTree, classDoc, list);
            } else if (doc.isAnnotationType()) {
                this.processAnnTypeParameters(element, tree, doc, list);
            } else if (doc.isAnnotationTypeElement()) {
                AnnotationTypeElementDoc annotationTypeElementDoc = (AnnotationTypeElementDoc)doc;
                ExecutableElement executableElement = (ExecutableElement)element;
                MethodTree methodTree = (MethodTree)tree;
                this.processAnnTypeParameters(executableElement, methodTree, (Doc)annotationTypeElementDoc, list);
                this.processReturn(executableElement, methodTree, (ExecutableMemberDoc)annotationTypeElementDoc, list);
                this.processAnnTypeThrows(executableElement, methodTree, annotationTypeElementDoc, list);
            }
            this.processDeprecatedAnnotation(element, doc, list);
        }
        return list;
    }

    static boolean hasErrors(Tree tree) {
        switch (tree.getKind()) {
            case METHOD: {
                MethodTree methodTree = (MethodTree)tree;
                Tree tree2 = methodTree.getReturnType();
                if (tree2 != null && tree2.getKind() == Tree.Kind.ERRONEOUS) {
                    return true;
                }
                for (VariableTree tree3 : methodTree.getParameters()) {
                    if (!ERROR_IDENT.contentEquals(tree3.getName())) continue;
                    return true;
                }
                for (ExpressionTree expressionTree : methodTree.getThrows()) {
                    if (expressionTree.getKind() != Tree.Kind.ERRONEOUS && (expressionTree.getKind() != Tree.Kind.IDENTIFIER || !ERROR_IDENT.contentEquals(((IdentifierTree)expressionTree).getName()))) continue;
                    return true;
                }
                break;
            }
            case VARIABLE: {
                VariableTree variableTree = (VariableTree)tree;
                return variableTree.getType().getKind() == Tree.Kind.ERRONEOUS || ERROR_IDENT.contentEquals(variableTree.getName());
            }
            case CLASS: {
                ClassTree classTree = (ClassTree)tree;
                if (ERROR_IDENT.contentEquals(classTree.getSimpleName())) {
                    return true;
                }
                for (TypeParameterTree typeParameterTree : classTree.getTypeParameters()) {
                    if (!ERROR_IDENT.contentEquals(typeParameterTree.getName())) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private boolean isValid(TreePath treePath) {
        Tree tree = treePath.getLeaf();
        int n = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.javac.getFileObject());
        boolean bl = this.hintSeverity == AbstractHint.HintSeverity.CURRENT_LINE_WARNING;
        switch (tree.getKind()) {
            case CLASS: {
                return this.access.isAccessible(this.javac, treePath, false) && (!bl || Analyzer.isInHeader(this.javac, (ClassTree)tree, n));
            }
            case METHOD: {
                return this.access.isAccessible(this.javac, treePath, false) && (!bl || Analyzer.isInHeader(this.javac, (MethodTree)tree, n));
            }
            case VARIABLE: {
                return this.access.isAccessible(this.javac, treePath, false);
            }
        }
        return false;
    }

    private void processDeprecatedAnnotation(Element element, Doc doc, List<ErrorDescription> list) {
        if (SourceVersion.RELEASE_5.compareTo(this.spec) > 0) {
            return;
        }
        Tag[] tagArray = doc.tags("@deprecated");
        AnnotationMirror annotationMirror = JavadocUtilities.findDeprecated(this.javac, element);
        if (annotationMirror != null) {
            if (tagArray.length == 0) {
                try {
                    Position[] positionArray = this.createPositions(this.javac.getTrees().getTree(element, annotationMirror));
                    ErrorDescription errorDescription = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_DEPRECATED_DESC"), Collections.singletonList(AddTagFix.createAddDeprecatedTagFix(element, this.file, this.spec)), positionArray);
                    this.addTagHint(list, errorDescription);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            } else if (tagArray.length > 1) {
                boolean bl = true;
                for (Tag tag : tagArray) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_DEPRECATED_DESC"), element, list);
                }
            }
        } else {
            if (tagArray.length > 1) {
                boolean bl = true;
                for (Tag tag : tagArray) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_DEPRECATED_DESC"), element, list);
                }
            }
            if (tagArray.length > 0) {
                // empty if block
            }
        }
    }

    private void processReturn(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
        Tag tag;
        int n;
        TypeMirror typeMirror = executableElement.getReturnType();
        Tree tree = methodTree.getReturnType();
        Tag[] tagArray = executableMemberDoc.tags("@return");
        if (typeMirror.getKind() == TypeKind.VOID) {
            for (n = 0; n < tagArray.length; ++n) {
                tag = tagArray[n];
                this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)(executableMemberDoc.isMethod() ? "WRONG_RETURN_DESC" : "WRONG_CONSTRUCTOR_RETURN_DESC")), executableElement, list);
            }
        } else {
            for (n = 0; n < tagArray.length; ++n) {
                tag = tagArray[n];
                if (n <= 0) continue;
                this.addRemoveTagFix(tag, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_RETURN_DESC"), executableElement, list);
            }
        }
        if (typeMirror.getKind() != TypeKind.VOID && tagArray.length == 0 && JavadocUtilities.findReturnTag(this.javac, (MethodDoc)executableMemberDoc, true) == null) {
            try {
                Position[] positionArray = this.createPositions(tree);
                tag = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_RETURN_DESC"), Collections.singletonList(AddTagFix.createAddReturnTagFix(executableElement, this.file, this.spec)), positionArray);
                this.addTagHint(list, (ErrorDescription)tag);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processThrows(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
        String string;
        Object object;
        Object object22;
        void expressionTree;
        List<? extends ExpressionTree> list2 = methodTree.getThrows();
        ThrowsTag[] throwsTagArray = executableMemberDoc.throwsTags();
        HashMap<String, ThrowsTag> hashMap = new HashMap<String, ThrowsTag>();
        ThrowsTag[] throwsTagArray2 = throwsTagArray;
        int n = throwsTagArray2.length;
        boolean bl = false;
        while (expressionTree < n) {
            object22 = throwsTagArray2[expressionTree];
            object = object22.exceptionType();
            string = null;
            string = object != null ? object22.exceptionType().qualifiedTypeName() : object22.exceptionName();
            if (hashMap.containsKey(string)) {
                this.addRemoveTagFix((Tag)object22, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_THROWS_DESC", (Object)object22.name(), (Object)object22.exceptionName()), executableElement, list);
            } else {
                hashMap.put(string, (ThrowsTag)object22);
            }
            ++expressionTree;
        }
        int n2 = 0;
        for (ExpressionTree expressionTree2 : list2) {
            boolean typeElement;
            object22 = new TreePath(this.currentPath, expressionTree2);
            object = this.javac.getTrees().getElement((TreePath)object22);
            if (ElementKind.CLASS == object.getKind()) {
                TypeElement element = (TypeElement)object;
                string = element.getQualifiedName().toString();
            } else if (ElementKind.TYPE_PARAMETER == object.getKind()) {
                string = object.getSimpleName().toString();
            } else {
                throw new IllegalStateException("Illegal kind: " + (Object)((Object)object.getKind()));
            }
            boolean bl2 = typeElement = hashMap.remove(string) != null;
            if (!typeElement && (executableMemberDoc.isConstructor() || executableMemberDoc.isMethod() && JavadocUtilities.findThrowsTag(this.javac, (MethodDoc)executableMemberDoc, string, true) == null)) {
                try {
                    Position[] badLocationException = this.createPositions(expressionTree2);
                    ErrorDescription errorDescription = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_THROWS_DESC", (Object)string), Collections.singletonList(AddTagFix.createAddThrowsTagFix(executableElement, expressionTree2.toString(), n2, this.file, this.spec)), badLocationException);
                    this.addTagHint(list, errorDescription);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            }
            ++n2;
        }
        TypeMirror typeMirror = this.javac.getElements().getTypeElement("java.lang.RuntimeException").asType();
        for (Object object22 : hashMap.values()) {
            Element element;
            object = object22.exceptionType();
            string = null;
            if (object != null) {
                string = object.asClassDoc();
            }
            if (string != null && (element = this.javac.getElementUtilities().elementFor((Doc)string)) != null && this.javac.getTypes().isSubtype(element.asType(), typeMirror)) break;
            this.addRemoveTagFix((Tag)object22, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_THROWABLE_DESC", (Object)object22.name(), (Object)object22.exceptionName()), executableElement, list);
        }
    }

    private void processAnnTypeThrows(ExecutableElement executableElement, MethodTree methodTree, AnnotationTypeElementDoc annotationTypeElementDoc, List<ErrorDescription> list) {
        Tag[] tagArray;
        for (Tag tag : tagArray = annotationTypeElementDoc.tags("@throws")) {
            ThrowsTag throwsTag = (ThrowsTag)tag;
            this.addRemoveTagFix((Tag)throwsTag, NbBundle.getMessage(Analyzer.class, (String)"ILLEGAL_ANNOTATION_TYPE_THROWS_DESC", (Object)throwsTag.name(), (Object)throwsTag.exceptionName()), executableElement, list);
        }
    }

    private void processAnnTypeParameters(Element element, Tree tree, Doc doc, List<ErrorDescription> list) {
        Tag[] tagArray;
        for (Tag tag : tagArray = doc.tags("@param")) {
            ParamTag paramTag = (ParamTag)tag;
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"ILLEGAL_ANNOTATION_TYPE_PARAM_DESC", (Object)paramTag.parameterName()), element, list);
        }
    }

    private void processParameters(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
        List<? extends VariableTree> list2 = methodTree.getParameters();
        ParamTag[] paramTagArray = executableMemberDoc.paramTags();
        HashMap<String, ParamTag> hashMap = new HashMap<String, ParamTag>();
        for (ParamTag positionArray : paramTagArray) {
            if (hashMap.containsKey(positionArray.parameterName())) {
                this.addRemoveTagFix((Tag)positionArray, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_PARAM_DESC", (Object)positionArray.parameterName()), executableElement, list);
                continue;
            }
            hashMap.put(positionArray.parameterName(), positionArray);
        }
        for (VariableTree variableTree : list2) {
            int n = hashMap.remove(variableTree.getName().toString()) != null ? 1 : 0;
            if (n != 0 || !executableMemberDoc.isConstructor() && (!executableMemberDoc.isMethod() || JavadocUtilities.findParamTag(this.javac, (MethodDoc)executableMemberDoc, variableTree.getName().toString(), false, true) != null)) continue;
            try {
                Position[] positionArray = this.createPositions(variableTree);
                ErrorDescription errorDescription = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_PARAM_DESC", (Object)variableTree.getName()), Collections.singletonList(AddTagFix.createAddParamTagFix(executableElement, variableTree.getName().toString(), this.file, this.spec)), positionArray);
                this.addTagHint(list, errorDescription);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
            }
        }
        for (ParamTag paramTag : hashMap.values()) {
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_PARAM_DESC", (Object)paramTag.parameterName()), executableElement, list);
        }
    }

    private void processParameters(TypeElement typeElement, ClassTree classTree, ClassDoc classDoc, List<ErrorDescription> list) {
        for (Tag tag : classDoc.tags("@param")) {
            ParamTag paramTag = (ParamTag)tag;
            if (paramTag.isTypeParameter()) continue;
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_PARAM_DESC", (Object)paramTag.parameterName()), typeElement, list);
        }
    }

    private void processTypeParameters(TypeElement typeElement, ClassTree classTree, ClassDoc classDoc, List<ErrorDescription> list) {
        this.processTypeParameters(typeElement, classTree.getTypeParameters(), classDoc.typeParamTags(), (Doc)classDoc, list);
    }

    private void processTypeParameters(ExecutableElement executableElement, MethodTree methodTree, ExecutableMemberDoc executableMemberDoc, List<ErrorDescription> list) {
        this.processTypeParameters(executableElement, methodTree.getTypeParameters(), executableMemberDoc.typeParamTags(), (Doc)executableMemberDoc, list);
    }

    private void processTypeParameters(Element element, List<? extends TypeParameterTree> list, ParamTag[] paramTagArray, Doc doc, List<ErrorDescription> list2) {
        String string;
        HashMap<String, ParamTag> hashMap = new HashMap<String, ParamTag>();
        for (ParamTag positionArray : paramTagArray) {
            if (hashMap.containsKey(positionArray.parameterName())) {
                string = '<' + positionArray.parameterName() + '>';
                this.addRemoveTagFix((Tag)positionArray, NbBundle.getMessage(Analyzer.class, (String)"DUPLICATE_TYPEPARAM_DESC", (Object)string), element, list2);
                continue;
            }
            hashMap.put(positionArray.parameterName(), positionArray);
        }
        for (TypeParameterTree typeParameterTree : list) {
            int n = hashMap.remove(typeParameterTree.getName().toString()) != null ? 1 : 0;
            if (n != 0 || doc.isMethod() && (!doc.isMethod() || JavadocUtilities.findParamTag(this.javac, (MethodDoc)doc, typeParameterTree.getName().toString(), true, true) != null)) continue;
            try {
                Position[] positionArray = this.createPositions(typeParameterTree);
                string = typeParameterTree.getName().toString();
                String string2 = '<' + string + '>';
                ErrorDescription errorDescription = this.createErrorDescription(NbBundle.getMessage(Analyzer.class, (String)"MISSING_TYPEPARAM_DESC", (Object)string2), Collections.singletonList(AddTagFix.createAddTypeParamTagFix(element, string, this.file, this.spec)), positionArray);
                this.addTagHint(list2, errorDescription);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
            }
        }
        for (ParamTag paramTag : hashMap.values()) {
            String string3 = '<' + paramTag.parameterName() + '>';
            this.addRemoveTagFix((Tag)paramTag, NbBundle.getMessage(Analyzer.class, (String)"UNKNOWN_TYPEPARAM_DESC", (Object)string3), element, list2);
        }
    }

    Position[] createPositions(Tree tree) throws BadLocationException {
        Position[] positionArray = new Position[2];
        int n = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), tree);
        int n2 = (int)this.javac.getTrees().getSourcePositions().getEndPosition(this.javac.getCompilationUnit(), tree);
        positionArray[0] = this.doc.createPosition(n);
        positionArray[1] = this.doc.createPosition(n2);
        return positionArray;
    }

    Position[] createSignaturePositions(final Tree tree) throws BadLocationException {
        final Position[] positionArray = new Position[2];
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    int[] nArray = null;
                    if (tree.getKind() == Tree.Kind.METHOD) {
                        nArray = Analyzer.this.javac.getTreeUtilities().findNameSpan((MethodTree)tree);
                    } else if (tree.getKind() == Tree.Kind.CLASS) {
                        nArray = Analyzer.this.javac.getTreeUtilities().findNameSpan((ClassTree)tree);
                    } else if (Tree.Kind.VARIABLE == tree.getKind()) {
                        nArray = Analyzer.this.javac.getTreeUtilities().findNameSpan((VariableTree)tree);
                    }
                    if (nArray == null) {
                        throw new IllegalStateException(String.format("Please attach the stack trace and if possible also the edited source file '%s' to issue http://www.netbeans.org/issues/show_bug.cgi?id=134663\nkind: %s\ntree: '%s'", new Object[]{Analyzer.this.file.toString(), tree.getKind(), tree.toString()}));
                    }
                    positionArray[0] = Analyzer.this.doc.createPosition(nArray[0]);
                    positionArray[1] = Analyzer.this.doc.createPosition(nArray[1]);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw (BadLocationException)new BadLocationException(badLocationExceptionArray[0].getMessage(), badLocationExceptionArray[0].offsetRequested()).initCause(badLocationExceptionArray[0]);
        }
        return positionArray;
    }

    private boolean isGuarded(Tree tree) {
        GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)this.doc));
        if (guardedSectionManager != null) {
            try {
                int n = (int)this.javac.getTrees().getSourcePositions().getStartPosition(this.javac.getCompilationUnit(), tree);
                Position position = this.doc.createPosition(n);
                for (GuardedSection guardedSection : guardedSectionManager.getGuardedSections()) {
                    if (!guardedSection.contains(position, false)) continue;
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                return true;
            }
        }
        return false;
    }

    private void addRemoveTagFix(Tag tag, String string, Element element, List<ErrorDescription> list) {
        try {
            Position[] positionArray = JavadocUtilities.findTagNameBounds(this.javac, this.doc, tag);
            if (positionArray == null) {
                throw new BadLocationException("no position for " + tag, -1);
            }
            ErrorDescription errorDescription = this.createErrorDescription(string, Collections.singletonList(new RemoveTagFix(tag.name(), JavadocUtilities.TagHandle.create(tag), ElementHandle.create((Element)element), this.file, this.spec)), positionArray);
            this.addTagHint(list, errorDescription);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
        }
    }

    JavadocLazyFixList createGenerateFixes(Element element) {
        ArrayList<Fix> arrayList = new ArrayList<Fix>(3);
        ElementHandle elementHandle = ElementHandle.create((Element)element);
        String string = element.getKind() == ElementKind.CONSTRUCTOR ? element.getEnclosingElement().getSimpleName().toString() : element.getSimpleName().toString();
        JavadocLazyFixList javadocLazyFixList = new JavadocLazyFixList(arrayList, this.fixAll);
        GenerateJavadocFix generateJavadocFix = new GenerateJavadocFix(string, elementHandle, this.javac.getFileObject(), this.spec);
        arrayList.add(generateJavadocFix);
        return javadocLazyFixList;
    }

    private void addTagHint(List<ErrorDescription> list, ErrorDescription errorDescription) {
        list.add(errorDescription);
    }

    private static boolean isInHeader(CompilationInfo compilationInfo, ClassTree classTree, int n) {
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        long l = sourcePositions.getStartPosition(compilationUnitTree, classTree);
        List<? extends Tree> list = classTree.getImplementsClause();
        if (list != null && !list.isEmpty()) {
            l = sourcePositions.getEndPosition(compilationUnitTree, list.get(list.size() - 1));
        } else {
            List<? extends TypeParameterTree> list2 = classTree.getTypeParameters();
            if (list2 != null && !list2.isEmpty()) {
                l = sourcePositions.getEndPosition(compilationUnitTree, list2.get(list2.size() - 1));
            } else if (classTree.getExtendsClause() != null) {
                l = sourcePositions.getEndPosition(compilationUnitTree, classTree.getExtendsClause());
            } else if (classTree.getModifiers() != null) {
                l = sourcePositions.getEndPosition(compilationUnitTree, classTree.getModifiers());
            }
        }
        TokenSequence tokenSequence = compilationInfo.getTreeUtilities().tokensFor((Tree)classTree);
        tokenSequence.move((int)l);
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != JavaTokenId.LBRACE) continue;
            return n < tokenSequence.offset();
        }
        return false;
    }

    private static boolean isInHeader(CompilationInfo compilationInfo, MethodTree methodTree, int n) {
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        long l = sourcePositions.getStartPosition(compilationUnitTree, methodTree);
        List<? extends ExpressionTree> list = methodTree.getThrows();
        if (list != null && !list.isEmpty()) {
            l = sourcePositions.getEndPosition(compilationUnitTree, list.get(list.size() - 1));
        } else {
            List<? extends VariableTree> list2 = methodTree.getParameters();
            if (list2 != null && !list2.isEmpty()) {
                l = sourcePositions.getEndPosition(compilationUnitTree, list2.get(list2.size() - 1));
            } else {
                List<? extends TypeParameterTree> list3 = methodTree.getTypeParameters();
                if (list3 != null && !list3.isEmpty()) {
                    l = sourcePositions.getEndPosition(compilationUnitTree, list3.get(list3.size() - 1));
                } else if (methodTree.getReturnType() != null) {
                    l = sourcePositions.getEndPosition(compilationUnitTree, methodTree.getReturnType());
                } else if (methodTree.getModifiers() != null) {
                    l = sourcePositions.getEndPosition(compilationUnitTree, methodTree.getModifiers());
                }
            }
        }
        TokenSequence tokenSequence = compilationInfo.getTreeUtilities().tokensFor((Tree)methodTree);
        tokenSequence.move((int)l);
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != JavaTokenId.LBRACE && tokenSequence.token().id() != JavaTokenId.SEMICOLON) continue;
            return n < tokenSequence.offset();
        }
        return false;
    }

    static SourceVersion resolveSourceVersion(FileObject fileObject) {
        String string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
        if (string == null) {
            return SourceVersion.latest();
        }
        if (string.startsWith("1.6")) {
            return SourceVersion.RELEASE_6;
        }
        if (string.startsWith("1.5")) {
            return SourceVersion.RELEASE_5;
        }
        if (string.startsWith("1.4")) {
            return SourceVersion.RELEASE_4;
        }
        if (string.startsWith("1.3")) {
            return SourceVersion.RELEASE_3;
        }
        if (string.startsWith("1.2")) {
            return SourceVersion.RELEASE_2;
        }
        if (string.startsWith("1.1")) {
            return SourceVersion.RELEASE_1;
        }
        if (string.startsWith("1.0")) {
            return SourceVersion.RELEASE_0;
        }
        return SourceVersion.latest();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavadocLazyFixList
    implements LazyFixList {
        private List<Fix> contexFixes;
        private FixAll fixAll;

        public JavadocLazyFixList(List<Fix> list, FixAll fixAll) {
            this.contexFixes = list;
            this.fixAll = fixAll;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public List<Fix> getFixes() {
            if (this.fixAll.isReady()) {
                this.contexFixes.add(this.fixAll);
            }
            return this.contexFixes;
        }

        public boolean isComputed() {
            return true;
        }
    }
}

