/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.borrowed;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.modules.editor.hints.FixData;
import org.netbeans.modules.editor.hints.HintsUI;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.awt.HtmlRenderer;
import org.openide.util.Utilities;

public class ListCompletionView
extends JList
implements ListCellRenderer {
    private final HtmlRenderer.Renderer defaultRenderer = HtmlRenderer.createRenderer();
    private Font font;
    private Icon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/editor/hints/resources/suggestion.gif"));

    public ListCompletionView() {
        this.setSelectionMode(0);
        this.font = this.getFont();
        if (this.font.getSize() < 15) {
            this.font = this.font.deriveFont(this.font.getSize2D() + 1.0f);
        }
        this.setFont(this.font);
        this.setCellRenderer(this);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = this.defaultRenderer.getListCellRendererComponent(jList, (Object)(object instanceof Fix ? ((Fix)object).getText() : object.toString()), n, bl, bl2);
        this.defaultRenderer.setIcon(this.icon);
        this.defaultRenderer.setParentFocused(true);
        this.defaultRenderer.setRenderStyle(0);
        component.setBackground(jList.getBackground());
        return component;
    }

    public void setResult(FixData fixData) {
        if (fixData != null) {
            Model model = new Model(fixData);
            this.setModel(model);
            if (model.fixes != null && !model.fixes.isEmpty()) {
                this.setSelectedIndex(0);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(Math.max(this.getSelectedIndex() - 1, 0));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.repaint();
        }
    }

    public void down() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, n));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.validate();
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int n = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n2 = Math.max(this.getSelectedIndex() - n, 0);
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    public void pageDown() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            int n2 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n3 = Math.min(this.getSelectedIndex() + n2, n);
            this.setSelectedIndex(n3);
            this.ensureIndexIsVisible(n3);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    static class Model
    extends AbstractListModel
    implements PropertyChangeListener {
        private FixData data;
        private List<Fix> fixes;
        private boolean computed;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(FixData fixData) {
            this.data = fixData;
            fixData.addPropertyChangeListener(this);
            this.update();
        }

        private synchronized void update() {
            this.computed = this.data.isComputed();
            if (this.computed) {
                this.fixes = this.data.getSortedFixes();
            } else {
                this.data.getSortedFixes();
            }
        }

        public synchronized int getSize() {
            return this.computed ? this.fixes.size() : 1;
        }

        public synchronized Object getElementAt(int n) {
            if (!this.computed) {
                return "computing...";
            }
            return this.fixes.get(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HintsUI.getDefault().removePopups();
                    HintsUI.getDefault().showPopup(Model.this.data);
                }
            });
        }
    }
}

