/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;
import org.netbeans.modules.diff.options.AccessibleJFileChooser;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExportPatch {
    private static final FileFilter unifiedFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith("diff") || file.getName().endsWith("patch") || file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(ExportPatch.class, (String)"FileFilter_Unified");
        }
    };
    private static final FileFilter normalFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith("diff") || file.getName().endsWith("patch") || file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(ExportPatch.class, (String)"FileFilter_Normal");
        }
    };

    public static void exportPatch(final StreamSource[] streamSourceArray, final StreamSource[] streamSourceArray2) {
        Object object;
        final AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ExportPatch.class, (String)"ACSD_Export"));
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(ExportPatch.class, (String)"CTL_Export_Title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            object = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter((FileFilter)object);
        }
        accessibleJFileChooser.setCurrentDirectory(new File(DiffModuleConfig.getDefault().getPreferences().get("ExportDiff.saveFolder", System.getProperty("user.home"))));
        accessibleJFileChooser.addChoosableFileFilter(normalFilter);
        accessibleJFileChooser.addChoosableFileFilter(unifiedFilter);
        accessibleJFileChooser.setDialogType(1);
        accessibleJFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ExportPatch.class, (String)"MNE_Export_ExportAction").charAt(0));
        accessibleJFileChooser.setApproveButtonText(NbBundle.getMessage(ExportPatch.class, (String)"CTL_Export_ExportAction"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)accessibleJFileChooser, NbBundle.getMessage(ExportPatch.class, (String)"CTL_Export_Title"));
        dialogDescriptor.setOptions(new Object[0]);
        object = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        accessibleJFileChooser.addActionListener(new ActionListener((Dialog)object){
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    File file;
                    File file2 = accessibleJFileChooser.getSelectedFile();
                    String string2 = file2.getName();
                    boolean bl = false;
                    final FileFilter fileFilter = accessibleJFileChooser.getFileFilter();
                    bl |= string2.endsWith(".diff");
                    if (!(bl |= string2.endsWith(".patch"))) {
                        file = file2.getParentFile();
                        file2 = new File(file, string2 + ".patch");
                    }
                    if (file2.exists()) {
                        file = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportPatch.class, (String)"BK3005", (Object)file2.getAbsolutePath()));
                        file.setOptionType(0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
                        if (!file.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                            return;
                        }
                    }
                    DiffModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file2.getParent());
                    file = file2;
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            ExportPatch.exportDiff(streamSourceArray, streamSourceArray2, file, fileFilter);
                        }
                    });
                }
                this.val$dialog.dispose();
            }
        });
        ((Dialog)object).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportDiff(StreamSource[] streamSourceArray, StreamSource[] streamSourceArray2, File file, FileFilter fileFilter) {
        boolean bl = false;
        OutputStream outputStream = null;
        int n = 0;
        try {
            String string = System.getProperty("line.separator");
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream.write(("# This patch file was generated by NetBeans IDE" + string).getBytes("utf8"));
            outputStream.write(("# This patch can be applied using context Tools: Apply Diff Patch action on respective folder." + string).getBytes("utf8"));
            outputStream.write(("# It uses platform neutral UTF-8 encoding." + string).getBytes("utf8"));
            outputStream.write(("# Above lines and this line are ignored by the patching process." + string).getBytes("utf8"));
            for (int i = 0; i < streamSourceArray.length; ++i) {
                ExportPatch.exportDiff(streamSourceArray[i], streamSourceArray2[i], outputStream, fileFilter);
                ++n;
            }
            bl = true;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(ExportPatch.class, (String)"BK3003"));
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            ErrorManager.getDefault().notify(256, (Throwable)iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportPatch.class, (String)"BK3004", (Object)new Integer(n)));
                if (n == 0) {
                    file.delete();
                } else {
                    ExportPatch.openFile(file);
                }
            } else {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportDiff(StreamSource streamSource, StreamSource streamSource2, OutputStream outputStream, FileFilter fileFilter) throws IOException {
        Difference[] differenceArray;
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        Reader reader = null;
        Reader reader2 = null;
        try {
            reader = streamSource.createReader();
            if (reader == null) {
                reader = new StringReader("");
            }
            if ((reader2 = streamSource2.createReader()) == null) {
                reader2 = new StringReader("");
            }
            differenceArray = diffProvider.computeDiff(reader, reader2);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (reader2 != null) {
                try {
                    reader2.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            int n;
            reader = streamSource.createReader();
            if (reader == null) {
                reader = new StringReader("");
            }
            if ((reader2 = streamSource2.createReader()) == null) {
                reader2 = new StringReader("");
            }
            TextDiffVisualizer.TextDiffInfo textDiffInfo = new TextDiffVisualizer.TextDiffInfo(streamSource.getTitle(), streamSource2.getTitle(), null, null, reader, reader2, differenceArray);
            textDiffInfo.setContextMode(true, 3);
            String string = fileFilter == unifiedFilter ? TextDiffVisualizer.differenceToUnifiedDiffText(textDiffInfo) : TextDiffVisualizer.differenceToNormalDiffText(textDiffInfo);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("utf8"));
            while ((n = ((InputStream)byteArrayInputStream).read()) != -1) {
                outputStream.write(n);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (reader2 != null) {
                try {
                    reader2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void openFile(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private ExportPatch() {
    }
}

