/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.GoToSourceProvider;

public class GoToJavaSourceProvider
implements GoToSourceProvider {
    public boolean openSource(Project project, final String string, final String string2, final String string3) {
        final JavaSource javaSource = SourceUtils.getSources((Project)project);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Parameterizable parameterizable = null;
                    TypeElement typeElement = SourceUtils.resolveClassByName((String)string, (CompilationController)compilationController);
                    if (string2 != null && string2.length() > 0 && typeElement != null) {
                        parameterizable = SourceUtils.resolveMethodByName((TypeElement)typeElement, (String)string2, (String)string3);
                    }
                    if (parameterizable == null) {
                        parameterizable = typeElement;
                    }
                    if (parameterizable != null) {
                        ProfilerLogger.debug((String)("Opening element: " + parameterizable));
                        final Parameterizable parameterizable2 = parameterizable;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                atomicBoolean.set(ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)parameterizable2));
                                countDownLatch.countDown();
                            }
                        });
                    } else {
                        countDownLatch.countDown();
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return atomicBoolean.get();
    }
}

