/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;

public class EnableDisableProfilingPointAction
extends BooleanStateAction {
    private static final String ACTION_NAME = NbBundle.getMessage(EnableDisableProfilingPointAction.class, (String)"EnableDisableProfilingPointAction_ActionName");

    public EnableDisableProfilingPointAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void setBooleanState(boolean bl) {
        CodeProfilingPoint codeProfilingPoint = this.getCurrentProfilingPoint();
        if (codeProfilingPoint != null) {
            codeProfilingPoint.setEnabled(bl);
        }
        super.setBooleanState(bl);
    }

    public boolean isEnabled() {
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            return false;
        }
        CodeProfilingPoint codeProfilingPoint = this.getCurrentProfilingPoint();
        if (codeProfilingPoint == null) {
            return false;
        }
        super.setBooleanState(codeProfilingPoint.isEnabled());
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EnableDisableProfilingPointAction.class);
    }

    public String getName() {
        return ACTION_NAME;
    }

    private CodeProfilingPoint getCurrentProfilingPoint() {
        CodeProfilingPoint[] codeProfilingPointArray = Utils.getProfilingPointsOnLine(Utils.getCurrentLocation(0));
        if (codeProfilingPointArray.length == 0) {
            return null;
        }
        return codeProfilingPointArray[0];
    }
}

