/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public abstract class ProfilingPointFactory {
    public static final String AVAILABILITY_PROPERTY = ProfilingPointFactory.class.getName() + "#AVAILABILITY";
    private static final String PROFILING_POINT_STORAGE_EXT = "pp";
    public static final int SCOPE_CODE = 1;
    public static final int SCOPE_GLOBAL = 2;
    public static final Icon SCOPE_CODE_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ppoints/ui/resources/codeProfilingPoint.png"));
    public static final Icon SCOPE_GLOBAL_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ppoints/ui/resources/globalProfilingPoint.png"));
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ValidityAwarePanel customizer = null;

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public boolean isAvailable() {
        return true;
    }

    public abstract String getDescription();

    public abstract Icon getIcon();

    public abstract int getScope();

    public abstract String getType();

    public ProfilingPoint create() {
        return this.create(null);
    }

    public abstract ProfilingPoint create(Project var1);

    public abstract boolean supportsCPU();

    public abstract boolean supportsMemory();

    public abstract boolean supportsMonitor();

    public Icon getScopeIcon() {
        switch (this.getScope()) {
            case 1: {
                return SCOPE_CODE_ICON;
            }
            case 2: {
                return SCOPE_GLOBAL_ICON;
            }
        }
        return null;
    }

    protected abstract Class getProfilingPointsClass();

    protected abstract ValidityAwarePanel createCustomizer();

    protected abstract ProfilingPoint loadProfilingPoint(Project var1, Properties var2, int var3);

    protected abstract void storeProfilingPoint(ProfilingPoint var1, int var2, Properties var3);

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    ValidityAwarePanel getCustomizer() {
        if (this.customizer == null) {
            this.customizer = this.createCustomizer();
        }
        ValidityAwarePanel validityAwarePanel = ProfilingPointsManager.getDefault().safeGetCustomizer(this.customizer);
        return validityAwarePanel;
    }

    ProfilingPoint[] loadProfilingPoints(Project project) throws IOException, InvalidPropertiesFormatException {
        ProfilingPoint[] profilingPointArray;
        LinkedList<ProfilingPoint> linkedList = new LinkedList<ProfilingPoint>();
        Properties properties = new Properties();
        FileObject fileObject = this.getProfilingPointsStorage(project);
        if (fileObject != null) {
            profilingPointArray = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)profilingPointArray);
            properties.loadFromXML(bufferedInputStream);
            bufferedInputStream.close();
            int n = 0;
            while (properties.getProperty(n + "_" + "p_name") != null) {
                ProfilingPoint profilingPoint = this.loadProfilingPoint(project, properties, n);
                if (profilingPoint != null) {
                    linkedList.add(profilingPoint);
                } else {
                    ErrorManager.getDefault().log(65536, "Invalid " + this.getType() + " Profiling Point format at index " + n + " in project " + ProjectUtils.getInformation((Project)project).getDisplayName());
                }
                ++n;
            }
        }
        profilingPointArray = new ProfilingPoint[linkedList.size()];
        linkedList.toArray(profilingPointArray);
        return profilingPointArray;
    }

    void saveProfilingPoints(Project project) throws IOException {
        this.saveProfilingPoints(ProfilingPointsManager.getDefault().getProfilingPoints(this.getProfilingPointsClass(), project).toArray(new ProfilingPoint[0]), project);
    }

    private FileObject getProfilingPointsStorage(Project project) throws IOException {
        FileObject fileObject = IDEUtils.getProjectSettingsFolder(project, false);
        if (fileObject == null) {
            return null;
        }
        String string = this.getProfilingPointsClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        FileObject fileObject2 = fileObject.getFileObject(string2, PROFILING_POINT_STORAGE_EXT);
        return fileObject2;
    }

    private FileObject createProfilingPointsStorage(Project project) throws IOException {
        FileObject fileObject = IDEUtils.getProjectSettingsFolder(project, true);
        String string = this.getProfilingPointsClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        FileObject fileObject2 = fileObject.createData(string2, PROFILING_POINT_STORAGE_EXT);
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProfilingPointsStorage(Project project) throws IOException {
        FileObject fileObject = this.getProfilingPointsStorage(project);
        if (fileObject != null) {
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (Exception exception) {
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    private void saveProfilingPoints(ProfilingPoint[] profilingPointArray, Project project) throws IOException {
        if (profilingPointArray.length > 0) {
            FileObject fileObject = this.getProfilingPointsStorage(project);
            if (fileObject == null) {
                fileObject = this.createProfilingPointsStorage(project);
            }
            if (fileObject != null) {
                Properties properties = new Properties();
                for (int i = 0; i < profilingPointArray.length; ++i) {
                    this.storeProfilingPoint(profilingPointArray[i], i, properties);
                }
                this.storeSettings(fileObject, properties);
            }
        } else {
            this.deleteProfilingPointsStorage(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSettings(FileObject fileObject, Properties properties) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties.storeToXML(outputStream, null);
            bufferedOutputStream.close();
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }
}

