/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.impl.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.impl.ui.Log;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DebugConfigPanel
extends JPanel {
    private final boolean ffBrowserSupported;
    private final boolean ieBrowserSupported;
    private final Preferences globalPrefs;
    private ButtonGroup browserButtonGroup;
    private JCheckBox debugCheckBox;
    private JLabel debugPropertyMsg;
    private JCheckBox doNotShowAgain;
    private JRadioButton firefoxRadioButton;
    private JRadioButton internetExplorerRadioButton;

    public DebugConfigPanel(boolean bl, boolean bl2, Preferences preferences) {
        this.initComponents();
        this.ffBrowserSupported = bl;
        this.ieBrowserSupported = bl2;
        this.globalPrefs = preferences;
        this.debugCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DebugConfigPanel.this.adjustBrowserRadioButtons(false);
            }
        });
        this.debugCheckBox.setSelected(preferences.getBoolean("clientDebugSwitch", true));
        this.adjustBrowserRadioButtons(true);
    }

    private void adjustBrowserRadioButtons(boolean bl) {
        if (bl) {
            if (this.ffBrowserSupported && !this.ieBrowserSupported) {
                this.firefoxRadioButton.setSelected(true);
            } else if (this.ieBrowserSupported && !this.ffBrowserSupported) {
                this.internetExplorerRadioButton.setSelected(true);
            } else {
                String string = this.ffBrowserSupported ? WebClientToolsProjectUtils.Browser.FIREFOX.name() : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name();
                String string2 = this.globalPrefs.get("debugConfigBrowser", string);
                WebClientToolsProjectUtils.Browser browser = WebClientToolsProjectUtils.Browser.valueOf((String)string2);
                this.firefoxRadioButton.setSelected(browser == WebClientToolsProjectUtils.Browser.FIREFOX);
                this.internetExplorerRadioButton.setSelected(browser == WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER);
            }
        }
        this.firefoxRadioButton.setEnabled(this.debugCheckBox.isSelected() && this.ffBrowserSupported);
        this.internetExplorerRadioButton.setEnabled(this.debugCheckBox.isSelected() && this.ieBrowserSupported);
    }

    public ActionListener getPanelCloseHandler() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    boolean bl = DebugConfigPanel.this.debugCheckBox.isSelected();
                    boolean bl2 = !DebugConfigPanel.this.doNotShowAgain.isSelected();
                    String string = DebugConfigPanel.this.firefoxRadioButton.isSelected() ? WebClientToolsProjectUtils.Browser.FIREFOX.name() : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name();
                    DebugConfigPanel.this.globalPrefs.putBoolean("clientDebugSwitch", bl);
                    DebugConfigPanel.this.globalPrefs.putBoolean("debugConfigShowDialog", bl2);
                    DebugConfigPanel.this.globalPrefs.put("debugConfigBrowser", string);
                    try {
                        DebugConfigPanel.this.globalPrefs.sync();
                    }
                    catch (BackingStoreException backingStoreException) {
                        Log.getLogger().log(Level.WARNING, "Could not save preferences", backingStoreException);
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.browserButtonGroup = new ButtonGroup();
        this.debugCheckBox = new JCheckBox();
        this.firefoxRadioButton = new JRadioButton();
        this.internetExplorerRadioButton = new JRadioButton();
        this.debugPropertyMsg = new JLabel();
        this.doNotShowAgain = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckBox, (String)NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.debugCheckBox.text"));
        this.browserButtonGroup.add(this.firefoxRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.firefoxRadioButton.text"));
        this.browserButtonGroup.add(this.internetExplorerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.internetExplorerRadioButton, (String)NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.internetExplorerRadioButton.text"));
        this.debugPropertyMsg.setText(NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.debugPropertyMsg.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.doNotShowAgain, (String)NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.doNotShowAgain.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.debugCheckBox).add((Component)this.debugPropertyMsg, -2, 404, -2).add((Component)this.doNotShowAgain).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.internetExplorerRadioButton).add((Component)this.firefoxRadioButton)))).addContainerGap(58, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.debugCheckBox).addPreferredGap(0).add((Component)this.firefoxRadioButton).addPreferredGap(0).add((Component)this.internetExplorerRadioButton, -2, 29, -2).add(12, 12, 12).add((Component)this.debugPropertyMsg, -2, 81, -2).addPreferredGap(0, 15, Short.MAX_VALUE).add((Component)this.doNotShowAgain).addContainerGap()));
        this.debugCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.debugCheckBox.AccessibleContext.accessibleDescription"));
        this.firefoxRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.firefoxRadioButton.AccessibleContext.accessibleDescription"));
        this.internetExplorerRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.internetExplorerRadioButton.AccessibleContext.accessibleDescription"));
        this.doNotShowAgain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugConfigPanel.class, (String)"DebugConfigPanel.doNotShowAgain.AccessibleContext.accessibleDescription"));
    }
}

