/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;

final class NbJSBreakpointLineUpdater
implements PropertyChangeListener {
    private final NbJSBreakpoint breakpoint;
    private Line line;

    public NbJSBreakpointLineUpdater(NbJSBreakpoint nbJSBreakpoint) {
        assert (nbJSBreakpoint != null);
        this.breakpoint = nbJSBreakpoint;
    }

    public synchronized void attach() throws IOException {
        FileObject fileObject = this.breakpoint.getFileObject();
        if (fileObject != null) {
            assert (fileObject != null);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            this.breakpoint.addPropertyChangeListener(this);
            try {
                this.line = lineCookie.getLineSet().getCurrent(this.breakpoint.getLineNumber() - 1);
                this.line.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public synchronized void detach() {
        this.breakpoint.removePropertyChangeListener(this);
        if (this.line != null) {
            this.line.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("lineNumber".equals(propertyChangeEvent.getPropertyName())) {
            this.breakpoint.notifyUpdated(propertyChangeEvent.getSource());
            return;
        }
    }
}

