/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.form.valid;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultValidator
implements Validator {
    private ValidStateManager.Provider myVSMProvider;
    private List<Validator.Reason> myReasons;
    private Class myBundleLocator;

    public DefaultValidator(Component component, Class clazz) {
        this.myVSMProvider = new DefaultValidStateManager.DefaultVsmProvider(component);
        this.myBundleLocator = clazz;
    }

    public DefaultValidator(ValidStateManager.Provider provider, Class clazz) {
        this.myVSMProvider = provider;
        this.myBundleLocator = clazz;
    }

    @Override
    public void revalidate(boolean bl) {
        ValidStateManager validStateManager = this.myVSMProvider.getValidStateManager(bl);
        if (validStateManager != null) {
            this.clearReasons();
            this.doValidation(bl);
            validStateManager.processValidationResults(this);
        }
    }

    @Override
    public void doValidation(boolean bl) {
        if (bl) {
            this.doFastValidation();
        } else {
            this.doDetailedValidation();
        }
    }

    @Override
    public void clearReasons() {
        if (this.myReasons != null && !this.myReasons.isEmpty()) {
            this.myReasons.clear();
        }
    }

    @Override
    public Validator.Reason getReason() {
        if (this.myReasons != null && !this.myReasons.isEmpty()) {
            return this.myReasons.get(0);
        }
        return null;
    }

    @Override
    public List<Validator.Reason> getReasons() {
        return this.myReasons;
    }

    @Override
    public List<Validator.Reason> getReasons(Validator.Severity severity) {
        if (this.myReasons == null) {
            return null;
        }
        ArrayList<Validator.Reason> arrayList = new ArrayList<Validator.Reason>();
        for (Validator.Reason reason : this.myReasons) {
            if (reason.getSeverity() != severity) continue;
            arrayList.add(reason);
        }
        return arrayList;
    }

    @Override
    public boolean hasReasons(Validator.Severity severity) {
        if (severity == null) {
            return this.myReasons != null && !this.myReasons.isEmpty();
        }
        if (this.myReasons != null) {
            for (Validator.Reason reason : this.myReasons) {
                if (reason.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    public void addReason(Validator.Reason reason) {
        if (this.myReasons == null) {
            this.myReasons = new ArrayList<Validator.Reason>();
        }
        this.myReasons.add(reason);
    }

    public void addReasons(List<Validator.Reason> list) {
        this.myReasons.addAll(list);
    }

    public void setReason(Validator.Reason reason) {
        this.myReasons = new ArrayList<Validator.Reason>();
        this.myReasons.add(reason);
    }

    public void setReasonKey(Validator.Severity severity, String string) {
        String string2 = NbBundle.getMessage((Class)this.myBundleLocator, (String)string);
        Validator.Reason reason = new Validator.Reason(severity, string2);
        this.setReason(reason);
    }

    public void addReasonKey(Validator.Severity severity, String string) {
        String string2 = NbBundle.getMessage((Class)this.myBundleLocator, (String)string);
        Validator.Reason reason = new Validator.Reason(severity, string2);
        this.addReason(reason);
    }

    public void addReasonKey(Validator.Severity severity, String string, String ... stringArray) {
        String string2 = NbBundle.getMessage((Class)this.myBundleLocator, (String)string, (Object[])stringArray);
        Validator.Reason reason = new Validator.Reason(severity, string2);
        this.addReason(reason);
    }

    @Override
    public void doDetailedValidation() {
        this.doFastValidation();
    }
}

