/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.soa.ui.UndoRedoManagerProvider;
import org.netbeans.modules.soa.ui.form.InitialFocusProvider;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoaUtil {
    public static Color MISTAKE_RED = new Color(204, 0, 0);
    public static Color INACTIVE_BLUE = new Color(0, 102, 153);
    public static Color HTML_GRAY = new Color(153, 153, 153);
    private static String GRAY_COLOR = "#999999";

    private SoaUtil() {
    }

    public static String getGrayString(String string) {
        return SoaUtil.getGrayString("", string);
    }

    public static String getGrayString(String string, String string2) {
        return string2 == null ? string : "<html>" + SoaUtil.getCorrectedHtmlRenderedString(string) + "<font color='" + GRAY_COLOR + "'>" + SoaUtil.getCorrectedHtmlRenderedString(string2) + "</font></html>";
    }

    public static String getGrayString(String string, String string2, String string3) {
        return SoaUtil.getGrayString(string, string2, string3, true);
    }

    public static String getGrayString(String string, String string2, String string3, boolean bl) {
        String string4;
        String string5 = bl ? "<html>" : "";
        String string6 = string4 = bl ? "</html>" : "";
        return string2 == null ? string : string5 + SoaUtil.getCorrectedHtmlRenderedString(string) + "<font color='" + GRAY_COLOR + "'>" + SoaUtil.getCorrectedHtmlRenderedString(string2) + "</font>" + (string3 == null ? "" : SoaUtil.getCorrectedHtmlRenderedString(string3)) + string4;
    }

    public static String getFormattedHtmlString(boolean bl, TextChunk ... textChunkArray) {
        String string = bl ? "<html>" : "";
        String string2 = bl ? "</html>" : "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        TextChunk textChunk = null;
        boolean bl3 = false;
        for (TextChunk textChunk2 : textChunkArray) {
            boolean bl4;
            if (textChunk2.myText == null || textChunk2.myText.length() == 0) continue;
            boolean bl5 = bl4 = textChunk == null ? false : textChunk.hasSameTextAttributes(textChunk2);
            if (bl3 && !bl4) {
                stringBuffer.append("</font>");
            }
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(" ");
            }
            if (textChunk2.myColor == null) {
                stringBuffer.append(SoaUtil.getCorrectedHtmlRenderedString(textChunk2.myText));
                bl3 = false;
            } else {
                if (!bl3 || bl3 && !bl4) {
                    stringBuffer.append("<font color='" + SoaUtil.getHtmlColor(textChunk2.myColor) + "'>");
                }
                stringBuffer.append(SoaUtil.getCorrectedHtmlRenderedString(textChunk2.myText));
                bl3 = true;
            }
            textChunk = textChunk2;
        }
        if (bl3) {
            stringBuffer.append("</font>");
        }
        return string + stringBuffer.toString() + string2;
    }

    public static String getHtmlColor(Color color) {
        int n = color.getRed();
        String string = n == 0 ? "00" : Integer.toHexString(n);
        int n2 = color.getGreen();
        String string2 = n2 == 0 ? "00" : Integer.toHexString(n2);
        int n3 = color.getBlue();
        String string3 = n3 == 0 ? "00" : Integer.toHexString(n3);
        return "#" + string + string2 + string3;
    }

    public static Image getBadgedIcon(Image image, Image image2) {
        return SoaUtil.getBadgedIcon(image, image2, 9, 0);
    }

    public static Image getBadgedIcon(Image image, Image image2, int n, int n2) {
        if (image == null) {
            return null;
        }
        if (image2 == null) {
            return image;
        }
        Image image3 = Utilities.mergeImages((Image)image, (Image)image2, (int)n, (int)n2);
        return image3;
    }

    public static final String getCorrectedHtmlRenderedString(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("&amp;", "&");
        string = string.replaceAll("&gt;", ">;");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        return string;
    }

    public static <T> T lookForChildByClass(Container container, Class<T> clazz) {
        for (Component component : container.getComponents()) {
            if (clazz.isInstance(component)) {
                return clazz.cast(component);
            }
            if (!(component instanceof Container)) continue;
            return SoaUtil.lookForChildByClass((Container)component, clazz);
        }
        return null;
    }

    public static <T> Collection<T> lookForChildrenByClass(Container container, Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        SoaUtil.lookForChildrenByClass(container, clazz, arrayList);
        return arrayList;
    }

    private static <T> void lookForChildrenByClass(Container container, Class<T> clazz, Collection<T> collection) {
        for (Component component : container.getComponents()) {
            if (clazz.isInstance(component)) {
                T t = clazz.cast(component);
                collection.add(t);
            }
            if (!(component instanceof Container)) continue;
            SoaUtil.lookForChildrenByClass((Container)component, clazz, collection);
        }
    }

    public static Component getInitialFocusComponent(Container container) {
        Collection<InitialFocusProvider> collection = SoaUtil.lookForChildrenByClass(container, InitialFocusProvider.class);
        int n = Integer.MIN_VALUE;
        Component component = null;
        for (InitialFocusProvider initialFocusProvider : collection) {
            int n2 = initialFocusProvider.getProviderPriority();
            if (n2 <= n) continue;
            n = n2;
            component = initialFocusProvider.getInitialFocusComponent();
        }
        return component;
    }

    public static boolean setInitialFocusComponentFor(Container container) {
        Component component = SoaUtil.getInitialFocusComponent(container);
        if (component != null) {
            return component.requestFocusInWindow();
        }
        return false;
    }

    public static void fixEncoding(DataObject dataObject, FileObject fileObject) throws IOException {
        DataEditorSupport dataEditorSupport = (DataEditorSupport)dataObject.getLookup().lookup(DataEditorSupport.class);
        if (!(dataEditorSupport instanceof UndoRedoManagerProvider)) {
            return;
        }
        UndoRedo.Manager manager = ((UndoRedoManagerProvider)dataEditorSupport).getUndoRedoManager();
        String string = EncodingUtil.getProjectEncoding((FileObject)DataFolder.findFolder((FileObject)fileObject).getPrimaryFile());
        if (string == null || !EncodingUtil.isValidEncoding((String)string)) {
            string = "UTF-8";
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        StyledDocument styledDocument = editorCookie.openDocument();
        try {
            styledDocument.insertString(19, " encoding=\"" + string + "\"", null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            saveCookie.save();
        }
        if (manager == null) {
            return;
        }
        manager.discardAllEdits();
    }

    public static TopComponent safeFindTopComponent(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        TopComponent topComponent = null;
        if (SwingUtilities.isEventDispatchThread()) {
            topComponent = WindowManager.getDefault().findTopComponent(string);
        } else {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SafeFindTopComponent
            implements Runnable {
                private TopComponent myTopComponent;
                final /* synthetic */ String val$tcId;

                SafeFindTopComponent(String string) {
                    this.val$tcId = string;
                }

                @Override
                public void run() {
                    this.myTopComponent = WindowManager.getDefault().findTopComponent(this.val$tcId);
                }

                public TopComponent getTopComponent() {
                    return this.myTopComponent;
                }
            }
            SafeFindTopComponent safeFindTopComponent = new SafeFindTopComponent(string);
            try {
                SwingUtilities.invokeAndWait(safeFindTopComponent);
                topComponent = safeFindTopComponent.getTopComponent();
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify(4096, (Throwable)interruptedException);
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(4096, (Throwable)invocationTargetException);
                return null;
            }
        }
        return topComponent;
    }

    public static void activateInlineMnemonics(Container container) {
        for (Component component : container.getComponents()) {
            JComponent jComponent;
            if (component instanceof JLabel) {
                jComponent = (JLabel)component;
                Mnemonics.setLocalizedText((JLabel)jComponent, (String)((JLabel)jComponent).getText());
                continue;
            }
            if (component instanceof AbstractButton) {
                jComponent = (AbstractButton)component;
                Mnemonics.setLocalizedText((AbstractButton)jComponent, (String)((AbstractButton)jComponent).getText());
                continue;
            }
            if (!(component instanceof Container)) continue;
            SoaUtil.activateInlineMnemonics((Container)component);
        }
    }

    public static void fireHelpContextChange(Component component, HelpCtx helpCtx) {
        Container container = component.getParent();
        if (container != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(component, "helpCtx", null, helpCtx);
            while (true) {
                Container container2;
                if (container instanceof PropertyChangeListener) {
                    ((PropertyChangeListener)((Object)container)).propertyChange(propertyChangeEvent);
                }
                if ((container2 = container.getParent()) == null || container2 == container) break;
                container = container2;
            }
        }
    }

    public static FileObject getFileObjectByModel(Model model) {
        if (model == null) {
            return null;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return null;
        }
        Lookup lookup = modelSource.getLookup();
        if (lookup == null) {
            return null;
        }
        return (FileObject)lookup.lookup(FileObject.class);
    }

    public static void openActiveMVEditor(String string) {
        if (string == null) {
            return;
        }
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return;
        }
        MultiViewPerspective[] multiViewPerspectiveArray = multiViewHandler.getPerspectives();
        if (multiViewPerspectiveArray != null && multiViewPerspectiveArray.length > 0) {
            for (MultiViewPerspective multiViewPerspective : multiViewPerspectiveArray) {
                if (!multiViewPerspective.preferredID().equals(string)) continue;
                multiViewHandler.requestVisible(multiViewPerspective);
                multiViewHandler.requestActive(multiViewPerspective);
            }
        }
    }

    public static int getLineNum(DocumentComponent documentComponent) {
        int n = documentComponent.findPosition();
        ModelSource modelSource = documentComponent.getModel().getModelSource();
        assert (modelSource != null);
        Lookup lookup = modelSource.getLookup();
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
    }

    public static int getColumnNum(DocumentComponent documentComponent) {
        int n = documentComponent.findPosition();
        ModelSource modelSource = documentComponent.getModel().getModelSource();
        assert (modelSource != null);
        Lookup lookup = modelSource.getLookup();
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
    }

    public static File getRoot(File file) {
        String string;
        int n;
        File file2;
        File file3 = null;
        file3 = file2 = file;
        while (file2 != null) {
            file3 = file2;
            file2 = file2.getParentFile();
        }
        if ("\\\\".equals(file3.getPath()) && (n = (string = file.getAbsolutePath()).indexOf("\\", 2)) != -1) {
            int n2 = string.indexOf("\\", n + 1);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            file3 = new File(string);
        }
        return file3;
    }

    public static class TextChunk {
        String myText = null;
        Color myColor = null;

        public TextChunk(String string) {
            this.myText = string;
        }

        public TextChunk(String string, Color color) {
            this.myText = string;
            this.myColor = color;
        }

        public boolean hasSameTextAttributes(TextChunk textChunk) {
            if (textChunk == null) {
                return false;
            }
            return textChunk.myColor == this.myColor;
        }
    }
}

